/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.api.webmodule.WebFrameworks;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.jsploader.JspCompileUtil;
import org.netbeans.modules.web.spi.webmodule.RequestParametersQueryImplementation;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.openide.filesystems.FileObject;

public class WebExecSupport
implements RequestParametersQueryImplementation {
    private static final Logger LOG = Logger.getLogger(WebExecSupport.class.getName());
    public static final String EA_REQPARAMS = "NetBeansAttrReqParams";

    public static void setQueryString(FileObject fo, String qStr) throws IOException {
        fo.setAttribute(EA_REQPARAMS, (Object)qStr);
    }

    public static String getQueryString(FileObject fo) {
        try {
            String qStr = (String)fo.getAttribute(EA_REQPARAMS);
            if (qStr != null) {
                if (qStr.length() > 0 && !qStr.startsWith("?")) {
                    qStr = "?" + qStr;
                }
                return qStr;
            }
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "error", ex);
        }
        return "";
    }

    public String getFileAndParameters(FileObject f) {
        FileObject docBase;
        List frameworks = WebFrameworks.getFrameworks();
        String url = null;
        WebModule wm = WebModule.getWebModule((FileObject)f);
        if (wm != null && frameworks.size() > 0) {
            WebFrameworkProvider frameworkProvider;
            Iterator iterator = frameworks.iterator();
            while (iterator.hasNext() && (!(frameworkProvider = (WebFrameworkProvider)iterator.next()).isInWebModule(wm) || (url = frameworkProvider.getServletPath(f)) == null)) {
            }
        }
        if (url == null & wm != null && (docBase = wm.getDocumentBase()) != null) {
            url = JspCompileUtil.findRelativeContextPath(docBase, f);
        }
        if (url != null) {
            url = url + WebExecSupport.getQueryString(f);
            url = url.replace(" ", "%20");
        }
        return url;
    }
}

