/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.mercurial.ui.diff.Bundle;
import org.netbeans.modules.mercurial.ui.diff.DiffToRevisionPanel;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.repository.HeadRevisionPicker;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;

public class DiffToRevision
implements ActionListener {
    private final DiffToRevisionPanel panel;
    private final JButton okButton;
    private final JButton cancelButton;
    private final File repository;
    private final HgLogMessage.HgRevision baseRevision;
    private final Map<JRadioButton, HgLogMessage.HgRevision> selectionsFirst = new HashMap<JRadioButton, HgLogMessage.HgRevision>();
    private final Map<JRadioButton, HgLogMessage.HgRevision> selectionsSecond = new HashMap<JRadioButton, HgLogMessage.HgRevision>();
    private JRadioButton selectedOption;

    public DiffToRevision(File repository, HgLogMessage.HgRevision base) {
        this.repository = repository;
        this.baseRevision = base;
        this.panel = new DiffToRevisionPanel();
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)Bundle.CTL_DiffToRevision_okButton_text());
        this.okButton.getAccessibleContext().setAccessibleDescription(Bundle.CTL_DiffToRevision_okButton_ACSD());
        this.cancelButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)Bundle.CTL_DiffToRevision_cancelButton_text());
        this.cancelButton.getAccessibleContext().setAccessibleDescription(Bundle.CTL_DiffToRevision_cancelButton_ACSD());
        this.initializeSelections();
        this.attachListeners();
        this.panel.rbLocalToAny.doClick();
    }

    public boolean showDialog() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.panel, Bundle.CTL_DiffToRevision_ACSD());
        dialogDescriptor.setOptions(new Object[]{this.okButton, this.cancelButton});
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(new HelpCtx("org.netbeans.modules.mercurial.ui.diff.DiffToRevisionPanel"));
        dialogDescriptor.setValid(false);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(Bundle.CTL_DiffToRevision_ACSD());
        dialog.setVisible(true);
        dialog.setResizable(false);
        boolean ret = dialogDescriptor.getValue() == this.okButton;
        return ret;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HeadRevisionPicker picker;
        if (e.getSource() == this.panel.rbLocalToBase) {
            this.setEnabled(this.panel.localToRevisionPanel, false);
            this.setEnabled(this.panel.baseToRevisionPanel, false);
            this.selectedOption = this.panel.rbLocalToBase;
        } else if (e.getSource() == this.panel.rbLocalToAny) {
            this.setEnabled(this.panel.localToRevisionPanel, true);
            this.setEnabled(this.panel.baseToRevisionPanel, false);
            this.selectedOption = this.panel.rbLocalToAny;
        } else if (e.getSource() == this.panel.rbBaseToAny) {
            this.setEnabled(this.panel.localToRevisionPanel, false);
            this.setEnabled(this.panel.baseToRevisionPanel, true);
            this.selectedOption = this.panel.rbBaseToAny;
        } else if (e.getSource() == this.panel.btnSelectBaseToAny) {
            HeadRevisionPicker picker2 = new HeadRevisionPicker(this.repository, null);
            if (picker2.showDialog()) {
                HgLogMessage msg = picker2.getSelectionRevision();
                this.selectionsFirst.put(this.panel.rbBaseToAny, msg.getHgRevision());
                this.panel.tfSelectedRevisionBaseToAny.setText(msg.toAnnotatedString(this.baseRevision.getChangesetId()));
            }
        } else if (e.getSource() == this.panel.btnSelectLocalToAny && (picker = new HeadRevisionPicker(this.repository, null)).showDialog()) {
            HgLogMessage msg = picker.getSelectionRevision();
            this.selectionsFirst.put(this.panel.rbLocalToAny, msg.getHgRevision());
            this.panel.tfSelectedRevisionLocalToAny.setText(msg.toAnnotatedString(this.baseRevision.getChangesetId()));
        }
    }

    public HgLogMessage.HgRevision getSelectedTreeFirst() {
        return this.selectionsFirst.get(this.selectedOption);
    }

    public HgLogMessage.HgRevision getSelectedTreeSecond() {
        return this.selectionsSecond.get(this.selectedOption);
    }

    private void attachListeners() {
        this.panel.btnSelectBaseToAny.addActionListener(this);
        this.panel.btnSelectLocalToAny.addActionListener(this);
        this.panel.rbLocalToBase.addActionListener(this);
        this.panel.rbLocalToAny.addActionListener(this);
        this.panel.rbBaseToAny.addActionListener(this);
    }

    private void setEnabled(JPanel panel, boolean enabled) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            panel.getComponent(i).setEnabled(enabled);
        }
    }

    private void initializeSelections() {
        this.selectionsFirst.put(this.panel.rbLocalToBase, HgLogMessage.HgRevision.BASE);
        this.selectionsFirst.put(this.panel.rbLocalToAny, this.baseRevision);
        this.selectionsFirst.put(this.panel.rbBaseToAny, this.baseRevision);
        this.selectionsSecond.put(this.panel.rbLocalToBase, HgLogMessage.HgRevision.CURRENT);
        this.selectionsSecond.put(this.panel.rbLocalToAny, HgLogMessage.HgRevision.CURRENT);
        this.selectionsSecond.put(this.panel.rbBaseToAny, HgLogMessage.HgRevision.BASE);
        this.panel.tfSelectedRevisionLocalToAny.setText(this.baseRevision.toString());
        this.panel.tfSelectedRevisionBaseToAny.setText(this.baseRevision.toString());
    }
}

