/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.lexer;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.DoxygenTokenId;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerInput;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;

public class DoxygenLexer
implements Lexer<DoxygenTokenId> {
    private static final int EOF = -1;
    private static final int INIT = 0;
    private static final int OTHER = 1;
    private LexerInput input;
    private int state = 0;
    private TokenFactory<DoxygenTokenId> tokenFactory;
    private static final String DOXYGEN_CONTROL_SYMBOLS = "@\\<.#";

    public DoxygenLexer(LexerRestartInfo<DoxygenTokenId> info) {
        this.input = info.input();
        this.tokenFactory = info.tokenFactory();
        this.fromState((Integer)info.state());
    }

    public Object state() {
        return this.state == 0 ? null : Integer.valueOf(this.state);
    }

    private void fromState(Integer state) {
        this.state = state == null ? 0 : state;
    }

    public Token<DoxygenTokenId> nextToken() {
        int ch = this.input.read();
        if (ch == -1) {
            return null;
        }
        int oldState = this.state;
        this.state = 1;
        if (oldState == 0 && ch == 60) {
            return this.token(DoxygenTokenId.POINTER_MARK);
        }
        if (CndLexerUtilities.isCppIdentifierStart(ch)) {
            while (CndLexerUtilities.isCppIdentifierPart(this.input.read())) {
            }
            this.input.backup(1);
            return this.token(DoxygenTokenId.IDENT);
        }
        if (DOXYGEN_CONTROL_SYMBOLS.indexOf(ch) == -1) {
            ch = this.input.read();
            while (!CndLexerUtilities.isCppIdentifierStart(ch) && DOXYGEN_CONTROL_SYMBOLS.indexOf(ch) == -1 && ch != -1) {
                ch = this.input.read();
            }
            if (ch != -1) {
                this.input.backup(1);
            }
            return this.token(DoxygenTokenId.OTHER_TEXT);
        }
        switch (ch) {
            case 64: 
            case 92: {
                boolean wasFirst;
                boolean first = true;
                do {
                    ch = this.input.read();
                    wasFirst = first;
                    first = false;
                } while ((!wasFirst || CndLexerUtilities.isCppIdentifierStart(ch)) && CndLexerUtilities.isCppIdentifierPart(ch));
                this.input.backup(1);
                if (this.input.readLength() > 1) {
                    return this.tokenFactory.createToken((TokenId)DoxygenTokenId.TAG, this.input.readLength());
                }
                return this.tokenFactory.createToken((TokenId)DoxygenTokenId.OTHER_TEXT, this.input.readLength());
            }
            case 60: {
                while ((ch = this.input.read()) != 62 && ch != -1) {
                }
                return this.token(DoxygenTokenId.HTML_TAG);
            }
            case 46: {
                return this.token(DoxygenTokenId.DOT);
            }
            case 35: {
                return this.token(DoxygenTokenId.HASH);
            }
        }
        assert (false);
        return null;
    }

    private Token<DoxygenTokenId> token(DoxygenTokenId id) {
        return this.tokenFactory.createToken((TokenId)id);
    }

    public void release() {
    }
}

