/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.spi.model;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.openide.util.Lookup;

public abstract class CsmBaseUtilitiesProvider {
    private static CsmBaseUtilitiesProvider DEFAULT = new Default();

    public static CsmBaseUtilitiesProvider getDefault() {
        return DEFAULT;
    }

    public abstract boolean isGlobalVariable(CsmVariable var1);

    public abstract CsmFunction getFunctionDeclaration(CsmFunction var1);

    public abstract CsmNamespace getFunctionNamespace(CsmFunction var1);

    public abstract CsmNamespace getClassNamespace(CsmClassifier var1);

    public abstract CsmClass getFunctionClass(CsmFunction var1);

    public abstract boolean isUnresolved(Object var1);

    private static final class Default
    extends CsmBaseUtilitiesProvider {
        private final Collection<? extends CsmBaseUtilitiesProvider> svcs = Lookup.getDefault().lookupAll(CsmBaseUtilitiesProvider.class);
        private static final boolean FIX_SERVICE = true;
        private CsmBaseUtilitiesProvider fixedResolver;

        Default() {
        }

        private CsmBaseUtilitiesProvider getService() {
            CsmBaseUtilitiesProvider service = this.fixedResolver;
            if (service == null) {
                Iterator<? extends CsmBaseUtilitiesProvider> iterator = this.svcs.iterator();
                if (iterator.hasNext()) {
                    CsmBaseUtilitiesProvider selector;
                    service = selector = iterator.next();
                }
                if (service != null) {
                    this.fixedResolver = service;
                }
            }
            return service;
        }

        @Override
        public boolean isGlobalVariable(CsmVariable var) {
            CsmBaseUtilitiesProvider provider = this.getService();
            if (provider != null) {
                return provider.isGlobalVariable(var);
            }
            return true;
        }

        @Override
        public CsmFunction getFunctionDeclaration(CsmFunction fun) {
            CsmBaseUtilitiesProvider provider = this.getService();
            if (provider != null) {
                return provider.getFunctionDeclaration(fun);
            }
            return null;
        }

        @Override
        public CsmNamespace getFunctionNamespace(CsmFunction fun) {
            CsmBaseUtilitiesProvider provider = this.getService();
            if (provider != null) {
                return provider.getFunctionNamespace(fun);
            }
            return null;
        }

        @Override
        public CsmNamespace getClassNamespace(CsmClassifier cls) {
            CsmBaseUtilitiesProvider provider = this.getService();
            if (provider != null) {
                return provider.getClassNamespace(cls);
            }
            return null;
        }

        @Override
        public CsmClass getFunctionClass(CsmFunction fun) {
            CsmBaseUtilitiesProvider provider = this.getService();
            if (provider != null) {
                return provider.getFunctionClass(fun);
            }
            return null;
        }

        @Override
        public boolean isUnresolved(Object obj) {
            CsmBaseUtilitiesProvider provider = this.getService();
            if (provider != null) {
                return provider.isUnresolved(obj);
            }
            return false;
        }
    }
}

