/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.util.Set;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

public class JhlMergeInfo
implements ISVNMergeInfo {
    Mergeinfo info;

    public JhlMergeInfo() {
        this.info = new Mergeinfo();
    }

    public JhlMergeInfo(Mergeinfo info) {
        this.info = info;
    }

    public void addRevisionRange(String path, SVNRevisionRange range) {
        if (this.info == null) {
            this.info = new Mergeinfo();
        }
        this.info.addRevisionRange(path, JhlConverter.convert(range));
    }

    public void addRevisions(String path, SVNRevisionRange[] range) {
        if (this.info == null) {
            this.info = new Mergeinfo();
        }
        this.info.addRevisions(path, JhlConverter.convert(range));
    }

    public String[] getPaths() {
        if (this.info == null) {
            return null;
        }
        Set paths = this.info.getPaths();
        String[] pathArray = new String[paths.size()];
        return paths.toArray(pathArray);
    }

    public SVNRevisionRange[] getRevisionRange(String path) {
        if (this.info == null) {
            return null;
        }
        return JhlConverter.convertRevisionRange(this.info.getRevisionRange(path));
    }

    public SVNRevisionRange[] getRevisions(String path) {
        if (this.info == null) {
            return null;
        }
        return JhlConverter.convertRevisionRange(this.info.getRevisions(path));
    }

    public void loadFromMergeInfoProperty(String mergeInfo) {
        if (this.info == null) {
            this.info = new Mergeinfo();
        }
        this.info.loadFromMergeinfoProperty(mergeInfo);
    }
}

