/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.Color;
import org.broad.igv.bedpe.BedPE;
import org.broad.igv.bedpe.BedPEFeature;
import org.broad.igv.bedpe.BedPEShape;

public class BedPEInterFeature
implements BedPE {
    private final BedPEFeature wrappedFeature;
    private final int order;
    int row;
    BedPEShape shape;

    public BedPEInterFeature(BedPEFeature wrappedFeature, int order) {
        this.wrappedFeature = wrappedFeature;
        this.order = order;
    }

    @Override
    public BedPEFeature get() {
        return this.wrappedFeature;
    }

    public String getChr() {
        return this.order == 1 ? this.wrappedFeature.chr1 : this.wrappedFeature.chr2;
    }

    public int getStart() {
        return this.order == 1 ? this.wrappedFeature.start1 : this.wrappedFeature.start2;
    }

    public int getEnd() {
        return this.order == 1 ? this.wrappedFeature.end1 : this.wrappedFeature.end2;
    }

    @Override
    public double getScore() {
        return this.wrappedFeature.score;
    }

    @Override
    public boolean isSameChr() {
        return false;
    }

    @Override
    public void setRow(int row) {
        this.row = row;
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public Color getColor() {
        return this.wrappedFeature.getColor();
    }

    @Override
    public int getThickness() {
        return this.wrappedFeature.getThickness();
    }

    @Override
    public void setShape(BedPEShape s) {
        this.shape = s;
    }

    @Override
    public BedPEShape getShape() {
        return this.shape;
    }

    @Override
    public String getValueString() {
        return this.wrappedFeature.getValueString();
    }

    @Override
    public double getCenterDistance() {
        return 0.0;
    }

    public String getContig() {
        return this.getChr();
    }
}

