/* -*- Mode: C; c-file-style: "gnu" -*-
   log.h -- debug logging.
   Created: Chris Toshok <toshok@hungry.com>, 23-Jul-97
 */
/*
  This file is part of Japhar, the GNU Virtual Machine for Java Bytecodes.
  Japhar is a project of The Hungry Programmers, GNU, and OryxSoft.

  Copyright (C) 1997, 1998, 1999 The Hungry Programmers

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef LOG_H
#define LOG_H

#include <stdio.h>
#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

  void LOG_init(void);
  void LOG_log(char *log, int level, char *msg_form, ...);
  FILE *LOG_stream(char *logname);

#if defined( LOGGING )
#define JAVARLOG0(log, level, msg) LOG_log(log,level,msg)
#define JAVARLOG1(log, level, msg, p1) LOG_log(log,level,msg,p1)
#define JAVARLOG2(log, level, msg, p1,p2) LOG_log(log,level,msg,p1,p2)
#define JAVARLOG3(log, level, msg, p1,p2,p3) LOG_log(log,level,msg,p1,p2,p3)
#define JAVARLOG4(log, level, msg, p1,p2,p3,p4) LOG_log(log,level,msg,p1,p2,p3,p4)
#define JAVARLOG5(log, level, msg, p1,p2,p3,p4,p5) LOG_log(log,level,msg,p1,p2,p3,p4,p5)
#define JAVARLOG6(log, level, msg, p1,p2,p3,p4,p5,p6) LOG_log(log,level,msg,p1,p2,p3,p4,p5,p6)
#define JAVARLOG7(log, level, msg, p1,p2,p3,p4,p5,p6,p7) LOG_log(log,level,msg,p1,p2,p3,p4,p5,p6,p7)
#else
#define JAVARLOG0(log, level, msg) 
#define JAVARLOG1(log, level, msg, p1)
#define JAVARLOG2(log, level, msg, p1,p2)
#define JAVARLOG3(log, level, msg, p1,p2,p3)
#define JAVARLOG4(log, level, msg, p1,p2,p3,p4)
#define JAVARLOG5(log, level, msg, p1,p2,p3,p4,p5)
#define JAVARLOG6(log, level, msg, p1,p2,p3,p4,p5,p6)
#define JAVARLOG7(log, level, msg, p1,p2,p3,p4,p5,p6,p7)
#endif

#ifdef __cplusplus
};
#endif

#endif /* LOG_H */
