package TDS::Keyword;
# $Id: Keyword.pm,v 1.5 2000/10/01 14:30:45 tom Exp $
################################################################

use strict;

use ObjectTemplate;
use JConv;
use Skelton;
use CGI::Tools;

use TDS;

use vars qw(@ISA);
@ISA = qw(ObjectTemplate);

attributes qw(origin asshow escaped);

sub initialize($)
{
    my $self = shift;
    $self->origin(undef);
    $self->asshow(undef);
    $self->escaped(undef);
    $self->SUPER::initialize;
}
sub Set($$)
{
    my ($self, $origin) = @_;

    return unless $origin;
    
    sub conv_internal;
    *conv_internal = mkjconv('auto', $TDS::System::InternalJcode);
    conv_internal(\$origin);
    $self->origin($origin);
    $self->escaped(Escape($origin));
    
    sub conv_asshow;
    *conv_asshow = mkjconv($TDS::System::InternalJcode,
			   &Skelton::GetOutputJcode());
    conv_asshow(\$origin);
    $self->asshow($origin);

}

sub IsEmpty($)
{
    my $self = shift;
    return $self->origin eq '';
}
1;

