/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

public abstract class Arc2D
extends RectangularShape {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;
    int type;

    public abstract double getAngleStart();

    public abstract double getAngleExtent();

    public int getArcType() {
        return this.type;
    }

    public Point2D getStartPoint() {
        double angle = Math.toRadians(this.getAngleStart());
        double rx = this.getWidth() / (double)2;
        double ry = this.getHeight() / (double)2;
        double x = this.getX() + rx + rx * Math.cos(angle);
        double y = this.getY() + ry - ry * Math.sin(angle);
        return new Point2D.Double(x, y);
    }

    public Point2D getEndPoint() {
        double angle = Math.toRadians(this.getAngleStart() + this.getAngleExtent());
        double rx = this.getWidth() / (double)2;
        double ry = this.getHeight() / (double)2;
        double x = this.getX() + rx + rx * Math.cos(angle);
        double y = this.getY() + ry - ry * Math.sin(angle);
        return new Point2D.Double(x, y);
    }

    public abstract void setArc(double var1, double var3, double var5, double var7, double var9, double var11, int var13);

    public void setArc(Point2D p, Dimension2D d, double start, double extent, int type) {
        this.setArc(p.getX(), p.getY(), d.getWidth(), d.getHeight(), start, extent, type);
    }

    public void setArc(Rectangle2D r, double start, double extent, int type) {
        this.setArc(r.getX(), r.getY(), r.getWidth(), r.getHeight(), start, extent, type);
    }

    public void setArc(Arc2D a) {
        this.setArc(a.getX(), a.getY(), a.getWidth(), a.getHeight(), a.getAngleStart(), a.getAngleExtent(), a.getArcType());
    }

    public void setArcByCenter(double x, double y, double r, double start, double extent, int type) {
        this.setArc(x - r, y - r, r + r, r + r, start, extent, type);
    }

    public void setArcByTangent(Point2D p1, Point2D p2, Point2D p3, double r) {
        if ((p2.getX() - p1.getX()) * (p3.getY() - p1.getY()) - (p3.getX() - p1.getX()) * (p2.getY() - p1.getY()) > 0.0) {
            Point2D p = p3;
            p3 = p1;
            p1 = p;
        }
        double dx1 = (p1.getX() - p2.getX()) / p1.distance(p2);
        double dy1 = (p1.getY() - p2.getY()) / p1.distance(p2);
        double dx2 = (p2.getX() - p3.getX()) / p3.distance(p2);
        double dy2 = (p2.getY() - p3.getY()) / p3.distance(p2);
        double theta1 = Math.atan2(dx1, dy1);
        double theta2 = Math.atan2(dx2, dy2);
        double dx = r * Math.cos(theta2) - r * Math.cos(theta1);
        double dy = -r * Math.sin(theta2) + r * Math.sin(theta1);
        if (theta1 < 0.0) {
            theta1 += Math.PI * 2;
        }
        if (theta2 < 0.0) {
            theta2 += Math.PI * 2;
        }
        if (theta2 < theta1) {
            theta2 += Math.PI * 2;
        }
        dx1 = p1.getX() - p2.getX();
        dy1 = p1.getY() - p2.getY();
        dx2 = p3.getX() - p2.getX();
        dy2 = p3.getY() - p2.getY();
        double t2 = -(dx1 * dy - dy1 * dx) / (dx2 * dy1 - dx1 * dy2);
        double x2 = t2 * (p3.getX() - p2.getX()) + p2.getX();
        double y2 = t2 * (p3.getY() - p2.getY()) + p2.getY();
        double x = x2 - r * Math.cos(theta2);
        double y = y2 + r * Math.sin(theta2);
        this.setArc(x - r, y - r, (double)2 * r, (double)2 * r, Math.toDegrees(theta1), Math.toDegrees(theta2 - theta1), this.getArcType());
    }

    public abstract void setAngleStart(double var1);

    public abstract void setAngleExtent(double var1);

    public void setAngleStart(Point2D p) {
        double x = p.getX() - (this.getX() + this.getWidth() / (double)2);
        double y = p.getY() - (this.getY() + this.getHeight() / (double)2);
        this.setAngleStart(Math.toDegrees(Math.atan2(-y, x)));
    }

    public void setAngles(double x1, double y1, double x2, double y2) {
        double mx = this.getX();
        double my = this.getY();
        double mw = this.getWidth();
        double mh = this.getHeight();
        x2 -= mx + mw / (double)2;
        y2 -= my + mh / (double)2;
        double start = Math.toDegrees(Math.atan2(-(y1 -= my + mh / (double)2), x1 -= mx + mw / (double)2));
        double extent = Math.toDegrees(Math.atan2(-y2, x2)) - start;
        if (extent < 0.0) {
            extent += 360.0;
        }
        this.setAngleStart(start);
        this.setAngleExtent(extent);
    }

    public void setAngles(Point2D p1, Point2D p2) {
        this.setAngles(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setArcType(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    public void setFrame(double x, double y, double w, double h) {
        this.setArc(x, y, w, h, this.getAngleStart(), this.getAngleExtent(), this.type);
    }

    public Rectangle2D getBounds2D() {
        double extent = this.getAngleExtent();
        if (Math.abs(extent) >= 360.0) {
            return this.makeBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        double rX = this.getWidth() / (double)2;
        double rY = this.getHeight() / (double)2;
        double centerX = this.getX() + rX;
        double centerY = this.getY() + rY;
        Point2D p1 = this.getStartPoint();
        Rectangle2D result = this.makeBounds(p1.getX(), p1.getY(), 0.0, 0.0);
        result.add(this.getEndPoint());
        if (this.type == 2) {
            result.add(centerX, centerY);
        }
        if (this.containsAngle(0.0)) {
            result.add(centerX + rX, centerY);
        }
        if (this.containsAngle(90.0)) {
            result.add(centerX, centerY - rY);
        }
        if (this.containsAngle(180.0)) {
            result.add(centerX - rX, centerY);
        }
        if (this.containsAngle(270.0)) {
            result.add(centerX, centerY + rY);
        }
        return result;
    }

    protected abstract Rectangle2D makeBounds(double var1, double var3, double var5, double var7);

    public boolean containsAngle(double a) {
        double start = this.getAngleStart();
        double extent = this.getAngleExtent();
        double end = start + extent;
        if (extent == 0.0) {
            return false;
        }
        if (extent >= 360.0 || extent <= -360.0) {
            return true;
        }
        if (extent < 0.0) {
            end = start;
            start += extent;
        }
        start %= 360.0;
        while (start < 0.0) {
            start += 360.0;
        }
        end %= 360.0;
        while (end < start) {
            end += 360.0;
        }
        a %= 360.0;
        while (a < start) {
            a += 360.0;
        }
        boolean bl = false;
        if (a >= start && a < end) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(double x, double y) {
        double my;
        double dy;
        double w = this.getWidth();
        double h = this.getHeight();
        double extent = this.getAngleExtent();
        if (w <= 0.0 || h <= 0.0 || extent == 0.0) {
            return false;
        }
        double mx = this.getX() + w / (double)2;
        double dx = (x - mx) * (double)2 / w;
        if (dx * dx + (dy = (y - (my = this.getY() + h / (double)2)) * (double)2 / h) * dy >= 1.0) {
            return false;
        }
        double angle = Math.toDegrees(Math.atan2(-dy, dx));
        if (this.getArcType() == 2) {
            return this.containsAngle(angle);
        }
        double a1 = Math.toRadians(this.getAngleStart());
        double a2 = Math.toRadians(this.getAngleStart() + extent);
        double x1 = mx + this.getWidth() * Math.cos(a1) / (double)2;
        double y1 = my - this.getHeight() * Math.sin(a1) / (double)2;
        double x2 = mx + this.getWidth() * Math.cos(a2) / (double)2;
        double y2 = my - this.getHeight() * Math.sin(a2) / (double)2;
        double sgn = ((x2 - x1) * (my - y1) - (mx - x1) * (y2 - y1)) * ((x2 - x1) * (y - y1) - (x - x1) * (y2 - y1));
        if (Math.abs(extent) > 180.0) {
            if (this.containsAngle(angle)) {
                return true;
            }
            boolean bl = false;
            if (sgn > 0.0) {
                bl = true;
            }
            return bl;
        }
        if (!this.containsAngle(angle)) {
            return false;
        }
        boolean bl = false;
        if (sgn < 0.0) {
            bl = true;
        }
        return bl;
    }

    public boolean intersects(double x, double y, double w, double h) {
        double dy;
        double dx;
        double extent = this.getAngleExtent();
        if (extent == 0.0) {
            return false;
        }
        if (this.contains(x, y) || this.contains(x, y + h) || this.contains(x + w, y) || this.contains(x + w, y + h)) {
            return true;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        double a = this.getWidth() / (double)2;
        double b = this.getHeight() / (double)2;
        double mx = this.getX() + a;
        double my = this.getY() + b;
        double x1 = mx + a * Math.cos(Math.toRadians(this.getAngleStart()));
        double y1 = my - b * Math.sin(Math.toRadians(this.getAngleStart()));
        double x2 = mx + a * Math.cos(Math.toRadians(this.getAngleStart() + extent));
        double y2 = my - b * Math.sin(Math.toRadians(this.getAngleStart() + extent));
        if (this.getArcType() != 1) {
            if (rect.intersectsLine(mx, my, x1, y1)) {
                return true;
            }
            if (rect.intersectsLine(mx, my, x2, y2)) {
                return true;
            }
        } else if (rect.intersectsLine(x1, y1, x2, y2)) {
            return true;
        }
        if (!java.lang.Double.isNaN(dx = a * Math.sqrt(1.0 - (dy = y - my) * dy / (b * b)))) {
            if (mx + dx >= x && mx + dx <= x + w && this.containsAngle(Math.toDegrees(Math.atan2(-dy, dx)))) {
                return true;
            }
            if (mx - dx >= x && mx - dx <= x + w && this.containsAngle(Math.toDegrees(Math.atan2(-dy, -dx)))) {
                return true;
            }
        }
        if (!java.lang.Double.isNaN(dx = a * Math.sqrt(1.0 - (dy = y + h - my) * dy / (b * b)))) {
            if (mx + dx >= x && mx + dx <= x + w && this.containsAngle(Math.toDegrees(Math.atan2(-dy, dx)))) {
                return true;
            }
            if (mx - dx >= x && mx - dx <= x + w && this.containsAngle(Math.toDegrees(Math.atan2(-dy, -dx)))) {
                return true;
            }
        }
        if (!java.lang.Double.isNaN(dy = b * Math.sqrt(1.0 - (dx = x - mx) * dx / (a * a)))) {
            if (my + dy >= y && my + dy <= y + h && this.containsAngle(Math.toDegrees(Math.atan2(-dy, dx)))) {
                return true;
            }
            if (my - dy >= y && my - dy <= y + h && this.containsAngle(Math.toDegrees(Math.atan2(dy, dx)))) {
                return true;
            }
        }
        if (!java.lang.Double.isNaN(dy = b * Math.sqrt(1.0 - (dx = x + w - mx) * dx / (a * a)))) {
            if (my + dy >= y && my + dy <= y + h && this.containsAngle(Math.toDegrees(Math.atan2(-dy, dx)))) {
                return true;
            }
            if (my - dy >= y && my - dy <= y + h && this.containsAngle(Math.toDegrees(Math.atan2(dy, dx)))) {
                return true;
            }
        }
        return rect.contains(mx, my);
    }

    public boolean contains(double x, double y, double w, double h) {
        double extent = this.getAngleExtent();
        if (extent == 0.0) {
            return false;
        }
        if (!(this.contains(x, y) && this.contains(x, y + h) && this.contains(x + w, y) && this.contains(x + w, y + h))) {
            return false;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, w, h);
        double a = this.getWidth() / (double)2;
        double b = this.getHeight() / (double)2;
        double mx = this.getX() + a;
        double my = this.getY() + b;
        double x1 = mx + a * Math.cos(Math.toRadians(this.getAngleStart()));
        double y1 = my - b * Math.sin(Math.toRadians(this.getAngleStart()));
        double x2 = mx + a * Math.cos(Math.toRadians(this.getAngleStart() + extent));
        double y2 = my - b * Math.sin(Math.toRadians(this.getAngleStart() + extent));
        if (this.getArcType() != 1) {
            if (rect.intersectsLine(mx, my, x1, y1)) {
                return false;
            }
            if (rect.intersectsLine(mx, my, x2, y2)) {
                return false;
            }
        } else if (rect.intersectsLine(x1, y1, x2, y2)) {
            return false;
        }
        return true;
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new ArcIterator(this, at);
    }

    protected Arc2D(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException();
        }
        this.type = type;
    }

    static final class ArcIterator
    implements PathIterator {
        private int current;
        private final int limit;
        private final AffineTransform xform;
        private final double x;
        private final double y;
        private final double w;
        private final double h;
        private final double start;
        private final double extent;
        private final int type;

        public final int getWindingRule() {
            return 1;
        }

        public final boolean isDone() {
            boolean bl = false;
            if (this.current > this.limit) {
                bl = true;
            }
            return bl;
        }

        public final void next() {
            ++this.current;
        }

        public final int currentSegment(float[] coords) {
            double[] double_coords = new double[6];
            int code = this.currentSegment(double_coords);
            int i = 0;
            while (i < 6) {
                coords[i] = (float)double_coords[i];
                ++i;
            }
            return code;
        }

        public final int currentSegment(double[] coords) {
            double rx = this.w / (double)2;
            double ry = this.h / (double)2;
            double xmid = this.x + rx;
            double ymid = this.y + ry;
            if (this.current > this.limit) {
                throw new NoSuchElementException("arc iterator out of bounds");
            }
            if (this.current == 0) {
                coords[0] = xmid + rx * Math.cos(this.start);
                coords[1] = ymid - ry * Math.sin(this.start);
                if (this.xform != null) {
                    this.xform.transform(coords, 0, coords, 0, 1);
                }
                return 0;
            }
            if (this.type != 0 && this.current == this.limit) {
                return 4;
            }
            if (this.current == this.limit - 1 && this.type == 2) {
                coords[0] = xmid;
                coords[1] = ymid;
                if (this.xform != null) {
                    this.xform.transform(coords, 0, coords, 0, 1);
                }
                return 1;
            }
            double kappa = (Math.sqrt(2) - 1.0) * 1.3333333333333333;
            double quad = 1.5707963267948966;
            double curr_begin = this.start + (double)(this.current - 1) * quad;
            double curr_extent = Math.min(this.start + this.extent - curr_begin, quad);
            double portion_of_a_quadrant = curr_extent / quad;
            double x0 = xmid + rx * Math.cos(curr_begin);
            double y0 = ymid - ry * Math.sin(curr_begin);
            double x1 = xmid + rx * Math.cos(curr_begin + curr_extent);
            double y1 = ymid - ry * Math.sin(curr_begin + curr_extent);
            AffineTransform trans = new AffineTransform();
            double[] cvec = new double[2];
            double len = kappa * portion_of_a_quadrant;
            double angle = curr_begin;
            cvec[0] = 0.0;
            cvec[1] = len;
            trans.scale(rx, ry);
            trans.rotate(angle);
            trans.transform(cvec, 0, cvec, 0, 1);
            coords[0] = x0 + cvec[0];
            coords[1] = y0 - cvec[1];
            cvec[0] = 0.0;
            cvec[1] = -len;
            trans.rotate(curr_extent);
            trans.transform(cvec, 0, cvec, 0, 1);
            coords[2] = x1 + cvec[0];
            coords[3] = y1 - cvec[1];
            coords[4] = x1;
            coords[5] = y1;
            if (this.xform != null) {
                this.xform.transform(coords, 0, coords, 0, 3);
            }
            return 3;
        }

        public ArcIterator(Arc2D a, AffineTransform xform) {
            this.xform = xform;
            this.x = a.getX();
            this.y = a.getY();
            this.w = a.getWidth();
            this.h = a.getHeight();
            double start = a.getAngleStart() * (Math.PI / 180);
            double extent = a.getAngleExtent() * (Math.PI / 180);
            if (extent < 0.0) {
                extent = -extent;
                start = Math.PI * 2 - extent + start;
            }
            this.start = start;
            this.extent = extent;
            this.type = a.type;
            this.limit = this.w < 0.0 || this.h < 0.0 ? -1 : (extent == 0.0 ? this.type : (extent <= 1.5707963267948966 ? this.type + 1 : (extent <= Math.PI ? this.type + 2 : (extent <= 4.71238898038469 ? this.type + 3 : this.type + 4))));
        }

        public ArcIterator(Ellipse2D e, AffineTransform xform) {
            this.xform = xform;
            this.x = e.getX();
            this.y = e.getY();
            this.w = e.getWidth();
            this.h = e.getHeight();
            this.start = 0.0;
            this.extent = Math.PI * 2;
            this.type = 1;
            this.limit = this.w < 0.0 || this.h < 0.0 ? -1 : 5;
        }
    }

    public static class Float
    extends Arc2D {
        public float x;
        public float y;
        public float width;
        public float height;
        public float start;
        public float extent;

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getAngleStart() {
            return this.start;
        }

        public double getAngleExtent() {
            return this.extent;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.width <= 0.0f || this.height <= 0.0f) {
                bl = true;
            }
            return bl;
        }

        public void setArc(double x, double y, double w, double h, double start, double extent, int type) {
            this.x = (float)x;
            this.y = (float)y;
            this.width = (float)w;
            this.height = (float)h;
            this.start = (float)start;
            this.extent = (float)extent;
            this.setArcType(type);
        }

        public void setAngleStart(double start) {
            this.start = (float)start;
        }

        public void setAngleExtent(double extent) {
            this.extent = (float)extent;
        }

        protected Rectangle2D makeBounds(double x, double y, double w, double h) {
            return new Rectangle2D.Float((float)x, (float)y, (float)w, (float)h);
        }

        public Float() {
            super(0);
        }

        public Float(int type) {
            super(type);
        }

        public Float(float x, float y, float w, float h, float start, float extent, int type) {
            super(type);
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.start = start;
            this.extent = extent;
        }

        public Float(Rectangle2D r, float start, float extent, int type) {
            super(type);
            this.x = (float)r.getX();
            this.y = (float)r.getY();
            this.width = (float)r.getWidth();
            this.height = (float)r.getHeight();
            this.start = start;
            this.extent = extent;
        }
    }

    public static class Double
    extends Arc2D {
        public double x;
        public double y;
        public double width;
        public double height;
        public double start;
        public double extent;

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public double getAngleStart() {
            return this.start;
        }

        public double getAngleExtent() {
            return this.extent;
        }

        public boolean isEmpty() {
            boolean bl = false;
            if (this.width <= 0.0 || this.height <= 0.0) {
                bl = true;
            }
            return bl;
        }

        public void setArc(double x, double y, double w, double h, double start, double extent, int type) {
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.start = start;
            this.extent = extent;
            this.setArcType(type);
        }

        public void setAngleStart(double start) {
            this.start = start;
        }

        public void setAngleExtent(double extent) {
            this.extent = extent;
        }

        protected Rectangle2D makeBounds(double x, double y, double w, double h) {
            return new Rectangle2D.Double(x, y, w, h);
        }

        public Double() {
            super(0);
        }

        public Double(int type) {
            super(type);
        }

        public Double(double x, double y, double w, double h, double start, double extent, int type) {
            super(type);
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.start = start;
            this.extent = extent;
        }

        public Double(Rectangle2D r, double start, double extent, int type) {
            super(type);
            this.x = r.getX();
            this.y = r.getY();
            this.width = r.getWidth();
            this.height = r.getHeight();
            this.start = start;
            this.extent = extent;
        }
    }
}

