/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

public class BigDecimal
extends Number
implements Comparable {
    private static final long serialVersionUID = 6108874887143696463L;
    public static final BigDecimal ZERO = new BigDecimal(BigInteger.valueOf(0L), 0);
    public static final BigDecimal ONE = new BigDecimal(BigInteger.valueOf(1L), 0);
    public static final BigDecimal TEN = new BigDecimal(BigInteger.valueOf(10L), 0);
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private BigInteger intVal;
    private int scale;

    public static BigDecimal valueOf(long val) {
        return BigDecimal.valueOf(val, 0);
    }

    public static BigDecimal valueOf(long val, int scale) throws NumberFormatException {
        if (scale == 0 && (long)((int)val) == val) {
            switch ((int)val) {
                case 0: {
                    return ZERO;
                }
                case 1: {
                    return ONE;
                }
            }
        }
        return new BigDecimal(BigInteger.valueOf(val), scale);
    }

    public BigDecimal add(BigDecimal val) {
        BigInteger op1 = this.intVal;
        BigInteger op2 = val.intVal;
        if (this.scale < val.scale) {
            op1 = op1.multiply(BigInteger.valueOf(10L).pow(val.scale - this.scale));
        } else if (this.scale > val.scale) {
            op2 = op2.multiply(BigInteger.valueOf(10L).pow(this.scale - val.scale));
        }
        return new BigDecimal(op1.add(op2), Math.max(this.scale, val.scale));
    }

    public BigDecimal subtract(BigDecimal val) {
        return this.add(val.negate());
    }

    public BigDecimal multiply(BigDecimal val) {
        return new BigDecimal(this.intVal.multiply(val.intVal), this.scale + val.scale);
    }

    public BigDecimal divide(BigDecimal val, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        return this.divide(val, this.scale, roundingMode);
    }

    public BigDecimal divide(BigDecimal val, int newScale, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("illegal rounding mode: " + roundingMode);
        }
        if (newScale < 0) {
            throw new ArithmeticException("scale is negative: " + newScale);
        }
        if (this.intVal.signum() == 0) {
            return newScale == 0 ? ZERO : new BigDecimal(BigDecimal.ZERO.intVal, newScale);
        }
        BigInteger valIntVal = val.intVal;
        int power = newScale - (this.scale - val.scale);
        if (power < 0) {
            valIntVal = valIntVal.multiply(BigInteger.valueOf(10L).pow(-power));
            power = 0;
        }
        BigInteger dividend = this.intVal.multiply(BigInteger.valueOf(10L).pow(power));
        BigInteger[] parts = dividend.divideAndRemainder(valIntVal);
        BigInteger unrounded = parts[0];
        if (parts[1].signum() == 0) {
            return new BigDecimal(unrounded, newScale);
        }
        if (roundingMode == 7) {
            throw new ArithmeticException("newScale is not large enough");
        }
        int sign = this.intVal.signum() * valIntVal.signum();
        if (roundingMode == 2) {
            int n = 0;
            if (sign > 0) {
                n = 1;
            }
            roundingMode = 1 - n;
        } else if (roundingMode == 3) {
            int n = 0;
            if (sign < 0) {
                n = 1;
            }
            roundingMode = 1 - n;
        } else {
            BigInteger posRemainder = parts[1].signum() < 0 ? parts[1].negate() : parts[1];
            valIntVal = valIntVal.signum() < 0 ? valIntVal.negate() : valIntVal;
            int half = posRemainder.shiftLeft(1).compareTo(valIntVal);
            switch (roundingMode) {
                case 4: {
                    int n = 0;
                    if (half < 0) {
                        n = 1;
                    }
                    roundingMode = n;
                    break;
                }
                case 5: {
                    int n = 0;
                    if (half > 0) {
                        n = 1;
                    }
                    roundingMode = 1 - n;
                    break;
                }
                case 6: {
                    if (half < 0) {
                        roundingMode = 1;
                        break;
                    }
                    if (half > 0) {
                        roundingMode = 0;
                        break;
                    }
                    if (unrounded.testBit(0)) {
                        roundingMode = 0;
                        break;
                    }
                    roundingMode = 1;
                    break;
                }
            }
        }
        if (roundingMode == 0) {
            unrounded = unrounded.add(BigInteger.valueOf(sign > 0 ? 1 : -1));
        }
        return new BigDecimal(unrounded, newScale);
    }

    public int compareTo(BigDecimal val) {
        BigInteger[] valParts;
        if (this.scale == val.scale) {
            return this.intVal.compareTo(val.intVal);
        }
        BigInteger[] thisParts = this.intVal.divideAndRemainder(BigInteger.valueOf(10L).pow(this.scale));
        int compare = thisParts[0].compareTo((valParts = val.intVal.divideAndRemainder(BigInteger.valueOf(10L).pow(val.scale)))[0]);
        if (compare != 0) {
            return compare;
        }
        if (!thisParts[1].equals(BigInteger.valueOf(0L))) {
            while (thisParts[1].mod(BigInteger.valueOf(10L)).equals(BigInteger.valueOf(0L))) {
                thisParts[1] = thisParts[1].divide(BigInteger.valueOf(10L));
            }
        }
        if (!valParts[1].equals(BigInteger.valueOf(0L))) {
            while (valParts[1].mod(BigInteger.valueOf(10L)).equals(BigInteger.valueOf(0L))) {
                valParts[1] = valParts[1].divide(BigInteger.valueOf(10L));
            }
        }
        return thisParts[1].compareTo(valParts[1]);
    }

    public int compareTo(Object val) {
        return this.compareTo((BigDecimal)val);
    }

    public boolean equals(Object o) {
        boolean bl = false;
        if (o instanceof BigDecimal && this.scale == ((BigDecimal)o).scale && this.compareTo((BigDecimal)o) == 0) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.intValue() ^ this.scale;
    }

    public BigDecimal max(BigDecimal val) {
        switch (this.compareTo(val)) {
            case 1: {
                return this;
            }
        }
        return val;
    }

    public BigDecimal min(BigDecimal val) {
        switch (this.compareTo(val)) {
            case -1: {
                return this;
            }
        }
        return val;
    }

    public BigDecimal movePointLeft(int n) {
        return n < 0 ? this.movePointRight(-n) : new BigDecimal(this.intVal, this.scale + n);
    }

    public BigDecimal movePointRight(int n) {
        if (n < 0) {
            return this.movePointLeft(-n);
        }
        if (this.scale >= n) {
            return new BigDecimal(this.intVal, this.scale - n);
        }
        return new BigDecimal(this.intVal.multiply(BigInteger.valueOf(10L).pow(n - this.scale)), 0);
    }

    public int signum() {
        return this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public BigInteger unscaledValue() {
        return this.intVal;
    }

    public BigDecimal abs() {
        return new BigDecimal(this.intVal.abs(), this.scale);
    }

    public BigDecimal negate() {
        return new BigDecimal(this.intVal.negate(), this.scale);
    }

    public String toString() {
        String bigStr = this.intVal.toString();
        if (this.scale == 0) {
            return bigStr;
        }
        int n = 0;
        if (bigStr.charAt(0) == '-') {
            n = 1;
        }
        int negative = n;
        int point = bigStr.length() - this.scale - negative;
        int n2 = bigStr.length() + 2;
        int n3 = 0;
        if (point <= 0) {
            n3 = -point + 1;
        }
        StringBuffer sb = new StringBuffer(n2 + n3);
        if (point <= 0) {
            if (negative != 0) {
                sb.append('-');
            }
            sb.append('0').append('.');
            while (point < 0) {
                sb.append('0');
                ++point;
            }
            sb.append(bigStr.substring(negative));
        } else {
            sb.append(bigStr);
            sb.insert(point + negative, '.');
        }
        return sb.toString();
    }

    public BigInteger toBigInteger() {
        return this.scale == 0 ? this.intVal : this.intVal.divide(BigInteger.valueOf(10L).pow(this.scale));
    }

    public int intValue() {
        return this.toBigInteger().intValue();
    }

    public long longValue() {
        return this.toBigInteger().longValue();
    }

    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    public BigDecimal setScale(int scale) throws ArithmeticException {
        return this.setScale(scale, 7);
    }

    public BigDecimal setScale(int scale, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        return this.divide(ONE, scale, roundingMode);
    }

    public BigDecimal(BigInteger num) {
        this(num, 0);
    }

    public BigDecimal(BigInteger num, int scale) throws NumberFormatException {
        if (scale < 0) {
            throw new NumberFormatException("scale of " + scale + " is < 0");
        }
        this.intVal = num;
        this.scale = scale;
    }

    public BigDecimal(double num) throws NumberFormatException {
        if (Double.isInfinite(num) || Double.isNaN(num)) {
            throw new NumberFormatException("invalid argument: " + num);
        }
        int mantissaBits = 52;
        int exponentBits = 11;
        long mantMask = 0xFFFFFFFFFFFFFL;
        long expMask = 2047L;
        long bits = Double.doubleToLongBits(num);
        long mantissa = bits & 0xFFFFFFFFFFFFFL;
        long exponent = bits >>> 52 & 0x7FFL;
        int n = 0;
        if (exponent == 0L) {
            n = 1;
        }
        int denormal = n;
        exponent -= (long)(1023 - denormal);
        exponent -= 52L;
        if (denormal == 0) {
            mantissa |= 0x10000000000000L;
        }
        while (exponent < 0L && (mantissa & 1L) == 0L) {
            ++exponent;
            mantissa >>= 1;
        }
        this.intVal = BigInteger.valueOf(bits < 0L ? -mantissa : mantissa);
        if (exponent < 0L) {
            this.scale = (int)(-exponent);
            BigInteger mult = BigInteger.valueOf(5).pow(this.scale);
            this.intVal = this.intVal.multiply(mult);
        } else {
            this.intVal = this.intVal.shiftLeft((int)exponent);
            this.scale = 0;
        }
    }

    public BigDecimal(String num) throws NumberFormatException {
        String val;
        int len = num.length();
        int start = 0;
        int point = 0;
        int dot = -1;
        boolean negative = false;
        if (num.charAt(0) == '+') {
            ++start;
            ++point;
        } else if (num.charAt(0) == '-') {
            ++start;
            ++point;
            negative = true;
        }
        while (point < len) {
            char c = num.charAt(point);
            if (c == '.') {
                if (dot >= 0) {
                    throw new NumberFormatException("multiple `.'s in number");
                }
                dot = point;
            } else {
                if (c == 'e' || c == 'E') break;
                if (Character.digit(c, 10) < 0) {
                    throw new NumberFormatException("unrecognized character: " + c);
                }
            }
            ++point;
        }
        if (dot >= 0) {
            val = num.substring(start, dot) + num.substring(dot + 1, point);
            this.scale = point - 1 - dot;
        } else {
            val = num.substring(start, point);
            this.scale = 0;
        }
        if (val.length() == 0) {
            throw new NumberFormatException("no digits seen");
        }
        if (negative) {
            val = "-" + val;
        }
        this.intVal = new BigInteger(val);
        if (point < len) {
            if (num.charAt(++point) == '+') {
                ++point;
            }
            if (point >= len) {
                throw new NumberFormatException("no exponent following e or E");
            }
            try {
                int exp = Integer.parseInt(num.substring(point));
                exp -= this.scale;
                if (this.signum() == 0) {
                    this.scale = 0;
                } else if (exp > 0) {
                    this.intVal = this.intVal.multiply(BigInteger.valueOf(10L).pow(exp));
                    this.scale = 0;
                } else {
                    this.scale = -exp;
                }
            }
            catch (NumberFormatException ex) {
                throw new NumberFormatException("malformed exponent");
            }
        }
    }
}

