/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.BitSet;
import java.util.EventListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultListSelectionModel
implements Cloneable,
ListSelectionModel,
Serializable {
    private static final long serialVersionUID = -5718799865110415860L;
    protected EventListenerList listenerList;
    int selectionMode;
    int leadSelectionIndex;
    int anchorSelectionIndex;
    protected boolean leadAnchorNotificationEnabled;
    boolean valueIsAdjusting;
    BitSet sel;
    Object oldSel;
    boolean setLeadCalledFromAdd;
    static /* synthetic */ Class class$javax$swing$event$ListSelectionListener;

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int a) {
        this.selectionMode = a;
    }

    public int getAnchorSelectionIndex() {
        return this.anchorSelectionIndex;
    }

    public void setAnchorSelectionIndex(int anchorIndex) {
        this.anchorSelectionIndex = anchorIndex;
    }

    public int getLeadSelectionIndex() {
        return this.leadSelectionIndex;
    }

    public void setLeadSelectionIndex(int leadIndex) {
        int oldLeadIndex;
        if (leadIndex < 0) {
            if (this.anchorSelectionIndex < 0) {
                this.leadSelectionIndex = -1;
            } else {
                return;
            }
        }
        if (this.anchorSelectionIndex < 0) {
            return;
        }
        if (this.selectionMode == 0) {
            this.setSelectionInterval(leadIndex, leadIndex);
        }
        if ((oldLeadIndex = this.leadSelectionIndex) == -1) {
            oldLeadIndex = leadIndex;
        }
        if (!this.setLeadCalledFromAdd) {
            this.oldSel = this.sel.clone();
        }
        this.leadSelectionIndex = leadIndex;
        if (this.anchorSelectionIndex == -1) {
            return;
        }
        int R1 = Math.min(this.anchorSelectionIndex, oldLeadIndex);
        int R2 = Math.max(this.anchorSelectionIndex, oldLeadIndex);
        int S1 = Math.min(this.anchorSelectionIndex, leadIndex);
        int S2 = Math.max(this.anchorSelectionIndex, leadIndex);
        int lo = Math.min(R1, S1);
        int hi = Math.max(R2, S2);
        if (this.isSelectedIndex(this.anchorSelectionIndex)) {
            this.sel.clear(R1, R2 + 1);
            this.sel.set(S1, S2 + 1);
        } else {
            this.sel.set(R1, R2 + 1);
            this.sel.clear(S1, S2 + 1);
        }
        int beg = this.sel.nextSetBit(0);
        int end = -1;
        int i = beg;
        while (i >= 0) {
            end = i;
            i = this.sel.nextSetBit(i + 1);
        }
        if (!this.sel.equals(this.oldSel)) {
            this.fireValueChanged(beg, end, this.valueIsAdjusting);
        }
    }

    public void moveLeadSelectionIndex(int leadIndex) {
        if (this.leadSelectionIndex == leadIndex) {
            return;
        }
        this.leadSelectionIndex = leadIndex;
        if (this.isLeadAnchorNotificationEnabled()) {
            this.fireValueChanged(Math.min(this.leadSelectionIndex, leadIndex), Math.max(this.leadSelectionIndex, leadIndex));
        }
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    public void setLeadAnchorNotificationEnabled(boolean l) {
        this.leadAnchorNotificationEnabled = l;
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean v) {
        this.valueIsAdjusting = v;
    }

    public boolean isSelectionEmpty() {
        return this.sel.isEmpty();
    }

    public int getMinSelectionIndex() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        return this.sel.nextSetBit(0);
    }

    public int getMaxSelectionIndex() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        int mx = -1;
        int i = this.sel.nextSetBit(0);
        while (i >= 0) {
            mx = i;
            i = this.sel.nextSetBit(i + 1);
        }
        return mx;
    }

    public boolean isSelectedIndex(int a) {
        if (a >= this.sel.length() || a < 0) {
            return false;
        }
        return this.sel.get(a);
    }

    public void addSelectionInterval(int index0, int index1) {
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        this.oldSel = this.sel.clone();
        if (this.selectionMode == 0) {
            this.setSelectionInterval(index0, index1);
        }
        if (!(this.selectionMode != 1 || this.isSelectedIndex(index0) || this.isSelectedIndex(index1) || this.isSelectedIndex(Math.max(lo - 1, 0)) || this.isSelectedIndex(Math.min(hi + 1, this.sel.size())))) {
            this.sel.clear();
        }
        if (this.isSelectedIndex(this.leadSelectionIndex) && (index0 - 1 == this.leadSelectionIndex && index1 >= index0 && this.leadSelectionIndex >= this.anchorSelectionIndex || index0 + 1 == this.leadSelectionIndex && index1 <= index0 && this.leadSelectionIndex <= this.anchorSelectionIndex) && (this.anchorSelectionIndex != -1 || this.leadSelectionIndex != -1)) {
            this.setLeadCalledFromAdd = true;
            this.setLeadSelectionIndex(index1);
            this.setLeadCalledFromAdd = false;
        } else {
            this.leadSelectionIndex = index1;
            this.anchorSelectionIndex = index0;
            this.sel.set(lo, hi + 1);
            if (!this.sel.equals(this.oldSel)) {
                this.fireValueChanged(lo, hi, this.valueIsAdjusting);
            }
        }
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.oldSel = this.sel.clone();
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        if (this.getMinSelectionIndex() > 0 && this.getMinSelectionIndex() < lo && this.selectionMode == 1) {
            hi = this.sel.size() - 1;
        }
        this.sel.clear(lo, hi + 1);
        this.setAnchorSelectionIndex(index0);
        this.leadSelectionIndex = index1;
        if (!this.sel.equals(this.oldSel)) {
            this.fireValueChanged(lo, hi, this.valueIsAdjusting);
        }
    }

    public void clearSelection() {
        this.oldSel = this.sel.clone();
        int sz = this.sel.size();
        this.sel.clear();
        if (!this.sel.equals(this.oldSel)) {
            this.fireValueChanged(0, sz, this.valueIsAdjusting);
        }
    }

    public void setSelectionInterval(int index0, int index1) {
        this.oldSel = this.sel.clone();
        this.sel.clear();
        if (this.selectionMode == 0) {
            index0 = index1;
        }
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        this.sel.set(lo, hi + 1);
        this.setAnchorSelectionIndex(index0);
        this.leadSelectionIndex = index1;
        if (!this.sel.equals(this.oldSel)) {
            this.fireValueChanged(lo, hi, this.valueIsAdjusting);
        }
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        if (!before) {
            ++index;
            --length;
        }
        BitSet tmp = this.sel.get(index, this.sel.size());
        this.sel.clear(index, this.sel.size());
        int n = tmp.size();
        int i = 0;
        while (i < n) {
            this.sel.set(index + length + i, tmp.get(i));
            ++i;
        }
    }

    public void removeIndexInterval(int index0, int index1) {
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        BitSet tmp = this.sel.get(hi, this.sel.size());
        this.sel.clear(lo, this.sel.size());
        int n = tmp.size();
        int i = 0;
        while (i < n) {
            this.sel.set(lo + i, tmp.get(i));
            ++i;
        }
    }

    protected void fireValueChanged(boolean isAdjusting) {
        this.fireValueChanged(this.getMinSelectionIndex(), this.getMaxSelectionIndex(), isAdjusting);
    }

    protected void fireValueChanged(int firstIndex, int lastIndex) {
        this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        ListSelectionEvent evt = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
        ListSelectionListener[] listeners = this.getListSelectionListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueChanged(evt);
            ++i;
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        Class clazz = class$javax$swing$event$ListSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ListSelectionListener = DefaultListSelectionModel.class("[Ljavax.swing.event.ListSelectionListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        Class clazz = class$javax$swing$event$ListSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ListSelectionListener = DefaultListSelectionModel.class("[Ljavax.swing.event.ListSelectionListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        Class clazz = class$javax$swing$event$ListSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ListSelectionListener = DefaultListSelectionModel.class("[Ljavax.swing.event.ListSelectionListener;", false);
        }
        return (ListSelectionListener[])this.getListeners(clazz);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultListSelectionModel model = (DefaultListSelectionModel)super.clone();
        model.sel = (BitSet)this.sel.clone();
        return model;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listenerList = new EventListenerList();
        this.selectionMode = 2;
        this.leadSelectionIndex = -1;
        this.anchorSelectionIndex = -1;
        this.leadAnchorNotificationEnabled = true;
        this.valueIsAdjusting = false;
        this.sel = new BitSet();
        this.setLeadCalledFromAdd = false;
    }

    public DefaultListSelectionModel() {
        this.this();
    }
}

