/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    static final FlowStrategy sharedStrategy = new FlowStrategy();
    protected int layoutSpan;
    protected View layoutPool;
    protected FlowStrategy strategy = sharedStrategy;

    public int getFlowAxis() {
        int axis = this.getAxis();
        int flowAxis = axis == 0 ? 1 : 0;
        return flowAxis;
    }

    public int getFlowSpan(int index) {
        return this.layoutSpan;
    }

    public int getFlowStart(int index) {
        return this.getLeftInset();
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory vf) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this.getElement());
            Element el = this.getElement();
            int count = el.getElementCount();
            int i = 0;
            while (i < count) {
                Element childEl = el.getElement(i);
                View childView = vf.create(childEl);
                this.layoutPool.append(childView);
                ++i;
            }
        }
    }

    protected void layout(int width, int height) {
        boolean rebuild = false;
        int flowAxis = this.getFlowAxis();
        if (flowAxis == 0) {
            boolean bl = false;
            if (width == this.layoutSpan) {
                bl = true;
            }
            rebuild = bl ^ true;
            this.layoutSpan = width;
        } else {
            boolean bl = false;
            if (height == this.layoutSpan) {
                bl = true;
            }
            rebuild = bl ^ true;
            this.layoutSpan = height;
        }
        if (rebuild) {
            this.strategy.layout(this);
        }
        super.layout(width, height);
    }

    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory vf) {
        this.strategy.insertUpdate(this, changes, this.getInsideAllocation(a));
    }

    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory vf) {
        this.strategy.removeUpdate(this, changes, this.getInsideAllocation(a));
    }

    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory vf) {
        this.strategy.changedUpdate(this, changes, this.getInsideAllocation(a));
    }

    protected int getViewIndexAtPosition(int pos) {
        if (!this.isAllocationValid()) {
            this.layout(this.getWidth(), this.getHeight());
        }
        int count = this.getViewCount();
        int result = -1;
        int i = 0;
        while (i < count) {
            View child = this.getView(i);
            int start = child.getStartOffset();
            int end = child.getEndOffset();
            if (start <= pos && end > pos) {
                result = i;
                break;
            }
            ++i;
        }
        return result;
    }

    public FlowView(Element element, int axis) {
        super(element, axis);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class LogicalView
    extends View {
        Vector children;

        public Container getContainer() {
            return FlowView.this.getContainer();
        }

        public int getViewCount() {
            return this.children.size();
        }

        public View getView(int index) {
            return (View)this.children.get(index);
        }

        public void replace(int offset, int length, View[] views) {
            if (length > 0) {
                int count = 0;
                while (count < length) {
                    this.children.remove(offset);
                    ++count;
                }
            }
            int endOffset = offset + views.length;
            int i = offset;
            while (i < endOffset) {
                this.children.add(i, views[i - offset]);
                views[i - offset].setParent(FlowView.this);
                ++i;
            }
        }

        public int getViewIndex(int pos, Position.Bias b) {
            int index = -1;
            int i = 0;
            Iterator it = this.children.iterator();
            while (it.hasNext()) {
                View child = (View)it.next();
                if (child.getStartOffset() >= pos && child.getEndOffset() < pos) {
                    index = i;
                    break;
                }
                ++i;
            }
            return index;
        }

        public float getPreferredSpan(int axis) {
            throw new AssertionError((Object)"This method must not be called in LogicalView.");
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            throw new AssertionError((Object)"This method must not be called in LogicalView.");
        }

        public void paint(Graphics g, Shape s) {
            throw new AssertionError((Object)"This method must not be called in LogicalView.");
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
            throw new AssertionError((Object)"This method must not be called in LogicalView.");
        }

        LogicalView(Element el) {
            super(el);
            this.children = new Vector();
        }
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView fv, DocumentEvent e, Rectangle alloc) {
            this.layout(fv);
        }

        public void removeUpdate(FlowView fv, DocumentEvent e, Rectangle alloc) {
            this.layout(fv);
        }

        public void changedUpdate(FlowView fv, DocumentEvent e, Rectangle alloc) {
            this.layout(fv);
        }

        public View getLogicalView(FlowView fv) {
            return fv.layoutPool;
        }

        public void layout(FlowView fv) {
            fv.removeAll();
            Element el = fv.getElement();
            int rowStart = el.getStartOffset();
            int end = el.getEndOffset();
            int rowIndex = 0;
            while (rowStart >= 0 && rowStart < end) {
                View row = fv.createRow();
                fv.append(row);
                rowStart = this.layoutRow(fv, rowIndex, rowStart);
                ++rowIndex;
            }
        }

        protected int layoutRow(FlowView fv, int rowIndex, int pos) {
            int spanLeft = fv.getFlowSpan(rowIndex);
            if (spanLeft <= 0) {
                return -1;
            }
            int offset = pos;
            View row = fv.getView(rowIndex);
            int flowAxis = fv.getFlowAxis();
            while (spanLeft > 0) {
                View child = this.createView(fv, offset, spanLeft, rowIndex);
                if (child == null) {
                    offset = -1;
                    break;
                }
                int span = (int)child.getPreferredSpan(flowAxis);
                if (span > spanLeft) {
                    offset = -1;
                    break;
                }
                row.append(child);
                spanLeft -= span;
                offset = child.getEndOffset();
            }
            return offset;
        }

        protected View createView(FlowView fv, int offset, int spanLeft, int rowIndex) {
            int flowAxis;
            View logicalView = this.getLogicalView(fv);
            int viewIndex = logicalView.getViewIndex(offset, Position.Bias.Forward);
            if (viewIndex == -1) {
                return null;
            }
            View child = logicalView.getView(viewIndex);
            int span = (int)child.getPreferredSpan(flowAxis = fv.getFlowAxis());
            if (span <= spanLeft) {
                return child;
            }
            if (child.getBreakWeight(flowAxis, offset, spanLeft) > 0) {
                return child.breakView(flowAxis, offset, 0.0f, spanLeft);
            }
            return null;
        }
    }
}

