/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Byte
extends Number
implements Comparable {
    private static final long serialVersionUID = -7183698231559129828L;
    public static final byte MIN_VALUE = -128;
    public static final byte MAX_VALUE = 127;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('B');
    public static final int SIZE = 8;
    private static Byte[] byteCache = new Byte[256];
    private final byte value;

    public static final String toString(byte b) {
        return String.valueOf(b);
    }

    public static final byte parseByte(String s) {
        return Byte.parseByte(s, 10);
    }

    public static final byte parseByte(String s, int radix) {
        int i = Integer.parseInt(s, radix, false);
        if ((byte)i != i) {
            throw new NumberFormatException();
        }
        return (byte)i;
    }

    public static final Byte valueOf(String s, int radix) {
        return new Byte(Byte.parseByte(s, radix));
    }

    public static final Byte valueOf(String s) {
        return new Byte(Byte.parseByte(s, 10));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Byte valueOf(byte val) {
        Byte[] byteArray = byteCache;
        synchronized (byteCache) {
            if (byteCache[val - -128] == null) {
                Byte.byteCache[val - -128] = new Byte(val);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byteCache[val - -128];
        }
    }

    public static final Byte decode(String s) {
        int i = Integer.parseInt(s, 10, true);
        if ((byte)i != i) {
            throw new NumberFormatException();
        }
        return new Byte((byte)i);
    }

    public final byte byteValue() {
        return this.value;
    }

    public final short shortValue() {
        return this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public final long longValue() {
        return this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final String toString() {
        return String.valueOf(this.value);
    }

    public final int hashCode() {
        return this.value;
    }

    public final boolean equals(Object obj) {
        boolean bl = false;
        if (obj instanceof Byte && this.value == ((Byte)obj).value) {
            bl = true;
        }
        return bl;
    }

    public final int compareTo(Byte b) {
        return this.value - b.value;
    }

    public final int compareTo(Object o) {
        return this.compareTo((Byte)o);
    }

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String s) {
        this.value = Byte.parseByte(s, 10);
    }
}

