$NetBSD: patch-src_3rdparty_chromium_third__party_blink_renderer_bindings_scripts_web__idl_function__like.py,v 1.1 2023/06/08 20:38:06 markd Exp $

build with python3

--- src/3rdparty/chromium/third_party/blink/renderer/bindings/scripts/web_idl/function_like.py.orig	2022-03-30 09:48:18.000000000 +0000
+++ src/3rdparty/chromium/third_party/blink/renderer/bindings/scripts/web_idl/function_like.py
@@ -71,8 +71,9 @@ class FunctionLike(WithIdentifier):
     def num_of_required_arguments(self):
         """Returns the number of required arguments."""
         return len(
-            filter(lambda arg: not (arg.is_optional or arg.is_variadic),
-                   self.arguments))
+            list(
+                filter(lambda arg: not (arg.is_optional or arg.is_variadic),
+                       self.arguments)))
 
 
 class OverloadGroup(WithIdentifier):
@@ -171,8 +172,7 @@ class OverloadGroup(WithIdentifier):
         Returns the effective overload set.
         https://heycam.github.io/webidl/#compute-the-effective-overload-set
         """
-        assert argument_count is None or isinstance(argument_count,
-                                                    (int, long))
+        assert argument_count is None or isinstance(argument_count, int)
 
         N = argument_count
         S = []
@@ -188,21 +188,21 @@ class OverloadGroup(WithIdentifier):
 
             S.append(
                 OverloadGroup.EffectiveOverloadItem(
-                    X, map(lambda arg: arg.idl_type, X.arguments),
-                    map(lambda arg: arg.optionality, X.arguments)))
+                    X, list(map(lambda arg: arg.idl_type, X.arguments)),
+                    list(map(lambda arg: arg.optionality, X.arguments))))
 
             if X.is_variadic:
-                for i in xrange(n, max(maxarg, N)):
-                    t = map(lambda arg: arg.idl_type, X.arguments)
-                    o = map(lambda arg: arg.optionality, X.arguments)
-                    for _ in xrange(n, i + 1):
+                for i in range(n, max(maxarg, N)):
+                    t = list(map(lambda arg: arg.idl_type, X.arguments))
+                    o = list(map(lambda arg: arg.optionality, X.arguments))
+                    for _ in range(n, i + 1):
                         t.append(X.arguments[-1].idl_type)
                         o.append(X.arguments[-1].optionality)
                     S.append(OverloadGroup.EffectiveOverloadItem(X, t, o))
 
-            t = map(lambda arg: arg.idl_type, X.arguments)
-            o = map(lambda arg: arg.optionality, X.arguments)
-            for i in xrange(n - 1, -1, -1):
+            t = list(map(lambda arg: arg.idl_type, X.arguments))
+            o = list(map(lambda arg: arg.optionality, X.arguments))
+            for i in range(n - 1, -1, -1):
                 if X.arguments[i].optionality == IdlType.Optionality.REQUIRED:
                     break
                 S.append(OverloadGroup.EffectiveOverloadItem(X, t[:i], o[:i]))
@@ -222,7 +222,7 @@ class OverloadGroup(WithIdentifier):
             for item in items)
         assert len(items) > 1
 
-        for index in xrange(len(items[0].type_list)):
+        for index in range(len(items[0].type_list)):
             # Assume that the given items are valid, and we only need to test
             # the two types.
             if OverloadGroup.are_distinguishable_types(
