/* Written by Morgoth DBMA, morgothdbma@o2.pl
 This is part of PgXexplorer software, Open Source
 on BSD licence, Libraries(interaces) used:
 GNU GCC, AS (all stuff needed to compile C source into executable binary)
 LibPQ-FE from PostgreSQL, GTK (GIMP Toolkit)
 written in VIM editor, ctags used, CVS used
 Currently only one author: MOrgoth DBMA
 FILE: query.c */
#include "common.h"
#include <libpq-fe.h>
#include "consoleout.h"
#include "query.h"
#include "signals.h"
/*FIXME dodac obsluge debug, error ==> DlgWindow*/
/* THERE WOULDN'T BE ANY DEBUG LOG TO FILE ETC. */
int ping_conn;
extern int timeout;

int connAlive(PGconn* c)
{
 PGresult* r;
 int stat;
 debug("%s:%d", __FILE__,__LINE__);
 ping_conn=1;
 alarm_clock(timeout);
 r= PQexec(c, "SELECT datname FROM pg_database");
 alarm_stop();
 if (!r)
   {
    debug("PQresult is NULL %s\n", PQerrorMessage(c));
    return 0;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    debug("PQexec error: %s %s",PQcmdStatus(r),PQresultErrorMessage(r));
    return 0;
   }
 return ping_conn;
}


void disconnect_db(PGconn** c)
{
 debug("%s:%d", __FILE__,__LINE__);
 if (*c) PQfinish(*c);
 else warn("connect is null: %s:%d", __FILE__,__LINE__);
 *c = NULL;
}


PGconn* connect_db(char* arg)
{
 PGconn* conn;
 char* strarg;
 conn=0;
 debug("%s:%d", __FILE__,__LINE__);
 strarg = (char*)malloc(strlen(arg)+32);
 debug("\nconnect to database %s\n", arg);
 sprintf(strarg,"dbname=template1");
 alarm_clock(timeout);
 conn = PQconnectdb(strarg);
 alarm_stop();
 if (!conn) { error("cannot connect to template1 DB"); free(strarg); return NULL; }
 if (PQstatus(conn)==CONNECTION_BAD) {  error("cannot connect to template1 DB"); free(strarg); return NULL; }
 disconnect_db(&conn);
 sprintf(strarg,"dbname=%s", arg);
 alarm_clock(timeout);
 conn = PQconnectdb(strarg);
 alarm_stop();
 if (!conn) { error("connection is NULL %s:%d", __FILE__,__LINE__); return NULL; }
 if (PQstatus(conn) == CONNECTION_BAD)
   {
    error("\nCannot connect to DB:%s\n", arg);
    ERR
    free(strarg);
    return NULL;
   }
 free(strarg);
 return conn;
}


PGconn* gtk_connect_db(char* arg, char* errstr)
{
 PGconn* conn;
 char* strarg;
 conn=0;
 debug("%s:%d", __FILE__,__LINE__);
 strarg = (char*)malloc(strlen(arg)+16);
 sprintf(strarg,"dbname=template1");
 alarm_clock(timeout);
 conn = PQconnectdb(strarg);
 alarm_stop();
 if (!conn) { sprintf(errstr,"cannot connect to template1 DB"); free(strarg); return NULL; }
 if (PQstatus(conn)==CONNECTION_BAD) {  sprintf(errstr,"cannot connect to template1 DB"); free(strarg); return NULL; }
 disconnect_db(&conn);
 sprintf(strarg,"dbname=%s", arg);
 alarm_clock(timeout);
 conn = PQconnectdb(strarg);
 alarm_stop();
 if (!conn) { error("connection is NULL %s:%d", __FILE__,__LINE__); free(strarg); return NULL; }
 if (PQstatus(conn) == CONNECTION_BAD)
  {
   sprintf(errstr, "Connection string:\ndbname=%s failed.", arg);
   free(strarg);
   return NULL;
  }
 free(strarg);
 return conn;
}


void clear_result(PGresult** r)
{
 debug("%s:%d", __FILE__,__LINE__);
 if (*r) PQclear(*r);
 *r=0;
}


PGresult* execute_silent_query(PGconn* c,  char* query)
{
 PGresult* r;
 int stat;
 debug("%s:%d", __FILE__,__LINE__);
 debug("SQLquery: \"%s\"\n", query);
 if (!connAlive(c)) { debug("connection dead!\n"); return NULL; }
 if (!query)
   {
    debug("NULL query passed\n");
    return NULL;
   }
 if (!c) { error("no connection"); return NULL; }
 r= PQexec(c, query);
 if (!r)
   {
    debug("PQresult is NULL %s\n", PQerrorMessage(c));
    return NULL;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    debug("PQexec error: %s %s",PQcmdStatus(r),PQresultErrorMessage(r));
    debug("Failed query was: \"%s\"\n", query);
    return NULL;
   }
 return r;
}


char*** p3c_execute_printf(PGconn* c,int* row, int* col, char* errstr, int want_meta, char* fmt,...)
{
 va_list ap;
 char*** ret;
 char msg[MAX_QUERY_LENGTH*2];
 debug("%s:%d", __FILE__,__LINE__);
 if (!c) { error("no connection"); return NULL; }
 va_start(ap, fmt);
 vsprintf(msg,fmt,ap);
 va_end(ap);
 execute_printf(c, &ret, row, col, errstr, want_meta, msg);
 return ret;
}


void execute_printf(PGconn* c, char**** res, int* row, int* col, char* errstr, int want_meta, char* fmt,...)
{
 int stat;
 va_list ap;
 char query[MAX_QUERY_LENGTH*2];
 PGresult* r;
 debug("%s:%d", __FILE__,__LINE__);
 va_start(ap, fmt);
 vsprintf(query,fmt,ap);
 va_end(ap);
 r=NULL;
 if (!c)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "Not connected to DB");
    return;
   }
 if (!query)
   {
    *res = NULL;
    *row = *col = -1;
    strcpy(errstr, "NULL query passed to DB");
    return;
   }
 if (!connAlive(c)) { sprintf(errstr,"connection dead!\n"); return ; }
 r= PQexec(c, query);
 if (!r)
   {
    sprintf(errstr,"PQresult is NULL %s\nQuery was:\n%s\n", PQerrorMessage(c), query);
    *res = NULL;
    *row = *col = -1;
    return ;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    sprintf(errstr,"PQexec:\n%s\n%s\nQuery was:\n%s",PQcmdStatus(r),PQresultErrorMessage(r), query);
    *res = NULL;
    *row = *col = -1;
    clear_result(&r);
    return;
   }
 *res = pgres2pc3(r, row, col, want_meta);
 clear_result(&r);
}


void execute_printf_query(PGconn* c,PGresult** r, char* errstr, char* fmt,...)
{
 int stat;
 va_list ap;
 char query[MAX_QUERY_LENGTH*2];
 debug("%s:%d", __FILE__,__LINE__);
 va_start(ap, fmt);
 vsprintf(query,fmt,ap);
 va_end(ap);
 if (!c)
   {
    *r = NULL;
    strcpy(errstr, "Not connected to DB");
    return;
   }
 if (!query)
   {
    *r = NULL;
    strcpy(errstr, "NULL query passed to DB");
    return;
   }
 if (!connAlive(c)) { sprintf(errstr,"connection dead!\n"); return ; }
 *r= PQexec(c, query);
 if (!*r)
   {
    sprintf(errstr,"PQresult is NULL %s\nQuery was:\n%s\n", PQerrorMessage(c), query);
    return ;
   }
 stat = PQresultStatus(*r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    sprintf(errstr,"PQexec:\n%s\n%s\nQuery was:\n%s",PQcmdStatus(*r),PQresultErrorMessage(*r), query);
    clear_result(r);
    *r = NULL;
    return;
   }
}


int get_db_tables(PGconn* c, char*** dat, int* ntabs, int want_all_elems)
{
 char*** res;
 char** data;
 int row,col,i;
 char errstr[MAX_QUERY_LENGTH+100];
 data = *dat;
 debug("%s:%d", __FILE__,__LINE__);
 if (!want_all_elems)
 execute_printf(c, &res, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables WHERE tablename NOT LIKE 'pg_%%' AND tablename NOT LIKE 'sql_%%' ORDER BY tablename");
 else
 execute_printf(c, &res, &row, &col, errstr, 0,
		 "SELECT tablename from pg_tables ORDER BY tablename");
 if (!res || col<0 || row<0) { printf("errstr=%s\n", errstr); (*data) = NULL; *ntabs=-1; return 0; }
 *ntabs = row;
 data = (char**)malloc(row<<2);
 for (i=0;i<row;i++) 
   { 
    data[i] = malloc(strlen(res[i][0])+1); 
    strcpy(data[i], res[i][0]); 
   }
 *dat = data;
 return 1;
}


PGresult* execute_query(PGconn* c,  char* query)
{
 PGresult* r;
 int stat;
 debug("%s:%d", __FILE__,__LINE__);
 debug("SQLquery: \"%s\"\n", query);
 if (!query)
   {
    ERR error("NULL query passed\n");
    return NULL;
   }
 if (!c) return NULL;
 if (!connAlive(c)) { debug("connection dead!\n"); return NULL; }
 r= PQexec(c, query);
 if (!r)
   {
    ERR error("PQresult is NULL %s\n", PQerrorMessage(c));
    return NULL;
   }
 stat = PQresultStatus(r);
 if (stat!=PGRES_COMMAND_OK && stat!=PGRES_TUPLES_OK)
   {
    ERR error("PQexec: %s %s",PQcmdStatus(r),PQresultErrorMessage(r));
    error("Failed query was: \"%s\"\n", query);
    return NULL;
   }
 return r;
}


char*** pgres2pc3(const PGresult* r, int* a, int* b, int want_meta)
{
 char*** result;
 char* tmp;
 int i,j;
 debug("%s:%d", __FILE__,__LINE__);
 debug("pgres2pc3: %p\n", (void*)r);
 if (!r) return 0;
 i=j=0;
 *a = PQntuples(r);
 *b = PQnfields(r);
 /*printf("ntuples=%d,%d\n", *a,*b);*/
 if (!want_meta)
 {
 result = (char***)malloc((*a)<<2);
 if (!result) { ERR error("malloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)malloc((*b)<<2);
    if (!result[i])
      {
       for (j=0;j<i;j++) free(result[i]);
       ERR error("malloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)malloc(PQgetlength(r,i,j)+1);
    if (!result[i][j])
      {
       free_p3c(&result,*a,*b);
       ERR error("malloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i,j));
   }
/*#ifdef DEBUG
  debug("char*** result is (%d:%d):\n",i,j);
  for (i=0;i<*a;i++)
    {
     for (j=0;j<*b;j++) debug("%-15s ", result[i][j]);
     ln();
    }
#endif*/
 return result;
 }
 else
 {
  if ((*b)<=0) return NULL;		/*FIXME is it OK? */
 (*a)++;
 result = (char***)malloc((*a)<<2);
 if (!result) { ERR error("malloc error\n"); return NULL; }
 for (i=0;i<*a;i++)
   {
    result[i] = (char**)malloc((*b)<<2);
    if (!result[i])
      {
       for (j=0;j<i;j++) free(result[i]);
       ERR error("malloc_i error!\n");
       return NULL;
      }
   }
 for (i=0;i<*b;i++)
   {
    tmp = PQfname(r,i);
    result[0][i] = (char*)malloc(strlen(tmp)+1);
    if (!result[0][i]) { ERR error("malloc_namej error"); return NULL; }
    strcpy(result[0][i], tmp);
   }
 for (i=1;i<*a;i++)
 for (j=0;j<*b;j++)
   {
    result[i][j] = (char*)malloc(PQgetlength(r,i-1,j)+1);
    if (!result[i][j])
      {
       free_p3c(&result,*a,*b);
       ERR error("malloc_ij error\n");
       return NULL;
      }
    strcpy(result[i][j], (char*)PQgetvalue(r,i-1,j));
   }
  return result;
 }
}


void free_p3c(char**** p, int a, int b)
{
 int i,j;
 debug("%s:%d", __FILE__,__LINE__);
 debug("free_p3c: ****p=%p, a=%d, b=%d\n",(void*)p,a,b);
 if (!(*p)) return ;
 for (i=0;i<a;i++) if (!(*p)[i]) return ;
 for (i=0;i<a;i++)
 for (j=0;j<b;j++) if ((*p)[i][j]) free((*p)[i][j]);
 for (i=0;i<a;i++) if ((*p)[i])    free((*p)[i]);
 free(*p);
}

