////////////////////////////////////////////////////////////////////////////////
// マルチGadgetフレームワーク
//    Copyright (C) 2008 - 2011 AAOh inc.
////////////////////////////////////////////////////////////////////////////////

/**
 * @fileOverview マルチGadgetフレームワーク
 * @author       $Author: fujishiro $
 */

/**
 * namespace。
 *   aaoh.sora.Control
 *   aaoh.sora.Model
 *   aaoh.sora.Main
 *   aaoh.sora.Option
 *   aaoh.sora.App (static)
 */

(function () {
/**
 * Control。
 *
 * @constructor
 */
aaoh.sora.Control = function() {
	// Application名。
	this.APP_NAME    = '';
	this.APP_VERSION = '0.0.0.0';

	// Windowサイズ。
	this.WINDOW_ONDOCK_WIDTH         = 0;
	this.WINDOW_ONDOCK_HEIGHT        = 0;
	this.WINDOW_UNDOCK_WIDTH         = this.WINDOW_ONDOCK_WIDTH;
	this.WINDOW_UNDOCK_HEIGHT        = this.WINDOW_ONDOCK_HEIGHT;
	this.WINDOW_ONDOCK_MOBILE_WIDTH  = this.WINDOW_ONDOCK_WIDTH;
	this.WINDOW_ONDOCK_MOBILE_HEIGHT = this.WINDOW_ONDOCK_HEIGHT;
	this.WINDOW_UNDOCK_MOBILE_WIDTH  = this.WINDOW_ONDOCK_MOBILE_WIDTH;
	this.WINDOW_UNDOCK_MOBILE_HEIGHT = this.WINDOW_ONDOCK_MOBILE_HEIGHT;
	this.WINDOW_OPTION_WIDTH         = 0;
	this.WINDOW_OPTION_HEIGHT        = 0;
	this.WINDOW_OPTION_MOBILE_WIDTH  = this.WINDOW_OPTION_WIDTH;
	this.WINDOW_OPTION_MOBILE_HEIGHT = this.WINDOW_OPTION_HEIGHT;

	// アクセス画像
	this.LOADING_IMG = 'lib/images/aaoh.sora.img-loading.png';

	// エレメント名
	this.HEADER_NM = 'header';
		this.TOOLBAR_NM    = 'toolbar';
		this.BTN_MAX_NM    = 'btnMax';
		this.BTN_OPTION_NM = 'btnOption';
		this.BTN_CLOSE_NM  = 'btnClose';
	this.MAIN_NM = 'main';
		this.ONDOCK_NM = 'onDock';
		this.UNDOCK_NM = 'unDock';
	this.OPTION_NM = 'option';
		this.BTN_GENERAL_NM = 'btnGeneral';
		this.BTN_DETAIL_NM  = 'btnDetail';
		this.OPT_GENERAL_NM = 'optGeneral';
		this.OPT_DETAIL_NM  = 'optDetail';
		this.OPT_SETTING_NM = 'optSetting';
		this.SEL_LOCALE_NM  = 'selLocale';
		this.BTN_OK_NM      = 'btnOK';
		this.BTN_CANCEL_NM  = 'btnCancel';
	this.FOOTER_NM = 'footer';

	this.TIP_MAX       = 'TIP_MAX';
	this.TIP_MIN       = 'TIP_MIN';
	this.TIP_OPTION    = 'TIP_OPTION';
	this.TIP_CLOSE     = 'TIP_CLOSE';
	this.YWIDGET_NAME  = 'YWIDGET_NAME';
	this.TTL_GENERAL   = 'TTL_GENERAL';
	this.TTL_DETAIL    = 'TTL_DETAIL';
	this.TTL_OK        = 'TTL_OK';
	this.TTL_CANCEL    = 'TTL_CANCEL';
	this.TAB_ACT       = '#000000';
	this.TAB_INACT     = '#7f7f7f';
	this.TAB_IMG_ACT   = 'lib/images/aaoh.sora.img-tab-act.png';
	this.TAB_IMG_INACT = 'lib/images/aaoh.sora.img-tab-inact.png';
		this.TAB_IMG_ACT_UP     = 'lib/sub-images/aaoh.sora.img-tab-act_up.png';
		this.TAB_IMG_ACT_OVER   = 'lib/sub-images/aaoh.sora.img-tab-act_over.png';
		this.TAB_IMG_ACT_DOWN   = 'lib/sub-images/aaoh.sora.img-tab-act_down.png';
		this.TAB_IMG_INACT_UP   = 'lib/sub-images/aaoh.sora.img-tab-inact_up.png';
		this.TAB_IMG_INACT_OVER = 'lib/sub-images/aaoh.sora.img-tab-inact_over.png';
		this.TAB_IMG_INACT_DOWN = 'lib/sub-images/aaoh.sora.img-tab-inact_down.png';

	this.YAHOO_TOP_NM     = 'index';
	this.GOOGLE_OPTION_OK = 'googleOptionOK';

	// パラメータ
	this.flgOnDock = true;
	this.storage   = new aaoh.kaze.Storage();
	this.json      = new aaoh.kaze.JSON();
	this.locale    = new aaoh.kaze.Locale();
}
aaoh.sora.Control.prototype = {
	/**
	 * メイン画面を表示します。
	 *
	 * @param {Boolean} flgOnDock_ onDockフラグ
	 * @param {Boolean} flgInit    データ初期化フラグ
	 */
	showMain: function(flgOnDock_, flgInit) {
		var mainObj   = aaoh.kaze.Gadget.$(this.MAIN_NM);
		var optionObj = aaoh.kaze.Gadget.$(this.OPTION_NM);
		if (mainObj == null && optionObj == null) {
			return;
		}

		if (mainObj != null) {
			aaoh.kaze.Element.setDisplay(mainObj, false);
		}
		if (optionObj != null) {
			aaoh.kaze.Element.setDisplay(optionObj, false);
		}

		// データ初期化
		if (flgInit) {
			this.initMainData();
		}

		var onDockObj = aaoh.kaze.Gadget.$(this.ONDOCK_NM);
		var unDockObj = aaoh.kaze.Gadget.$(this.UNDOCK_NM);
		if (onDockObj != null && unDockObj != null) {
			if (flgOnDock_) {
				aaoh.kaze.Element.setDisplay(onDockObj, true);
				aaoh.kaze.Element.setDisplay(unDockObj, false);

			} else {
				aaoh.kaze.Element.setDisplay(onDockObj, false);
				aaoh.kaze.Element.setDisplay(unDockObj, true);
			}
		} // if (onDockObj != null && unDockObj != null)

		var width  = 0;
		var height = 0;
		var btnMax = aaoh.kaze.Gadget.$(aaoh.sora.App.control.BTN_MAX_NM);
		if (flgOnDock_) {
			var tipMax = aaoh.sora.App.control.locale.getLocalizedString(
				aaoh.sora.App.control.TIP_MAX, true
			);
			if (btnMax != null && tipMax != null) {
				aaoh.kaze.Element.setTooltip(btnMax, tipMax);
			}

			if (aaoh.kaze.Type.isMobile()) {
				width  = this.WINDOW_ONDOCK_MOBILE_WIDTH;
				height = this.WINDOW_ONDOCK_MOBILE_HEIGHT;

			} else {
				width  = this.WINDOW_ONDOCK_WIDTH;
				height = this.WINDOW_ONDOCK_HEIGHT;
			}

		} else {
			var tipMin = aaoh.sora.App.control.locale.getLocalizedString(
				aaoh.sora.App.control.TIP_MIN, true
			);
			if (btnMax != null && tipMin != null) {
				aaoh.kaze.Element.setTooltip(btnMax, tipMin);
			}

			if (aaoh.kaze.Type.isMobile()) {
				width  = this.WINDOW_UNDOCK_MOBILE_WIDTH;
				height = this.WINDOW_UNDOCK_MOBILE_HEIGHT;

			} else {
				width  = this.WINDOW_UNDOCK_WIDTH;
				height = this.WINDOW_UNDOCK_HEIGHT;
			}
		} // if (flgOnDock_)

		if (width > 0 &&  height > 0) {
			if (aaoh.kaze.Type.isGoogle() || aaoh.kaze.Type.isYahoo()) {
				if (mainObj != null && onDockObj != null && unDockObj != null) {
					aaoh.kaze.Element.setSize(mainObj, width, height);
				}

				var headerObj  = aaoh.kaze.Gadget.$(this.HEADER_NM);
				var toolbarObj = aaoh.kaze.Gadget.$(this.TOOLBAR_NM);
				if (headerObj != null && toolbarObj != null) {
					var size = aaoh.kaze.Element.getSize(toolbarObj);
					var left = width - size.width;

					aaoh.kaze.Element.setPosition(toolbarObj, left, 0);
					aaoh.kaze.Element.setSize(headerObj, width, size.height);
				}
			} // if (aaoh.kaze.Type.isGoogle() || aaoh.kaze.Type.isYahoo())

			aaoh.kaze.Gadget.setSize(width, height);
		} // if (width > 0 &&  height > 0)

		// メイン画面を表示
		if (mainObj != null) {
			aaoh.kaze.Element.setDisplay(mainObj, true);
		}
	},

	/**
	 * 設定画面を表示します。
	 */
	showOption: function() {
		var mainObj   = aaoh.kaze.Gadget.$(this.MAIN_NM);
		var optionObj = aaoh.kaze.Gadget.$(this.OPTION_NM);
		if (mainObj == null && optionObj == null) {
			return;
		}

		if (!aaoh.kaze.Type.isSidebar() && !aaoh.kaze.Type.isGoogle()) {
			var flgDisp = true;
			if (optionObj != null) {
				flgDisp = aaoh.kaze.Element.isDisplay(optionObj);
			}
			if (flgDisp) {
				return;
			}
		}
		if (mainObj != null) {
			aaoh.kaze.Element.setDisplay(mainObj, false);
		}

		// データ初期化
		this.initOptionData();

		var width  = 0;
		var height = 0;
		if (aaoh.kaze.Type.isMobile()) {
			width  = this.WINDOW_OPTION_MOBILE_WIDTH;
			height = this.WINDOW_OPTION_MOBILE_HEIGHT;

		} else {
			width  = this.WINDOW_OPTION_WIDTH;
			height = this.WINDOW_OPTION_HEIGHT;
		}
		if (width > 0 &&  height > 0) {
			aaoh.kaze.Gadget.setSize(width, height);
		}

		// 設定画面を表示
		if (optionObj != null) {
			// locale
			var selLocale = aaoh.kaze.Gadget.$(this.SEL_LOCALE_NM);
			if (selLocale != null) {
				aaoh.kaze.Element.setValue(
					selLocale, aaoh.sora.App.model.data.locale
				);
			}

			// optGeneral
			var btnGeneral = aaoh.kaze.Gadget.$(this.BTN_GENERAL_NM);
			var optGeneral = aaoh.kaze.Gadget.$(this.OPT_GENERAL_NM);
			if (btnGeneral != null && optGeneral != null) {
				aaoh.kaze.Element.setForeground(btnGeneral, this.TAB_ACT);
				if (
					!aaoh.kaze.Type.isGoogle()
					&& !(aaoh.kaze.Type.isOthers() && aaoh.kaze.Type.isIE())
				) {
					aaoh.kaze.Element.setBackgroundImage(
						btnGeneral, this.TAB_IMG_ACT
					);

				} else {
					aaoh.kaze.Element.setBackgroundImage(
						btnGeneral,
						this.TAB_IMG_ACT_UP,
						this.TAB_IMG_ACT_OVER, this.TAB_IMG_ACT_DOWN
					);
				}
				aaoh.kaze.Element.setDisplay(optGeneral, true);
			}

			var btnDetail = aaoh.kaze.Gadget.$(this.BTN_DETAIL_NM);
			var optDetail = aaoh.kaze.Gadget.$(this.OPT_DETAIL_NM);
			if (btnDetail != null && optDetail != null) {
				aaoh.kaze.Element.setForeground(btnDetail, this.TAB_INACT);
				if (
					!aaoh.kaze.Type.isGoogle()
					&& !(aaoh.kaze.Type.isOthers() && aaoh.kaze.Type.isIE())
				) {
					aaoh.kaze.Element.setBackgroundImage(
						btnDetail, this.TAB_IMG_INACT
					);

				} else {
					aaoh.kaze.Element.setBackgroundImage(
						btnDetail,
						this.TAB_IMG_INACT_UP,
						this.TAB_IMG_INACT_OVER, this.TAB_IMG_INACT_DOWN
					);
				}
				aaoh.kaze.Element.setDisplay(optDetail,  false);
			}

			aaoh.kaze.Element.setDisplay(optionObj, true);
		} // if (optionObj != null)
	},

	/**
	 * 設定画面でOKボタンを押下されたときの設定。
	 */
	setOption: function() {
		if (aaoh.kaze.Type.isSidebar()) {
			if (aaoh.sora.App.option != null) {
				/** @private */
				System.Gadget.onSettingsClosing = function(event) {
					if (event.closeAction != event.Action.commit) {
						return;
					}
					if (aaoh.sora.App.option == null) {
						return;
					}

					// locale
					var beforeLang = aaoh.sora.App.model.data.locale;
					var selLocale  = aaoh.kaze.Gadget.$(
						aaoh.sora.App.control.SEL_LOCALE_NM
					);
					if (selLocale != null) {
						aaoh.sora.App.model.data.locale
							= aaoh.kaze.Element.getValue(selLocale);
					}

					aaoh.sora.App.option.doOption();
					aaoh.sora.App.model.writeData(
						aaoh.sora.App.control.APP_NAME,
						aaoh.sora.App.control.APP_VERSION
					);

					// 言語の切替え
					if (aaoh.sora.App.model.data.locale != beforeLang) {
						aaoh.sora.App.control.locale.setLocale(
							aaoh.sora.App.model.data.locale
						);
					}
				}
			} // if (aaoh.sora.App.option != null)

			if (aaoh.sora.App.main != null) {
				/** @private */
				System.Gadget.onSettingsClosed = function(event) {
					if (event.closeAction != event.Action.commit) {
						return;
					}

					aaoh.sora.App.model.readData(
						aaoh.sora.App.control.APP_NAME,
						aaoh.sora.App.control.APP_VERSION
					);
					aaoh.sora.App.control.initMainData();
				}
			} // if (aaoh.sora.App.main != null)

		} else if (aaoh.kaze.Type.isIGoogle()) {
			// 何もしない

		} else if (aaoh.kaze.Type.isGoogle()) {
			if (aaoh.sora.App.option != null) {
				/** @private */
				view.onok = function() {
					if (aaoh.sora.App.option == null) {
						return;
					}

					// locale
					var beforeLang = aaoh.sora.App.model.data.locale;
					var selLocale  = aaoh.kaze.Gadget.$(
						aaoh.sora.App.control.SEL_LOCALE_NM
					);
					if (selLocale != null) {
						aaoh.sora.App.model.data.locale
							= aaoh.kaze.Element.getValue(selLocale);
					}

					aaoh.sora.App.option.doOption();
					aaoh.sora.App.model.writeData(
						aaoh.sora.App.control.APP_NAME,
						aaoh.sora.App.control.APP_VERSION
					);
					// 言語の切替え
					if (aaoh.sora.App.model.data.locale != beforeLang) {
						aaoh.sora.App.control.locale.setLocale(
							aaoh.sora.App.model.data.locale, function() {
								aaoh.sora.App.control.storage.writeString(
									aaoh.sora.App.control.GOOGLE_OPTION_OK,
									new Date().toString()
								);
							}
						);
					}

					aaoh.sora.App.control.storage.writeString(
						aaoh.sora.App.control.GOOGLE_OPTION_OK,
						new Date().toString()
					);
				}
			} // if (aaoh.sora.App.option != null)

			if (aaoh.sora.App.main != null) {
				/** @private */
				view.onoptionchanged = function() {
					if (
						event != null
						&& event.propertyName != aaoh.sora.App.control.GOOGLE_OPTION_OK
					) {
						return;
					}

					aaoh.sora.App.model.readData(
						aaoh.sora.App.control.APP_NAME,
						aaoh.sora.App.control.APP_VERSION
					);
					aaoh.sora.App.control.initMainData();
				}
			} // if (aaoh.sora.App.main != null)

		} else if (aaoh.kaze.Type.isYahoo()) {
				/** @private */
			widget.onPreferencesChanged = function() {
				aaoh.sora.App.model.readData(
					aaoh.sora.App.control.APP_NAME,
					aaoh.sora.App.control.APP_VERSION
				);
				aaoh.sora.App.control.initMainData();
			}

		} else {
			var btnOK     = aaoh.kaze.Gadget.$(this.BTN_OK_NM);
			var btnCancel = aaoh.kaze.Gadget.$(this.BTN_CANCEL_NM);
			if (btnOK != null && btnCancel != null) {
				aaoh.kaze.Element.setOnClick(btnOK, function() {
					if (aaoh.sora.App.option == null) {
						return;
					}
					var optionObj = aaoh.kaze.Gadget.$(
						aaoh.sora.App.control.OPTION_NM
					);
					if (optionObj != null) {
						aaoh.kaze.Element.setDisplay(optionObj, false);
					}

					// locale
					var beforeLang = aaoh.sora.App.model.data.locale;
					var selLocale  = aaoh.kaze.Gadget.$(
						aaoh.sora.App.control.SEL_LOCALE_NM
					);
					if (selLocale != null) {
						aaoh.sora.App.model.data.locale
							= aaoh.kaze.Element.getValue(selLocale);
					}

					aaoh.sora.App.option.doOption();
					aaoh.sora.App.model.writeData(
						aaoh.sora.App.control.APP_NAME,
						aaoh.sora.App.control.APP_VERSION
					);

					// 言語の切替え
					if (aaoh.sora.App.model.data.locale != beforeLang) {
						aaoh.sora.App.control.locale.setLocale(
							aaoh.sora.App.model.data.locale, function() {
								aaoh.sora.App.control.showMain(
									aaoh.sora.App.control.flgOnDock, true
								);
							}
						);
					}
					aaoh.sora.App.control.showMain(
						aaoh.sora.App.control.flgOnDock, true
					);
				});

				aaoh.kaze.Element.setOnClick(btnCancel, function() {
					aaoh.sora.App.control.showMain(
						aaoh.sora.App.control.flgOnDock, false
					);
				});
			} // if (btnOK != null && btnCancel != null)
		} // if (aaoh.kaze.Type.isSidebar())
	},

	/**
	 * 設定画面での切替え設定。
	 */
	setOptionHeader: function() {
		if (
			(aaoh.kaze.Type.isSidebar() && aaoh.sora.App.option == null)
			|| (aaoh.kaze.Type.isGoogle() && aaoh.sora.App.option == null)
			|| aaoh.kaze.Type.isIGoogle() || aaoh.kaze.Type.isYahoo()
		) {
			return;
		} // if ((aaoh.kaze.Type.isSidebar() && aaoh.sora.App.option == null) ...)

		// optGeneral
		var btnGeneral = aaoh.kaze.Gadget.$(this.BTN_GENERAL_NM);
		var btnDetail  = aaoh.kaze.Gadget.$(this.BTN_DETAIL_NM);
		if (btnGeneral != null && btnDetail != null) {
			/** @private */
			aaoh.kaze.Element.setOnClick(btnGeneral, function() {
				var btnGeneral = aaoh.kaze.Gadget.$(
					aaoh.sora.App.control.BTN_GENERAL_NM
				);
				var btnDetail = aaoh.kaze.Gadget.$(
					aaoh.sora.App.control.BTN_DETAIL_NM
				);
				var optGeneral = aaoh.kaze.Gadget.$(
					aaoh.sora.App.control.OPT_GENERAL_NM
				);
				var optDetail = aaoh.kaze.Gadget.$(
					aaoh.sora.App.control.OPT_DETAIL_NM
				);
				if (
					btnGeneral == null || btnDetail == null
					|| optGeneral == null || optDetail == null
				) {
					return;
				}

				aaoh.kaze.Element.setForeground(
					btnGeneral, aaoh.sora.App.control.TAB_ACT
				);
				if (
					!aaoh.kaze.Type.isGoogle()
					&& !(aaoh.kaze.Type.isOthers() && aaoh.kaze.Type.isIE())
				) {
					aaoh.kaze.Element.setBackgroundImage(
						btnGeneral, aaoh.sora.App.control.TAB_IMG_ACT
					);

				} else {
					aaoh.kaze.Element.setBackgroundImage(
						btnGeneral,
						aaoh.sora.App.control.TAB_IMG_ACT_UP,
						aaoh.sora.App.control.TAB_IMG_ACT_OVER,
						aaoh.sora.App.control.TAB_IMG_ACT_DOWN
					);
				}
				aaoh.kaze.Element.setForeground(
					btnDetail, aaoh.sora.App.control.TAB_INACT
				);
				if (
					!aaoh.kaze.Type.isGoogle()
					&& !(aaoh.kaze.Type.isOthers() && aaoh.kaze.Type.isIE())
				) {
					aaoh.kaze.Element.setBackgroundImage(
						btnDetail, aaoh.sora.App.control.TAB_IMG_INACT
					);

				} else {
					aaoh.kaze.Element.setBackgroundImage(
						btnDetail,
						aaoh.sora.App.control.TAB_IMG_INACT_UP,
						aaoh.sora.App.control.TAB_IMG_INACT_OVER,
						aaoh.sora.App.control.TAB_IMG_INACT_DOWN
					);
				}
				aaoh.kaze.Element.setDisplay(optGeneral, true);
				aaoh.kaze.Element.setDisplay(optDetail,  false);
				if (!aaoh.kaze.Type.isIE()) {
					new aaoh.kaze.animation.FadeinAnimation(optGeneral).start();
				}
			});
			aaoh.kaze.Element.setOnClick(btnDetail, function() {
				var btnGeneral = aaoh.kaze.Gadget.$(
					aaoh.sora.App.control.BTN_GENERAL_NM
				);
				var btnDetail = aaoh.kaze.Gadget.$(
					aaoh.sora.App.control.BTN_DETAIL_NM
				);
				var optGeneral = aaoh.kaze.Gadget.$(
					aaoh.sora.App.control.OPT_GENERAL_NM
				);
				var optDetail = aaoh.kaze.Gadget.$(
					aaoh.sora.App.control.OPT_DETAIL_NM
				);
				if (
					btnGeneral == null || btnDetail == null
					|| optGeneral == null || optDetail == null
				) {
					return;
				}

				aaoh.kaze.Element.setForeground(
					btnGeneral, aaoh.sora.App.control.TAB_INACT
				);
				if (
					!aaoh.kaze.Type.isGoogle()
					&& !(aaoh.kaze.Type.isOthers() && aaoh.kaze.Type.isIE())
				) {
					aaoh.kaze.Element.setBackgroundImage(
						btnGeneral, aaoh.sora.App.control.TAB_IMG_INACT
					);

				} else {
					aaoh.kaze.Element.setBackgroundImage(
						btnGeneral,
						aaoh.sora.App.control.TAB_IMG_INACT_UP,
						aaoh.sora.App.control.TAB_IMG_INACT_OVER,
						aaoh.sora.App.control.TAB_IMG_INACT_DOWN
					);
				}
				aaoh.kaze.Element.setForeground(
					btnDetail, aaoh.sora.App.control.TAB_ACT
				);
				if (
					!aaoh.kaze.Type.isGoogle()
					&& !(aaoh.kaze.Type.isOthers() && aaoh.kaze.Type.isIE())
				) {
					aaoh.kaze.Element.setBackgroundImage(
						btnDetail, aaoh.sora.App.control.TAB_IMG_ACT
					);

				} else {
					aaoh.kaze.Element.setBackgroundImage(
						btnDetail,
						aaoh.sora.App.control.TAB_IMG_ACT_UP,
						aaoh.sora.App.control.TAB_IMG_ACT_OVER,
						aaoh.sora.App.control.TAB_IMG_ACT_DOWN
					);
				}
				aaoh.kaze.Element.setDisplay(optGeneral, false);
				aaoh.kaze.Element.setDisplay(optDetail,  true);
				if (!aaoh.kaze.Type.isIE()) {
					new aaoh.kaze.animation.FadeinAnimation(optDetail).start();
				}
			});
		} // if (btnGeneral != null && btnDetail != null)
	},

	/**
	 * 初期化の前処理。
	 */
	initBefore: function() {
		// 設定データの読込み
		aaoh.sora.App.model.readData(this.APP_NAME, this.APP_VERSION);

		// 言語の設定
		this.locale.setLocale(
			aaoh.sora.App.model.data.locale, function() {
				aaoh.sora.App.control.init();
			}
		);

		// Sidebar対応
		if (aaoh.kaze.Type.isSidebar()) {
			if (aaoh.sora.App.main != null) {
				System.Gadget.settingsUI = 'option.html';
			}
		} // if (aaoh.kaze.Type.isSidebar())

		// onDockの設定
		if (aaoh.sora.App.main != null) {
			if (aaoh.kaze.Type.isSidebar()) {
				this.flgOnDock = System.Gadget.docked;

			} else {
				this.flgOnDock = aaoh.sora.App.model.data.isOnDock;
			}
		}

		// 設定ボタン
		this.setOption();
		this.setOptionHeader();
	},

	/**
	 * 初期化。
	 */
	init: function() {
		this.initBefore();
		if (aaoh.sora.App.main != null) {
			aaoh.sora.App.main.initBefore();
		}
		if (aaoh.sora.App.option != null) {
			aaoh.sora.App.option.initBefore();
		}

		if (aaoh.sora.App.main != null) {
			aaoh.sora.App.main.init();
		}
		if (aaoh.sora.App.option != null) {
			aaoh.sora.App.option.init();
		}

		if (aaoh.sora.App.main != null) {
			aaoh.sora.App.main.initAfter();
		}
		if (aaoh.sora.App.option != null) {
			aaoh.sora.App.option.initAfter();
		}
		this.initAfter();
	},

	/**
	 * 初期化の後処理。
	 */
	initAfter: function() {
		// 画面表示
		aaoh.kaze.Gadget.setVisible(true);
	},

	/**
	 * 表示データの初期化。
	 */
	initMainData: function() {
		if (aaoh.sora.App.main == null) {
			return;
		}

		aaoh.sora.App.main.initDataBefore();
		aaoh.sora.App.main.initData();
		aaoh.sora.App.main.initDataAfter();
	},

	/**
	 * 表示データの初期化。
	 */
	initOptionData: function() {
		if (aaoh.sora.App.option == null) {
			return;
		}

		aaoh.sora.App.option.initDataBefore();
		aaoh.sora.App.option.initData();
		aaoh.sora.App.option.initDataAfter();
	}
}
})();

(function () {
/**
 * Model。
 *
 * @constructor
 */
aaoh.sora.Model = function() {
	// バージョンチェックフラグ
	this.FLG_VERSION_CHECK = true;

	// 設定データ
	this.data = {
		version:  "0.0.0.0",
		locale:   "ja",
		isOnDock: true,
		position: {
			numX:   100,
			numY:   100
		}
	}
}
aaoh.sora.Model.prototype = {
	/**
	 * 設定情報の読込み。
	 * 読込みバージョンと読込んだバージョンが異なる場合には
	 * 設定情報を更新しません。
	 *
	 * @param {String} key     読込みキー
	 * @param {String} version 読込みバージョン
	 */
	readData: function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}

		try {
			if (aaoh.kaze.Type.isIGoogle()) {
				var version_ = aaoh.sora.App.control.storage.readString('version');
				if (
					this.FLG_VERSION_CHECK
					&& version != null && version != version_
				) {
					this.writeData(key, version);
					return;
				}
				this.readDataBeforeForIGoogle(key, version);
				this.readDataForIGoogle(key, version);
				this.readDataAfterForIGoogle(key, version);

			} else if (aaoh.kaze.Type.isYahoo()) {
				var version_ = aaoh.sora.App.control.storage.readString('version');
				if (
					this.FLG_VERSION_CHECK
					&& version != null && version != version_
				) {
					this.writeData(key, version);
					return;
				}
				this.readDataBeforeForYahoo(key, version);
				this.readDataForYahoo(key, version);
				this.readDataAfterForYahoo(key, version);

			} else {
				var value = aaoh.sora.App.control.storage.readString(key);
				if (value != null && value != '') {
					data_ = aaoh.sora.App.control.json.parse(value);
					if (
						this.FLG_VERSION_CHECK
						&& version != null && version != data_.version
					) {
						return;
					}

					this.data = data_;
				}
			} // if (aaoh.kaze.Type.isIGoogle())
		} catch(ex) {
		}
	},

	/**
	 * 設定情報の書込み。
	 *
	 * @param {String} key     書込みキー
	 * @param {String} version 書込みバージョン
	 */
	writeData: function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}

		try {
			this.data.version = version;

			if (aaoh.kaze.Type.isIGoogle()) {
				this.writeDataBeforeForIGoogle(key, version);
				this.writeDataForIGoogle(key, version);
				this.writeDataAfterForIGoogle(key, version);

			} else if (aaoh.kaze.Type.isYahoo()) {
				this.writeDataBeforeForYahoo(key, version);
				this.writeDataForYahoo(key, version);
				this.writeDataAfterForYahoo(key, version);

			} else {
				var value = aaoh.sora.App.control.json.stringify(this.data);
				aaoh.sora.App.control.storage.writeString(key, value);
			}
		} catch(ex) {
		}
	},

	/**
	 * 設定情報の読込みの前処理(iGoogle)。
	 *
	 * @param {String} key     読込みキー
	 * @param {String} version 読込みバージョン
	 */
	readDataBeforeForIGoogle: function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}
		var version_     = aaoh.sora.App.control.storage.readString('version');
		var locale       = aaoh.sora.App.control.storage.readString('locale');
		var isOnDock     = aaoh.sora.App.control.storage.readString('isOnDock');
		var numXPosition = aaoh.sora.App.control.storage.readString('numX_position');
		var numYPosition = aaoh.sora.App.control.storage.readString('numY_position');

		if (version != null) {
			this.data.version = version_;
		}
		if (locale != null) {
			this.data.locale = locale;
		}
		this.data.isOnDock = isOnDock;
		if (numXPosition > 0) {
			this.data.position.numX = numXPosition;
		}
		if (numYPosition > 0) {
			this.data.position.numY = numYPosition;
		}
	},

	/**
	 * 設定情報の読込み(iGoogle)。
	 *
	 * @param {String} key     読込みキー
	 * @param {String} version 読込みバージョン
	 */
	readDataForIGoogle: function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}
	},

	/**
	 * 設定情報の読込みの後処理(iGoogle)。
	 *
	 * @param {String} key     読込みキー
	 * @param {String} version 読込みバージョン
	 */
	readDataAfterForIGoogle: function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}
	},

	/**
	 * 設定情報の書込みの前処理(iGoogle)。
	 *
	 * @param {String} key     書込みキー
	 * @param {String} version 書込みバージョン
	 */
	writeDataBeforeForIGoogle: function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}
		this.data.version = version;

		aaoh.sora.App.control.storage.writeString(
			'version', this.data.version
		);
		aaoh.sora.App.control.storage.writeString(
			'locale', this.data.locale
		);
		aaoh.sora.App.control.storage.writeString(
			'isOnDock', this.data.isOnDock
		);
		aaoh.sora.App.control.storage.writeString(
			'numX_position', this.data.position.numX
		);
		aaoh.sora.App.control.storage.writeString(
			'numY_position', this.data.position.numY
		);
	},

	/**
	 * 設定情報の書込み(iGoogle)。
	 *
	 * @param {String} key     書込みキー
	 * @param {String} version 書込みバージョン
	 */
	writeDataForIGoogle: function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}
	},

	/**
	 * 設定情報の書込みの後処理(iGoogle)。
	 *
	 * @param {String} key     書込みキー
	 * @param {String} version 書込みバージョン
	 */
	writeDataAfterForIGoogle: function(key, version) {
		if (key == null) {
			throw new Error('key is null, version is ' + version);
		}
	},

	/**
	 * 設定情報の読込みの前処理(Yahoo)。
	 *
	 * @param {String} key     読込みキー
	 * @param {String} version 読込みバージョン
	 */
	readDataBeforeForYahoo: function(key, version) {
		this.readDataBeforeForIGoogle(key, version);
	},

	/**
	 * 設定情報の読込み(Yahoo)。
	 *
	 * @param {String} key     読込みキー
	 * @param {String} version 読込みバージョン
	 */
	readDataForYahoo: function(key, version) {
		this.readDataForIGoogle(key, version);
	},

	/**
	 * 設定情報の読込みの後処理(Yahoo)。
	 *
	 * @param {String} key     読込みキー
	 * @param {String} version 読込みバージョン
	 */
	readDataAfterForYahoo: function(key, version) {
		this.readDataAfterForIGoogle(key, version);
	},

	/**
	 * 設定情報の書込みの前処理(Yahoo)。
	 *
	 * @param {String} key     書込みキー
	 * @param {String} version 書込みバージョン
	 */
	writeDataBeforeForYahoo: function(key, version) {
		this.writeDataBeforeForIGoogle(key, version);
	},

	/**
	 * 設定情報の書込み(Yahoo)。
	 *
	 * @param key     書込みキー
	 * @param version 書込みバージョン
	 */
	writeDataForYahoo: function(key, version) {
		this.writeDataForIGoogle(key, version);
	},

	/**
	 * 設定情報の書込みの後処理(Yahoo)。
	 *
	 * @param {String} key     書込みキー
	 * @param {String} version 書込みバージョン
	 */
	writeDataAfterForYahoo: function(key, version) {
		this.writeDataAfterForIGoogle(key, version);
	}
}
})();

(function () {
/**
 * Main。
 *
 * @constructor
 */
aaoh.sora.Main = function() {
}
aaoh.sora.Main.prototype = {
	/**
	 * トップオブジェクトの取得。
	 *
	 * @return {Object} トップオブジェクト
	 */
	getTopObject: function() {
		var topObj = null;

		if (aaoh.kaze.Type.isGoogle()) {
			topObj = view;

		} else if (aaoh.kaze.Type.isYahoo()) {
			topObj = aaoh.kaze.Gadget.$(aaoh.sora.App.control.YAHOO_TOP_NM);

		} else {
			topObj = aaoh.kaze.Gadget.$(aaoh.sora.App.control.MAIN_NM);
		}

		return topObj;
	},

	/**
	 * 表示データの初期化の前処理。
	 */
	initDataBefore: function() {
		var btnMax    = aaoh.kaze.Gadget.$(aaoh.sora.App.control.BTN_MAX_NM);
		var btnOption = aaoh.kaze.Gadget.$(aaoh.sora.App.control.BTN_OPTION_NM);
		var btnClose  = aaoh.kaze.Gadget.$(aaoh.sora.App.control.BTN_CLOSE_NM);

		var tipMax = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.TIP_MAX, true
		);
		var tipOption = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.TIP_OPTION, true
		);
		var tipClose = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.TIP_CLOSE, true
		);

		if (btnMax != null && tipMax != null) {
			aaoh.kaze.Element.setTooltip(btnMax, tipMax);
		}
		if (btnOption != null && tipOption != null) {
			aaoh.kaze.Element.setTooltip(btnOption, tipOption);
		}
		if (btnClose != null && tipClose != null) {
			aaoh.kaze.Element.setTooltip(btnClose, tipClose);
		}
	},

	/**
	 * 表示データの初期化。
	 */
	initData: function() {
	},

	/**
	 * 表示データの初期化の後処理。
	 */
	initDataAfter: function() {
	},

	/**
	 * 初期化の前処理。
	 */
	initBefore: function() {
		if (aaoh.sora.App.control == null) {
			return;
		}

		// 古いOpera対応
		if (!aaoh.sora.App.control.json.flgEnable) {
			var btnOption = aaoh.kaze.Gadget.$(
				aaoh.sora.App.control.BTN_OPTION_NM
			);
			if (btnOption != null) {
				aaoh.kaze.Element.setDisplay(btnOption, false);
				aaoh.kaze.Element.setEnabled(btnOption, false);
			}
		} // if (aaoh.sora.App.model != null ...)

		// AIR対応
		if (aaoh.kaze.Type.isAIR()) {
			var mainObj = aaoh.kaze.Gadget.$(
				aaoh.sora.App.control.MAIN_NM
			);
			if (mainObj != null) {
				/** @private */
				mainObj.onmousedown = function(e) {
					if (
						e == null || e.target == null
						|| e.target.tagName.toUpperCase() == 'INPUT'
						|| e.target.tagName.toUpperCase() == 'BUTTON'
						|| e.target.tagName.toUpperCase() == 'SELECT'
					) {
						return;
					}

					window.nativeWindow.startMove();
				}
			}

			aaoh.kaze.Gadget.setPosition(
				aaoh.sora.App.model.data.position.numX,
				aaoh.sora.App.model.data.position.numY
			);
		} // if (aaoh.kaze.Type.isAIR())

		// SBM対応
		if (aaoh.kaze.Type.isSBM()) {
			var toolbar = aaoh.kaze.Gadget.$(
				aaoh.sora.App.control.TOOLBAR_NM
			);
			if (toolbar != null) {
				aaoh.kaze.Element.setDisplay(toolbar, false);
			}
			return;
		} // if (aaoh.kaze.Type.isSBM())

		// 最大化ボタン
		var btnMax = aaoh.kaze.Gadget.$(
			aaoh.sora.App.control.BTN_MAX_NM
		);
		if (btnMax != null) {
			if (
				aaoh.kaze.Type.isSidebar()
				|| aaoh.kaze.Type.isIGoogle() || aaoh.kaze.Type.isGoogle()
				|| aaoh.kaze.Type.isMobile()
			) {
				aaoh.kaze.Element.setDisplay(btnMax, false);

			} else {
				aaoh.kaze.Element.setOnClick(btnMax, function() {
					aaoh.sora.App.control.flgOnDock
						= !aaoh.sora.App.control.flgOnDock;
					aaoh.sora.App.control.showMain(
						aaoh.sora.App.control.flgOnDock, true
					);
				});
			}
		} // if (btnMax != null)

		// 設定ボタン
		var btnOption = aaoh.kaze.Gadget.$(
			aaoh.sora.App.control.BTN_OPTION_NM
		);
		if (btnOption != null) {
			if (
				aaoh.kaze.Type.isSidebar()
				|| aaoh.kaze.Type.isIGoogle() || aaoh.kaze.Type.isGoogle()
			) {
				aaoh.kaze.Element.setDisplay(btnOption, false);

			} else if (aaoh.kaze.Type.isYahoo()) {
				aaoh.kaze.Element.setOnClick(btnOption, function() {
					if (aaoh.sora.App.option != null) {
						aaoh.sora.App.option.initDataBeforeForYahoo();
						aaoh.sora.App.option.initDataForYahoo();
						aaoh.sora.App.option.initDataAfterForYahoo();
					}

					showWidgetPreferences();
				});

			} else {
				aaoh.kaze.Element.setOnClick(btnOption, function() {
					aaoh.sora.App.control.showOption();
				});
			}
		} // if (btnOption != null)

		// 閉じるボタン
		var btnClose = aaoh.kaze.Gadget.$(
			aaoh.sora.App.control.BTN_CLOSE_NM
		);
		if (btnClose != null) {
			if (
				aaoh.kaze.Type.isSidebar()
				|| aaoh.kaze.Type.isOpera() || aaoh.kaze.Type.isDashboard()
				|| aaoh.kaze.Type.isIGoogle() || aaoh.kaze.Type.isGoogle()
			) {
				aaoh.kaze.Element.setDisplay(btnClose, false);

			} else {
				aaoh.kaze.Element.setOnClick(btnClose, function() {
					aaoh.kaze.Gadget.close();
				});
			}
		} // if (btnClose != null)

		// onDock
		aaoh.kaze.Gadget.setOnDock(function() {
			aaoh.sora.App.control.flgOnDock = true;
			aaoh.sora.App.control.showMain(
				aaoh.sora.App.control.flgOnDock, true
			);
		});
		aaoh.kaze.Gadget.setOnUnDock(function() {
			aaoh.sora.App.control.flgOnDock = false;
			aaoh.sora.App.control.showMain(
				aaoh.sora.App.control.flgOnDock, true
			);
		});

		// onUnload
		if (aaoh.sora.App.main != null) {
			aaoh.kaze.Gadget.setUnLoad(function() {
				if (aaoh.kaze.Type.isIGoogle()) {
					return;
				}

				aaoh.sora.App.model.data.isOnDock = aaoh.sora.App.control.flgOnDock;

				if (aaoh.kaze.Type.isAIR()) {
					var position = aaoh.kaze.Gadget.getPosition();

					if (position != null) {
						aaoh.sora.App.model.data.position.numX = position.x;
						aaoh.sora.App.model.data.position.numY = position.y;
					}
				}

				aaoh.sora.App.model.writeData(
					aaoh.sora.App.control.APP_NAME,
					aaoh.sora.App.control.APP_VERSION
				);
			});
		} // if (aaoh.sora.App.main != null)
	},

	/**
	 * 初期化処理。
	 */
	init: function() {
	},

	/**
	 * 初期化の後処理。
	 */
	initAfter: function() {
		if (aaoh.sora.App.control == null) {
			return;
		}

		aaoh.sora.App.control.showMain(
			aaoh.sora.App.control.flgOnDock, true
		);
	}
}
})();

(function () {
/**
 * Option。
 *
 * @constructor
 */
aaoh.sora.Option = function() {
}
aaoh.sora.Option.prototype = {
	/**
	 * 設定データの設定。
	 */
	doOption: function() {
	},

	/**
	 * 表示データの初期化の前処理。
	 */
	initDataBefore: function() {
		var btnGeneral = aaoh.kaze.Gadget.$(aaoh.sora.App.control.BTN_GENERAL_NM);
		var btnDetail  = aaoh.kaze.Gadget.$(aaoh.sora.App.control.BTN_DETAIL_NM);
		var btnOK      = aaoh.kaze.Gadget.$(aaoh.sora.App.control.BTN_OK_NM);
		var btnCancel  = aaoh.kaze.Gadget.$(aaoh.sora.App.control.BTN_CANCEL_NM);

		var ttlGeneral = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.TTL_GENERAL, true
		);
		var ttlDetail = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.TTL_DETAIL, true
		);
		var ttlOK = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.TTL_OK, true
		);
		var ttlCancel = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.TTL_CANCEL, true
		);

		if (btnGeneral != null && ttlGeneral != null) {
			aaoh.kaze.Element.setValue(btnGeneral, ttlGeneral);
		}
		if (btnDetail != null && ttlDetail != null) {
			aaoh.kaze.Element.setValue(btnDetail, ttlDetail);
		}
		if (btnOK != null && ttlOK != null) {
			aaoh.kaze.Element.setValue(btnOK, ttlOK);
		}
		if (btnCancel != null && ttlCancel != null) {
			aaoh.kaze.Element.setValue(btnCancel, ttlCancel);
		}
	},

	/**
	 * 表示データの初期化。
	 */
	initData: function() {
	},

	/**
	 * 表示データの初期化の後処理。
	 */
	initDataAfter: function() {
	},

	/**
	 * 表示データの初期化の前処理(Yahoo)。
	 */
	initDataBeforeForYahoo: function() {
		var ttlIndex = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.YWIDGET_NAME, true
		);
		var ttlGeneral = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.TTL_GENERAL, true
		);
		var ttlDetail = aaoh.sora.App.control.locale.getLocalizedString(
			aaoh.sora.App.control.TTL_DETAIL, true
		);
		//var ttlOK = aaoh.sora.App.control.locale.getLocalizedString(
		//	aaoh.sora.App.control.TTL_OK, true
		//);
		//var ttlCancel = aaoh.sora.App.control.locale.getLocalizedString(
		//	aaoh.sora.App.control.TTL_CANCEL, true
		//);

		var indexObj = aaoh.kaze.Gadget.$(aaoh.sora.App.control.YAHOO_TOP_NM);
		if (indexObj != null) {
			indexObj.title = ttlIndex;
		}
		if (!!preferenceGroups.general) {
			preferenceGroups.general.title = ttlGeneral;
		}
		if (!!preferenceGroups.detail) {
			preferenceGroups.detail.title = ttlDetail;
		}
	},

	/**
	 * 表示データの初期化(Yahoo)。
	 */
	initDataForYahoo: function() {
	},

	/**
	 * 表示データの初期化の後処理(Yahoo)。
	 */
	initDataAfterForYahoo: function() {
	},

	/**
	 * 初期化の前処理。
	 */
	initBefore: function() {
		if (aaoh.sora.App.control == null) {
			return;
		}

		// OKボタン
		var optSetting = aaoh.kaze.Gadget.$(
			aaoh.sora.App.control.OPT_SETTING_NM
		);
		if (optSetting != null) {
			if (aaoh.kaze.Type.isSidebar()) {
				aaoh.kaze.Element.setVisible(optSetting, false);
			}
		} // if (optSetting != null)

		// Localeボタン
		var selLocale = aaoh.kaze.Gadget.$(
			aaoh.sora.App.control.SEL_LOCALE_NM
		);
		if (selLocale != null) {
			if (aaoh.kaze.Type.isOpera() || aaoh.kaze.Type.isOthers()) {
				aaoh.kaze.Element.setDisplay(selLocale, true);

			} else {
				aaoh.kaze.Element.setDisplay(selLocale, false);
			}
		} // if (selLocale != null)

	},

	/**
	 * 初期化処理。
	 */
	init: function() {
	},

	/**
	 * 初期化の後処理。
	 */
	initAfter: function() {
		if (aaoh.sora.App.control == null) {
			return;
		}

		// Sidebar, Google用
		if (aaoh.sora.App.main == null) {
			// 毎回optionが生成されるので
			aaoh.sora.App.control.showOption();
		}

		// Yahoo用
		if (aaoh.kaze.Type.isYahoo()) {
			this.initDataBeforeForYahoo();
			this.initDataForYahoo();
			this.initDataAfterForYahoo();
		}
	}
}
})();

(function () {
/**
 * App。
 *
 * @namespace
 */
aaoh.sora.App = {
	/**
	 * コントローラー。
	 */
	control: new aaoh.sora.Control(),

	/**
	 * モデル。
	 */
	model: new aaoh.sora.Model(),

	/**
	 * メイン処理オブジェクト。
	 */
	main: null,

	/**
	 * オプション処理オブジェクト。
	 */
	option: null,

	/**
	 * 初期化。
	 *
	 * @param {String} target 初期化するターゲット
	 */
	init: function(target) {
		//if (
		//	target != null && target == aaoh.sora.App.control.MAIN_NM
		//) {
		//	aaoh.sora.App.main   = new aaoh.sora.Main();
		//	aaoh.sora.App.option = null;
		//} else if (
		//	target != null && target == aaoh.sora.App.control.OPTION_NM
		//) {
		//	aaoh.sora.App.main   = null;
		//	aaoh.sora.App.option = new aaoh.sora.Option();
		//} else {
		//	aaoh.sora.App.main   = new aaoh.sora.Main();
		//	aaoh.sora.App.option = new aaoh.sora.Option();
		//}
		//aaoh.sora.App.control.init();
	}
}
})();
