#include "../common.h"
#include "../calc.h"
#include "../vari.h"
#include "../variant.h"
#include "../variant_io.h"
#include "../st_inst.h"

extern std::map<std::string,std::string> variable_table;//̃}bv
extern std::vector<std::string> source; //basic̃vOi[z
extern int basic_init(char*filename);
extern void basic_start(int);
extern void basic_end();

void WINAPI start();
int WINAPI gosub(char*label);
int WINAPI _gosub(char*label);
void WINAPI setVari(char*name,char*val);
char* WINAPI getVari(char*name);

HANDLE     hIOMutex = CreateMutex (NULL, FALSE, NULL);//Xbh΍
std::map<std::string,unsigned int> goto_table;//goto邽߂̔z
static char str_pos[MAX_STR_LEN+1];

//C^v^̎s
void WINAPI start(){
	WaitForSingleObject( hIOMutex, INFINITE );
	basic_start(0);
	ReleaseMutex( hIOMutex);
}

//Tu[`̎s ֐ gosub ł邪Agotos
int WINAPI gosub(char*label){
	return _gosub(label);
}
int WINAPI _gosub(char*label){
	WaitForSingleObject( hIOMutex, INFINITE );
	int resolt=0;
	if(goto_table.count(label)){
			basic_start(goto_table[label]);
			resolt=1;//goto
	}else{
		std::vector<unsigned long> dumy; //gotoĂяo߂̃_~[z
		dumy.push_back(0);
		unsigned int p_cont=1;
		_strcpy(str_pos,"goto ");
		strcat(str_pos,label);
		if(goto_(str_pos,&source,&p_cont,&dumy)){
			goto_table[label]=p_cont;
			basic_start(p_cont);
			resolt=1;//goto
		}
	}
	ReleaseMutex( hIOMutex);
	return resolt;
}

//ϐɒlݒ肷
void WINAPI setVari(char*name,char*val){
	WaitForSingleObject( hIOMutex, INFINITE );
	//Sĕ^Ƃ
	char*str_ptr=str_pos+1;
	_strcpy(str_ptr,val);
	str_ptr--;
	*str_ptr='\"';
	variable_table[name]=str_ptr;
	ReleaseMutex( hIOMutex);
}

//ϐ̒l擾
char* WINAPI getVari(char*name){
	WaitForSingleObject( hIOMutex, INFINITE );
	char*resolt;
	_strcpy(str_pos,variable_table[name].c_str());
	if('\"'==*str_pos){
		resolt=str_pos+1;
	}else {
		resolt=str_pos;
	}
	ReleaseMutex( hIOMutex);
	return resolt;
}

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
	basic_init("basic.txt");
    return TRUE;
}

//-------------------------------------------------------------------------------
