/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTException;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JFrame;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PSurface;
import processing.data.Table;
import processing.data.TableRow;
import processing.event.MouseEvent;
import processing.sound.SoundFile;

public class AbilityTimer
extends PApplet {
    final String AppName = "AbilityTimer";
    final String AppVersion = "0.67";
    final String SaveFileName = "save.csv";
    final String ChimeFileName = "chime.mp3";
    ArrayList<GuiItem> timerModeItems = new ArrayList();
    ArrayList<GuiItem> checklistModeItems = new ArrayList();
    ArrayList<Mission> missions = new ArrayList();
    Scouter scouter;
    long prevEpochSecond = 0L;
    int toggle = 0;
    int prevMouseX = 0;
    int prevMouseY = 0;
    static final short[][] OcrNumberTable = new short[][]{{60, 118, 99, 67, 67, 67, 67, 99, 102, 62}, {8, 60, 60, 12, 12, 12, 12, 12, 12, 62}, {62, 102, 3, 3, 2, 6, 12, 24, 56, 127}, {126, 102, 3, 2, 14, 30, 3, 3, 71, 126}, {6, 14, 30, 38, 38, 70, 127, 127, 6, 6}, {63, 112, 96, 96, 126, 7, 3, 3, 71, 126}, {30, 56, 32, 116, 127, 99, 99, 99, 115, 62}, {127, 3, 3, 6, 6, 12, 12, 24, 24, 48}, {62, 119, 67, 98, 62, 62, 67, 67, 99, 126}, {60, 118, 99, 67, 99, 127, 63, 2, 6, 60}, new short[10]};
    static final short[][] OcrNumber2Table;
    static final short[][] OcrNumber3Table;
    static final short[][] OcrVTable;
    int next_y = 5;
    final float[] dmmGemTimeTable = new float[]{12.0f, 20.0f, -1.0f, 12.5f, 21.0f, -1.0f, -1.0f, 18.0f, 21.0f, -1.0f, 19.0f, 22.0f, -1.0f, 20.0f, 23.0f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};
    final float[] nutakuGemTimeTable = new float[]{12.0f, 19.0f, -1.0f, 12.5f, 19.5f, -1.0f, -1.0f, 18.0f, 22.5f, -1.0f, 19.0f, 23.0f, -1.0f, 19.5f, 23.5f, 12.0f, 18.0f, 22.0f, 12.5f, 19.0f, 23.0f};

    static {
        short[][] sArrayArray = new short[11][];
        sArrayArray[0] = new short[]{112, 508, 990, 910, 902, 775, 775, 775, 775, 775, 902, 910, 1022, 508};
        short[] sArray = new short[14];
        sArray[1] = 56;
        sArray[2] = 248;
        sArray[3] = 504;
        sArray[4] = 504;
        sArray[5] = 56;
        sArray[6] = 56;
        sArray[7] = 56;
        sArray[8] = 56;
        sArray[9] = 56;
        sArray[10] = 56;
        sArray[11] = 56;
        sArray[12] = 120;
        sArray[13] = 510;
        sArrayArray[1] = sArray;
        sArrayArray[2] = new short[]{248, 510, 414, 14, 14, 14, 14, 28, 60, 120, 224, 480, 1023, 1023};
        sArrayArray[3] = new short[]{248, 1022, 926, 14, 14, 14, 124, 124, 14, 6, 7, 526, 958, 1020};
        short[] sArray2 = new short[14];
        sArray2[1] = 60;
        sArray2[2] = 60;
        sArray2[3] = 124;
        sArray2[4] = 204;
        sArray2[5] = 140;
        sArray2[6] = 396;
        sArray2[7] = 780;
        sArray2[8] = 926;
        sArray2[9] = 1023;
        sArray2[10] = 1023;
        sArray2[11] = 12;
        sArray2[12] = 12;
        sArray2[13] = 12;
        sArrayArray[4] = sArray2;
        short[] sArray3 = new short[14];
        sArray3[1] = 510;
        sArray3[2] = 510;
        sArray3[3] = 384;
        sArray3[4] = 384;
        sArray3[5] = 448;
        sArray3[6] = 510;
        sArray3[7] = 510;
        sArray3[8] = 15;
        sArray3[9] = 7;
        sArray3[10] = 7;
        sArray3[11] = 526;
        sArray3[12] = 958;
        sArray3[13] = 1020;
        sArrayArray[5] = sArray3;
        sArrayArray[6] = new short[]{60, 254, 480, 960, 896, 896, 1022, 910, 903, 903, 903, 903, 974, 508};
        short[] sArray4 = new short[14];
        sArray4[1] = 1023;
        sArray4[2] = 1023;
        sArray4[3] = 14;
        sArray4[4] = 14;
        sArray4[5] = 28;
        sArray4[6] = 28;
        sArray4[7] = 56;
        sArray4[8] = 56;
        sArray4[9] = 112;
        sArray4[10] = 240;
        sArray4[11] = 224;
        sArray4[12] = 224;
        sArray4[13] = 448;
        sArrayArray[7] = sArray4;
        sArrayArray[8] = new short[]{120, 510, 911, 903, 903, 966, 508, 254, 927, 775, 775, 903, 975, 510};
        sArrayArray[9] = new short[]{240, 508, 926, 782, 774, 775, 903, 991, 510, 14, 14, 28, 892, 1016};
        sArrayArray[10] = new short[14];
        OcrNumber2Table = sArrayArray;
        OcrNumber3Table = new short[][]{{124, 198, 199, 199, 199, 199, 199, 198, 126, 56}, {24, 120, 120, 24, 24, 24, 24, 24, 60, 126}, {252, 142, 6, 6, 12, 28, 48, 112, 255, 255}, {254, 142, 6, 12, 60, 6, 6, 6, 254, 120}, {12, 28, 60, 100, 196, 142, 255, 14, 4, 4}, {254, 224, 224, 224, 254, 7, 7, 135, 254, 120}, {62, 96, 192, 220, 238, 199, 199, 231, 126, 60}, {255, 7, 6, 14, 12, 28, 24, 48, 112, 96}, {126, 198, 198, 228, 124, 206, 199, 199, 254, 56}, {124, 198, 199, 199, 231, 127, 6, 6, 124, 112}, new short[10]};
        short[][] sArrayArray2 = new short[2][];
        short[] sArray5 = new short[8];
        sArray5[1] = 34;
        sArray5[2] = 34;
        sArray5[3] = 54;
        sArray5[4] = 20;
        sArray5[5] = 28;
        sArray5[6] = 28;
        sArrayArray2[0] = sArray5;
        sArrayArray2[1] = new short[8];
        OcrVTable = sArrayArray2;
    }

    public void settings() {
        this.size(240, 320);
    }

    public void setup() {
        this.surface.setAlwaysOnTop(true);
        PSurfaceAWT.SmoothCanvas smoothCanvas = (PSurfaceAWT.SmoothCanvas)this.surface.getNative();
        JFrame jframe = (JFrame)smoothCanvas.getFrame();
        jframe.dispose();
        jframe.setUndecorated(true);
        jframe.setVisible(true);
        this.surface.setResizable(true);
        this.smooth();
        TimerDisplay tmdisp = new TimerDisplay(20, 5);
        this.timerModeItems.add(tmdisp);
        CloseButton cbutton_t = new CloseButton(110, 0);
        this.timerModeItems.add(cbutton_t);
        MinimizeButton mbutton_t = new MinimizeButton(90, 0);
        this.timerModeItems.add(mbutton_t);
        TimerBar tmbar = new TimerBar(5, 5, tmdisp);
        this.checklistModeItems.add(tmbar);
        PFont font12 = this.loadFont("mplus-2p-bold-12.vlw");
        PFont font24 = this.loadFont("mplus-2m-bold-24.vlw");
        Glbl.setInstances(this.surface, jframe, font12, font24, new SoundFile((PApplet)this, "chime.mp3"));
        Table chkTbl = this.loadTable("save.csv", "header");
        Table itemTbl = this.loadTable("Items.csv", "header");
        ZoneId zoneid = ZoneId.of("America/Los_Angeles");
        int i = 0;
        for (TableRow itemRow : itemTbl.rows()) {
            String name;
            String kind = itemRow.getString("kind");
            if (kind.equals("mission")) {
                TableRow chkRow;
                name = itemRow.getString("name");
                int items = itemRow.getInt("value");
                int value = 0;
                if (chkTbl != null && i < chkTbl.getRowCount() && (chkRow = chkTbl.getRow(i)) != null) {
                    value = chkRow.getInt("value");
                    ++i;
                }
                Mission m = new Mission(name, items, value);
                this.checklistModeItems.add(m);
                this.missions.add(m);
                continue;
            }
            if (!kind.equals("service") || !(name = itemRow.getString("name")).equals("DMM")) continue;
            zoneid = ZoneId.of("Asia/Tokyo");
        }
        WallClock wallc = new WallClock(zoneid);
        this.checklistModeItems.add(wallc);
        this.checklistModeItems.add(new TimerBarLabel(tmbar));
        CloseButton closeb = new CloseButton(220, 0);
        this.checklistModeItems.add(closeb);
        MinimizeButton minib = new MinimizeButton(200, 0);
        this.checklistModeItems.add(minib);
        this.scouter = new Scouter("AbilityTimer", "0.67");
        DrawerButton drawerb = new DrawerButton(220, 127, this.scouter);
        this.checklistModeItems.add(drawerb);
    }

    public void draw() {
        block20: {
            boolean changed;
            block19: {
                Glbl.setBgSelected(true);
                changed = Glbl.prevMode != Glbl.mode;
                Glbl.prevMode = Glbl.mode;
                if (!Glbl.isTimerMode()) break block19;
                this.background(224);
                if (changed) {
                    Glbl.changeSize();
                }
                for (GuiItem item : this.timerModeItems) {
                    item.render();
                }
                break block20;
            }
            boolean mustRedraw = false;
            long currentEpochSecond = Instant.now().getEpochSecond();
            if (Glbl.scouterEnabled) {
                boolean passage0p5sec = false;
                int mil = this.millis() % 1000;
                if (this.toggle == 0) {
                    if (mil >= 0 && mil <= 499) {
                        this.toggle = 1;
                        passage0p5sec = true;
                    }
                } else if (500 <= mil && mil <= 999) {
                    this.toggle = 0;
                    passage0p5sec = true;
                }
                if (passage0p5sec) {
                    this.scouter.findKamihimeWindow();
                    mustRedraw = true;
                }
            }
            if (Glbl.mustRedraw || mustRedraw) {
                Glbl.mustRedraw = false;
                mustRedraw = true;
            } else if (this.mousePressed) {
                mustRedraw = true;
            } else if (this.pmouseX != this.mouseX || this.pmouseY != this.mouseY) {
                mustRedraw = true;
            } else if (Glbl.isLastOneMinute && currentEpochSecond != this.prevEpochSecond) {
                mustRedraw = true;
            } else if (currentEpochSecond / 60L != this.prevEpochSecond / 60L) {
                mustRedraw = true;
            }
            this.prevEpochSecond = currentEpochSecond;
            if (changed) {
                Glbl.changeSize();
                this.prevEpochSecond = 0L;
            }
            if (!mustRedraw) break block20;
            this.background(224);
            for (GuiItem item : this.checklistModeItems) {
                item.render();
            }
        }
    }

    public void mousePressed() {
        this.prevMouseX = this.mouseX;
        this.prevMouseY = this.mouseY;
        if (Glbl.isTimerMode()) {
            for (GuiItem item : this.timerModeItems) {
                item.press();
            }
        } else {
            for (GuiItem item : this.checklistModeItems) {
                item.press();
            }
        }
    }

    public void mouseReleased() {
    }

    public void mouseDragged() {
        if (Glbl.isBgSelected()) {
            Point mouse = MouseInfo.getPointerInfo().getLocation();
            this.surface.setLocation(mouse.x - this.prevMouseX, mouse.y - this.prevMouseY - 0);
        }
    }

    public void mouseWheel(MouseEvent event) {
        Glbl.mustRedraw = true;
        if (Glbl.isTimerMode()) {
            for (GuiItem item : this.timerModeItems) {
                item.wheel(event);
            }
        } else {
            for (GuiItem item : this.checklistModeItems) {
                item.wheel(event);
            }
        }
    }

    public void exit() {
        Table tbl = new Table();
        tbl.addColumn("value");
        for (Mission m : this.missions) {
            TableRow row = tbl.addRow();
            row.setInt("value", m.getValue());
        }
        this.saveTable(tbl, "save.csv");
        super.exit();
    }

    public static int getR(int c) {
        return c >> 16 & 0xFF;
    }

    public static int getG(int c) {
        return c >> 8 & 0xFF;
    }

    public static int getB(int c) {
        return c & 0xFF;
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"AbilityTimer"};
        if (passedArgs != null) {
            PApplet.main((String[])AbilityTimer.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class AcceRow
    extends GuiItem {
        String name;
        Valuebox box;
        LabeledButton plusB;
        LabeledButton minusB;
        int x;
        int y;
        int scale;
        final int delta_y = 29;

        AcceRow(int _x, int _y, String _name, int _scale, int _items) {
            this.delta_y = 29;
            this.name = _name;
            this.x = _x;
            this.y = _y;
            this.scale = _scale;
            this.box = new Valuebox(this.x + 90, this.y, _items);
            this.plusB = new LabeledButton(this.x + 120, this.y, "+", this.box);
            this.minusB = new LabeledButton(this.x + 140, this.y, "-", this.box);
        }

        public boolean isCurrent() {
            return this.box.isOver() || this.plusB.isOver() || this.minusB.isOver();
        }

        @Override
        public void render() {
            this.box.render();
            this.plusB.render();
            this.minusB.render();
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            if (this.isCurrent()) {
                AbilityTimer.this.fill(128);
                AbilityTimer.this.text(this.name, this.x, this.y + 15);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, this.x - 1, this.y + 15 - 1);
            } else {
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, this.x, this.y + 15);
            }
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            int total = this.box.getValue() * this.scale;
            String str = AbilityTimer.nf((float)total);
            int i = str.length();
            while (i < 5) {
                str = " " + str;
                ++i;
            }
            AbilityTimer.this.text(str, this.x + 165, this.y + 16);
        }

        @Override
        public void press() {
            this.box.press();
            this.plusB.press();
            this.minusB.press();
        }

        @Override
        public void wheel(MouseEvent event) {
            if (this.isCurrent()) {
                float count = event.getCount();
                if (count < 0.0f) {
                    this.box.notify("+");
                } else if (count > 0.0f) {
                    this.box.notify("-");
                }
            }
        }

        public int getItems() {
            return this.box.getValue();
        }

        public int getScale() {
            return this.scale;
        }
    }

    class AcceTotal
    extends GuiItem {
        AcceRow[] ar;
        int x;
        int y;
        int requiredExp;

        AcceTotal(int _x, int _y, AcceRow[] _ar) {
            this.x = _x;
            this.y = _y;
            this.ar = _ar;
            this.requiredExp = 0;
        }

        @Override
        public void render() {
            AcceRow[] acceRowArray = this.ar;
            int n = this.ar.length;
            int n2 = 0;
            while (n2 < n) {
                AcceRow row = acceRowArray[n2];
                row.render();
                ++n2;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text("Total", this.x + 44, this.y + 16);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            int items = 0;
            int total = 0;
            AcceRow[] acceRowArray2 = this.ar;
            int n3 = this.ar.length;
            int n4 = 0;
            while (n4 < n3) {
                AcceRow row = acceRowArray2[n4];
                items += row.getItems();
                total += row.getItems() * row.getScale();
                ++n4;
            }
            String str = AbilityTimer.nf((float)items);
            int i = str.length();
            while (i < 2) {
                str = " " + str;
                ++i;
            }
            AbilityTimer.this.fill(0);
            if (items > 20) {
                AbilityTimer.this.fill(255.0f, 0.0f, 0.0f);
            }
            AbilityTimer.this.text(str, this.x + 96, this.y + 16);
            str = AbilityTimer.nf((float)total);
            i = str.length();
            while (i < 5) {
                str = " " + str;
                ++i;
            }
            AbilityTimer.this.fill(0);
            if (total >= this.requiredExp) {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
            }
            AbilityTimer.this.text(str, this.x + 165, this.y + 16);
        }

        @Override
        public void press() {
            AcceRow[] acceRowArray = this.ar;
            int n = this.ar.length;
            int n2 = 0;
            while (n2 < n) {
                AcceRow row = acceRowArray[n2];
                row.press();
                ++n2;
            }
        }

        @Override
        public void wheel(MouseEvent event) {
            AcceRow[] acceRowArray = this.ar;
            int n = this.ar.length;
            int n2 = 0;
            while (n2 < n) {
                AcceRow row = acceRowArray[n2];
                row.wheel(event);
                ++n2;
            }
        }

        public void setRequiredExp(int value) {
            this.requiredExp = value;
        }
    }

    class Checkbox
    extends GuiItem {
        boolean checked;
        static final int W = 20;
        static final int H = 20;

        Checkbox(int _x, int _y, boolean _checked) {
            super(_x, _y, 20, 20);
            this.checked = _checked;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 224 : 255);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            if (this.checked) {
                AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.line(this.x + 2, this.y + 10, this.x + 10, this.y + 15);
                AbilityTimer.this.line(this.x + 10, this.y + 15, this.x + 17, this.y + 3);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.checked = !this.checked;
            }
        }

        public boolean get() {
            return this.checked;
        }

        public void set() {
            this.checked = true;
        }

        public void reset() {
            this.checked = false;
        }
    }

    class CloseButton
    extends GuiItem {
        static final int W = 20;
        static final int H = 20;

        CloseButton(int _x, int _y) {
            super(_x, _y, 20, 20);
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 255 : 224);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x + 3, this.y + 3, this.x + 16, this.y + 16);
            AbilityTimer.this.line(this.x + 3, this.y + 16, this.x + 16, this.y + 3);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                AbilityTimer.this.exit();
            }
        }
    }

    class DrawerButton
    extends GuiItem {
        Scouter scouter;
        static final int W = 20;
        static final int H = 40;

        DrawerButton(int _x, int _y, Scouter _scouter) {
            super(_x, _y, 20, 40);
            this.scouter = _scouter;
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 64 : 0);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 39.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            if (Glbl.scouterEnabled) {
                AbilityTimer.this.line(this.x + 16, this.y + 3, this.x + 3, this.y + 19);
                AbilityTimer.this.line(this.x + 3, this.y + 20, this.x + 16, this.y + 36);
                this.scouter.render();
            } else {
                AbilityTimer.this.line(this.x + 3, this.y + 3, this.x + 16, this.y + 19);
                AbilityTimer.this.line(this.x + 16, this.y + 20, this.x + 3, this.y + 36);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                if (!Glbl.scouterEnabled) {
                    if (this.scouter.initialize()) {
                        Glbl.scouterEnabled = true;
                        Glbl.changeSize();
                    }
                } else {
                    Glbl.scouterEnabled = false;
                    Glbl.changeSize();
                }
            }
            if (Glbl.scouterEnabled) {
                this.scouter.press();
            }
        }

        @Override
        public void wheel(MouseEvent event) {
            if (Glbl.scouterEnabled) {
                this.scouter.wheel(event);
            }
        }
    }

    static class Glbl {
        static final int ChecklistMode = 0;
        static final int TimerMode = 1;
        static final int W = 240;
        static final int H = 320;
        static final int TimerW = 130;
        static final int TimerH = 100;
        static final int OcrNumberW = 8;
        static final int OcrNumberH = 10;
        static final int OcrNumber2W = 10;
        static final int OcrNumber2H = 14;
        static final int OcrNumber3W = 8;
        static final int OcrNumber3H = 10;
        static final int OcrVW = 8;
        static final int OcrVH = 8;
        static final int OcrEnhLv = 0;
        static final int OcrEnhNext = 1;
        static final int OcrInfoLv = 2;
        static final int OcrInfoNext = 3;
        static int mode = 0;
        static int prevMode = 1;
        static boolean isLastOneMinute = false;
        static boolean scouterEnabled = false;
        static boolean bgSelected = false;
        static boolean mustRedraw = false;
        static PSurface ps;
        static JFrame jf;
        static PFont font12;
        static PFont font24;
        static SoundFile chime;
        static boolean DebugOcr;
        static boolean DebugHp;

        static {
            DebugOcr = false;
            DebugHp = false;
        }

        Glbl() {
        }

        public static void setInstances(PSurface _ps, JFrame _jf, PFont _f12, PFont _f24, SoundFile _chime) {
            ps = _ps;
            jf = _jf;
            font12 = _f12;
            font24 = _f24;
            chime = _chime;
        }

        public static boolean isTimerMode() {
            return mode == 1;
        }

        public static void changeSize() {
            if (Glbl.isTimerMode()) {
                jf.setOpacity(0.5f);
                ps.setSize(130, 100);
            } else if (scouterEnabled) {
                jf.setOpacity(1.0f);
                ps.setSize(840, 320);
            } else {
                jf.setOpacity(0.75f);
                ps.setSize(240, 320);
            }
        }

        public static void setBgSelected(boolean value) {
            bgSelected = value;
        }

        public static boolean isBgSelected() {
            return bgSelected;
        }

        public static int countHotbits(int value, int width) {
            int result = 0;
            while (value > 0) {
                if ((value & 1) == 1) {
                    ++result;
                }
                value >>>= 1;
            }
            return result;
        }

        public static int ocrImage(PImage img, short[][] table, int tableW, int tableH, float BinarizationThreshold, int errorThreshold) {
            img.filter(16, BinarizationThreshold);
            short[] line = new short[tableH];
            int py = 0;
            while (py < tableH) {
                line[py] = 0;
                int px = 0;
                while (px < tableW) {
                    int c = img.pixels[tableW * py + px];
                    c = AbilityTimer.getG(c);
                    int n = py;
                    line[n] = (short)(line[n] << 1);
                    int n2 = py;
                    line[n2] = (short)(line[n2] | (c > 0 ? (short)1 : 0));
                    ++px;
                }
                if (DebugOcr) {
                    AbilityTimer.println((String)("y" + AbilityTimer.nf((int)py, (int)2) + ": " + AbilityTimer.hex((int)line[py], (int)3) + " : " + AbilityTimer.binary((int)line[py], (int)tableW)));
                }
                ++py;
            }
            if (DebugOcr) {
                AbilityTimer.print((String)"OCR diff ");
            }
            int minDiff = tableW * tableH;
            int minDiffNum = 0;
            int[] totalDiff = new int[table.length];
            int num = 0;
            while (num < table.length) {
                int[] diff = new int[2];
                int sft = 0;
                while (sft < diff.length) {
                    int i = 0;
                    while (i < tableH) {
                        int tmp = table[num][i] << sft ^ line[i];
                        if (tmp != 0) {
                            int bits = Glbl.countHotbits(tmp, tableW);
                            if (bits >= 3) {
                                bits *= 2;
                            }
                            int n = sft;
                            diff[n] = diff[n] + bits;
                        }
                        ++i;
                    }
                    ++sft;
                }
                int n = totalDiff[num] = diff[0] < diff[1] ? diff[0] : diff[1];
                if (totalDiff[num] < minDiff) {
                    minDiff = totalDiff[num];
                    minDiffNum = num;
                }
                if (DebugOcr) {
                    AbilityTimer.print((String)(String.valueOf(AbilityTimer.nf((float)num)) + ":" + AbilityTimer.nf((float)totalDiff[num]) + " "));
                }
                ++num;
            }
            if (DebugOcr) {
                AbilityTimer.println((String)"");
            }
            if (minDiff < errorThreshold) {
                if (DebugOcr) {
                    AbilityTimer.println((String)("OCR success " + AbilityTimer.nf((float)minDiffNum) + " diff:" + AbilityTimer.nf((float)totalDiff[minDiffNum])));
                }
                return minDiffNum;
            }
            if (DebugOcr) {
                AbilityTimer.println((String)"OCR fail:");
            }
            return -1;
        }

        public static int ocrNumber(PImage img, int kind) {
            int result = -1;
            if (kind == 0 || kind == 1) {
                result = Glbl.ocrImage(img, OcrNumberTable, 8, 10, 0.8f, 25);
            } else if (kind == 2) {
                result = Glbl.ocrImage(img, OcrNumber2Table, 10, 14, 0.8f, 15);
            } else if (kind == 3) {
                result = Glbl.ocrImage(img, OcrNumber3Table, 8, 10, 0.8f, 25);
            }
            return result;
        }

        public static boolean ocrV(PImage img) {
            int rc = Glbl.ocrImage(img, OcrVTable, 8, 8, 0.8f, 20);
            return rc == 0;
        }

        public static int calculateExpToMax(int maxLevel, int level, int nextExp) {
            short[] sArray = new short[50];
            sArray[1] = 10;
            sArray[2] = 15;
            sArray[3] = 20;
            sArray[4] = 25;
            sArray[5] = 30;
            sArray[6] = 35;
            sArray[7] = 40;
            sArray[8] = 45;
            sArray[9] = 50;
            sArray[10] = 55;
            sArray[11] = 60;
            sArray[12] = 65;
            sArray[13] = 70;
            sArray[14] = 75;
            sArray[15] = 80;
            sArray[16] = 85;
            sArray[17] = 90;
            sArray[18] = 95;
            sArray[19] = 100;
            sArray[20] = 120;
            sArray[21] = 140;
            sArray[22] = 160;
            sArray[23] = 180;
            sArray[24] = 200;
            sArray[25] = 220;
            sArray[26] = 240;
            sArray[27] = 260;
            sArray[28] = 280;
            sArray[29] = 300;
            sArray[30] = 320;
            sArray[31] = 340;
            sArray[32] = 360;
            sArray[33] = 380;
            sArray[34] = 400;
            sArray[35] = 420;
            sArray[36] = 440;
            sArray[37] = 460;
            sArray[38] = 480;
            sArray[39] = 500;
            sArray[40] = 520;
            sArray[41] = 540;
            sArray[42] = 560;
            sArray[43] = 580;
            sArray[44] = 600;
            sArray[45] = 620;
            sArray[46] = 640;
            sArray[47] = 660;
            sArray[48] = 680;
            sArray[49] = 700;
            short[] AccessoryExpTable = sArray;
            int result = 0;
            if (level != maxLevel) {
                int i = level + 1;
                while (i <= maxLevel - 1) {
                    result += AccessoryExpTable[i];
                    ++i;
                }
                result += nextExp;
            }
            return result;
        }

        public static int averageOfImage(PImage img) {
            int r = 0;
            int g = 0;
            int b = 0;
            int w = img.width;
            int h = img.height;
            int i = 0;
            while (i < w * h) {
                int c = img.pixels[i];
                r += AbilityTimer.getR(c);
                g += AbilityTimer.getG(c);
                b += AbilityTimer.getB(c);
                ++i;
            }
            return ((r /= w * h) << 16) + ((g /= w * h) << 8) + (b /= w * h);
        }
    }

    class GuiItem {
        int x;
        int y;
        int itemWidth;
        int itemHeight;

        GuiItem(int _x, int _y, int _itemWidth, int _itemHeight) {
            this.x = _x;
            this.y = _y;
            this.itemWidth = _itemWidth;
            this.itemHeight = _itemHeight;
        }

        GuiItem() {
            this(0, 0, 0, 0);
        }

        public void render() {
        }

        public void press() {
        }

        public void wheel(MouseEvent event) {
        }

        public boolean isOver() {
            int windowX = Glbl.jf.getX();
            int windowY = Glbl.jf.getY();
            int maxX = windowX + 240 + (Glbl.scouterEnabled ? 600 : 0);
            int maxY = windowY + 320;
            boolean rc = false;
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info != null) {
                Point mouse = info.getLocation();
                if (windowX <= mouse.x && mouse.x < maxX && windowY <= mouse.y && mouse.y < maxY) {
                    int mx = AbilityTimer.this.mouseX;
                    int my = AbilityTimer.this.mouseY;
                    boolean bl = rc = this.x <= mx && mx < this.x + this.itemWidth && this.y <= my && my < this.y + this.itemHeight;
                }
            }
            if (rc) {
                Glbl.setBgSelected(false);
            }
            return rc;
        }
    }

    class LabeledButton
    extends GuiItem {
        static final int W = 20;
        static final int H = 20;
        String label;
        Valuebox box;

        LabeledButton(int _x, int _y, String _label, Valuebox _box) {
            super(_x, _y, 20, 20);
            this.label = _label;
            this.box = _box;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(64);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 180 : 200);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(24.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(this.label, this.x + 4, this.y + 16);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.box.notify(this.label);
            }
        }
    }

    class MinimizeButton
    extends GuiItem {
        static final int W = 20;
        static final int H = 20;

        MinimizeButton(int _x, int _y) {
            super(_x, _y, 20, 20);
        }

        @Override
        public void render() {
            AbilityTimer.this.noStroke();
            AbilityTimer.this.fill(this.isOver() ? 255 : 224);
            AbilityTimer.this.rect(this.x, this.y, 19.0f, 19.0f);
            AbilityTimer.this.stroke(this.isOver() ? 0 : 64);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x + 3, this.y + 12, this.x + 16, this.y + 12);
        }

        @Override
        public void press() {
            if (this.isOver()) {
                Glbl.jf.setExtendedState(Glbl.jf.getExtendedState() | 1);
            }
        }
    }

    class Mission
    extends GuiItem {
        String name;
        Checkbox[] boxes;
        int y;
        final int delta_y = 29;

        Mission(String _name, int _items, int _value) {
            this.name = _name;
            this.boxes = new Checkbox[_items];
            this.y = AbilityTimer.this.next_y;
            AbilityTimer.this.next_y += 29;
            int i = 0;
            while (i < this.boxes.length) {
                this.boxes[i] = new Checkbox(115 + 25 * i, this.y, i < _value);
                ++i;
            }
        }

        @Override
        public void render() {
            boolean isCurrent = false;
            Checkbox[] checkboxArray = this.boxes;
            int n = this.boxes.length;
            int n2 = 0;
            while (n2 < n) {
                Checkbox box = checkboxArray[n2];
                box.render();
                isCurrent = isCurrent ? true : box.isOver();
                ++n2;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            if (isCurrent) {
                AbilityTimer.this.fill(128);
                AbilityTimer.this.text(this.name, 5.0f, this.y + 15);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, 4.0f, this.y + 15 - 1);
            } else {
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(this.name, 5.0f, this.y + 15);
            }
        }

        @Override
        public void press() {
            int i = 0;
            while (i < this.boxes.length) {
                int j;
                this.boxes[i].press();
                if (this.boxes[i].get()) {
                    j = i - 1;
                    while (j >= 0) {
                        this.boxes[j].set();
                        --j;
                    }
                } else {
                    j = i + 1;
                    while (j < this.boxes.length) {
                        this.boxes[j].reset();
                        ++j;
                    }
                }
                ++i;
            }
        }

        public int getValue() {
            int i = this.boxes.length - 1;
            while (i >= 0) {
                if (this.boxes[i].get()) break;
                --i;
            }
            return i + 1;
        }
    }

    class Scouter {
        static final int W = 600;
        Robot bot;
        Rectangle area;
        PImage fullImg;
        PImage windowImg;
        WritableRaster wr;
        PImage hpImg;
        int hpDisplayHysteresis;
        String name;
        String ver;
        AcceTotal accetotal;
        boolean acceFound;
        int expToMax;
        boolean isKamihimeWindowFound;
        final int[] lvOffsetX = new int[]{215, 165, 466, 291, 116, 466};
        final int[] lvOffsetY = new int[]{16, 31, 31, 16, 66, 66};
        final int[] hpOffsetX = new int[]{205, 155, 455, 280, 105, 455};
        final int[] hpOffsetY = new int[]{32, 47, 47, 32, 82, 82};
        final int[] hpPixels = new int[]{358, 177, 177, 177, 177, 177};
        int[] pos;
        int[] hp;

        Scouter(String _name, String _ver) {
            this.name = _name;
            this.ver = _ver;
            this.expToMax = 0;
            this.isKamihimeWindowFound = false;
            String[] AcceStr = new String[]{"Same SSR Lv1", "Same  SR Lv1", "Same   R Lv1", "Same   N Lv1", "Diff SSR Lv1", "Diff  SR Lv1", "Diff   R Lv1", "Diff   N Lv1"};
            int[] Scale = new int[]{600, 300, 150, 75, 400, 200, 100, 50};
            AcceRow[] ar = new AcceRow[AcceStr.length];
            int i = 0;
            while (i < AcceStr.length) {
                ar[i] = new AcceRow(470, 100 + i * 20, AcceStr[i], Scale[i], 0);
                ++i;
            }
            this.accetotal = new AcceTotal(470, 260, ar);
        }

        public boolean initialize() {
            boolean result = false;
            this.hpDisplayHysteresis = 0;
            this.pos = new int[this.lvOffsetX.length];
            this.hp = new int[this.lvOffsetX.length];
            try {
                this.bot = new Robot();
                this.area = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
                result = true;
            }
            catch (AWTException aWTException) {}
            return result;
        }

        public void findKamihimeWindow() {
            this.isKamihimeWindowFound = false;
            BufferedImage bimg = this.bot.createScreenCapture(this.area);
            if (this.fullImg == null) {
                this.fullImg = new PImage((Image)bimg);
                DataBufferInt dbi = new DataBufferInt(this.fullImg.pixels, this.fullImg.pixels.length);
                this.wr = Raster.createWritableRaster(bimg.getSampleModel(), dbi, new Point(0, 0));
                this.fullImg.loadPixels();
            } else {
                bimg.copyData(this.wr);
                this.fullImg.updatePixels();
            }
            int maxX = this.fullImg.width - 1;
            int maxY = this.fullImg.height - 8;
            int px = 0;
            int py = 0;
            px = 0;
            while (px <= maxX) {
                py = 0;
                while (py <= maxY) {
                    int[] g = new int[8];
                    int i = 0;
                    while (i < 8) {
                        int c = this.fullImg.pixels[this.fullImg.width * (py + i) + px];
                        g[i] = AbilityTimer.getG(c);
                        ++i;
                    }
                    if (g[0] < 40 && g[1] > 200 && g[2] < 40 && g[3] > 200 && g[4] < 40 && g[5] > 200 && g[6] > 200 && g[7] < 40) {
                        this.windowImg = this.fullImg.get(px - 142, py + 8, 960, 640);
                        this.isKamihimeWindowFound = true;
                        return;
                    }
                    ++py;
                }
                ++px;
            }
        }

        public boolean searchHpBar() {
            int lvCount = 0;
            boolean[] found = new boolean[this.lvOffsetX.length];
            int i = 0;
            while (i < this.lvOffsetX.length) {
                PImage lvImg = this.windowImg.get(this.lvOffsetX[i], this.lvOffsetY[i], 8, 8);
                boolean rc = Glbl.ocrV(lvImg);
                if (rc) {
                    found[i] = true;
                    ++lvCount;
                }
                if (Glbl.DebugOcr) {
                    AbilityTimer.this.image(lvImg, 640 + 16 * i, 120.0f);
                }
                ++i;
            }
            if (lvCount > 0) {
                i = 0;
                while (i < this.hp.length) {
                    this.hp[i] = 0;
                    ++i;
                }
            }
            i = 0;
            while (i < this.lvOffsetX.length) {
                if (found[i]) {
                    int x = this.hpPixels[i] - 1;
                    while (x >= 0) {
                        int c = this.windowImg.pixels[this.windowImg.width * this.hpOffsetY[i] + this.hpOffsetX[i] + x];
                        int r = AbilityTimer.getR(c);
                        int g = AbilityTimer.getG(c);
                        int b = AbilityTimer.getB(c);
                        if (r > 240 && g < 40 && b < 90) {
                            double tmp = (double)(x * 100) / (double)(this.hpPixels[i] - 1);
                            this.hp[i] = (int)Math.ceil(tmp);
                            this.pos[i] = x;
                            if (!Glbl.DebugHp) break;
                            AbilityTimer.println((String)("hp:" + this.hp[i] + " x:" + x));
                            break;
                        }
                        --x;
                    }
                }
                ++i;
            }
            if (lvCount > 0) {
                this.hpDisplayHysteresis = 5;
                this.hpImg = this.windowImg.get(48, 10, 600, 116);
                this.hpImg.filter(12);
                AbilityTimer.this.image(this.hpImg, 240.0f, 0.0f);
            } else if (this.hpDisplayHysteresis > 0) {
                --this.hpDisplayHysteresis;
                AbilityTimer.this.image(this.hpImg, 240.0f, 0.0f);
            } else {
                return false;
            }
            i = 0;
            while (i < this.lvOffsetX.length) {
                if (this.hp[i] > 0) {
                    AbilityTimer.this.strokeWeight(1.0f);
                    int orgX = 240 + this.hpOffsetX[i] - 48;
                    int orgY = this.hpOffsetY[i] - 10;
                    int hpPix = this.hpPixels[i];
                    if (Glbl.DebugHp) {
                        AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                        AbilityTimer.this.line(orgX, orgY, orgX + hpPix - 1, orgY);
                    }
                    AbilityTimer.this.stroke(0.0f, 255.0f, 0.0f);
                    AbilityTimer.this.line(orgX + this.pos[i], orgY, orgX + this.pos[i], orgY + 12);
                    AbilityTimer.this.line(orgX, orgY + 4, orgX, orgY + 9);
                    AbilityTimer.this.line(orgX, orgY + 6, orgX + hpPix - 1, orgY + 6);
                    AbilityTimer.this.line(orgX + hpPix - 1, orgY + 4, orgX + hpPix - 1, orgY + 9);
                    AbilityTimer.this.line(orgX + hpPix / 2, orgY + 4, orgX + hpPix / 2, orgY + 9);
                    AbilityTimer.this.line((float)orgX + (float)hpPix * 0.3f, orgY + 4, (float)orgX + (float)hpPix * 0.3f, orgY + 9);
                    AbilityTimer.this.textFont(Glbl.font12);
                    AbilityTimer.this.textSize(12.0f);
                    AbilityTimer.this.fill(0);
                    AbilityTimer.this.text(String.valueOf(AbilityTimer.nf((float)this.hp[i])) + "%", orgX + hpPix - 25 + 1, orgY + 3);
                    AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                    AbilityTimer.this.text(String.valueOf(AbilityTimer.nf((float)this.hp[i])) + "%", orgX + hpPix - 25 + 0, orgY + 2);
                }
                ++i;
            }
            return true;
        }

        public boolean searchAccessory() {
            int[] acOffsetX = new int[]{687, 264};
            int[] acOffsetY = new int[]{103, 15};
            int[] acW = new int[]{220, 355};
            int[] acH = new int[]{349, 300};
            int[] rarelityX = new int[]{152, 41};
            int[] rarelityY = new int[]{135, 11};
            int[] levelX = new int[]{196, 49};
            int[] levelY = new int[]{3, 280};
            int[] between = new int[]{2, 3};
            int[] nextX = new int[]{111, 301};
            int[] nextY = new int[]{301, 284};
            String[] rarelityStr = new String[]{"SSR", "SR", "R", "N"};
            int[] rarelityMaxLv = new int[]{50, 40, 30, 20};
            int[] rarelityR = new int[]{183, 117, 152, 132};
            int[] rarelityG = new int[]{131, 133, 82, 117};
            int[] rarelityB = new int[]{75, 148, 51, 103};
            int view = 0;
            while (view < acOffsetX.length) {
                PImage acImg = this.windowImg.get(acOffsetX[view], acOffsetY[view], acW[view], acH[view]);
                int kind = view == 0 ? 0 : 2;
                int w = view == 0 ? 8 : 10;
                int h = view == 0 ? 10 : 14;
                int level = 0;
                int i = 0;
                while (i < 2) {
                    int num;
                    PImage numImg = acImg.get(levelX[view] + i * (w + between[view]), levelY[view], w, h);
                    if (Glbl.DebugOcr) {
                        AbilityTimer.this.image(numImg, 640 + i * (w + 2 + between[view]), 135 + 15 * view);
                    }
                    if ((num = Glbl.ocrNumber(numImg, kind)) < 0) break;
                    if (num < 10) {
                        level = level * 10 + num;
                    }
                    ++i;
                }
                if (view == 0 && level == 0) {
                    int num;
                    PImage numImg = acImg.get(201, 3, w, h);
                    if (Glbl.DebugOcr) {
                        AbilityTimer.this.image(numImg, 640 + 2 * (w + 2 + between[view]), 135.0f);
                    }
                    if ((num = Glbl.ocrNumber(numImg, kind)) >= 0 && num < 10) {
                        level = num;
                    }
                }
                kind = view == 0 ? 1 : 3;
                int nextExp = 0;
                int i2 = 0;
                while (i2 < 4) {
                    int num;
                    PImage numImg = acImg.get(nextX[view] + i2 * 10, nextY[view], 8, 10);
                    if (Glbl.DebugOcr) {
                        AbilityTimer.this.image(numImg, 640 + i2 * 12, 170.0f);
                    }
                    if ((num = Glbl.ocrNumber(numImg, kind)) < 0) break;
                    if (num < 10) {
                        nextExp = nextExp * 10 + num;
                    }
                    ++i2;
                }
                int rarelity = 0;
                PImage iconImg = acImg.get(rarelityX[view], rarelityY[view], 15, 15);
                int c = Glbl.averageOfImage(iconImg);
                int r = AbilityTimer.getR(c);
                int g = AbilityTimer.getG(c);
                int b = AbilityTimer.getB(c);
                int i3 = 0;
                while (i3 < rarelityR.length) {
                    if (rarelityR[i3] - 10 <= r && r <= rarelityR[i3] + 10 && rarelityG[i3] - 10 <= g && g <= rarelityG[i3] + 10 && rarelityB[i3] - 10 <= b && b <= rarelityB[i3] + 10) {
                        rarelity = i3;
                        break;
                    }
                    ++i3;
                }
                if (level == 50 || level > 0 && nextExp > 0) {
                    acImg.filter(12);
                    if (view == 0) {
                        AbilityTimer.this.image(acImg, 240.0f, 0.0f);
                    } else {
                        PImage trimImg = acImg.get(105, 0, acW[0], acH[1]);
                        PImage lvImg = acImg.get(27, acH[1] - 24, acW[0], 24);
                        PImage nextImg = acImg.get(251, acH[1] - 24, 320, 24);
                        AbilityTimer.this.image(trimImg, 240.0f, 0.0f);
                        AbilityTimer.this.image(lvImg, 240.0f, acH[1] - 24);
                        AbilityTimer.this.image(nextImg, 355.0f, acH[1] - 24);
                    }
                    this.expToMax = Glbl.calculateExpToMax(rarelityMaxLv[rarelity], level, nextExp);
                    AbilityTimer.this.textFont(Glbl.font24);
                    AbilityTimer.this.textSize(24.0f);
                    AbilityTimer.this.fill(0);
                    AbilityTimer.this.text(rarelityStr[rarelity], 470.0f, 30.0f);
                    AbilityTimer.this.text("Lv   " + AbilityTimer.nf((float)level), 470.0f, 50.0f);
                    AbilityTimer.this.text("NEXT " + AbilityTimer.nf((float)nextExp), 470.0f, 70.0f);
                    AbilityTimer.this.text("to Lv" + AbilityTimer.nf((float)rarelityMaxLv[rarelity]) + ": " + (this.expToMax > 0 ? String.valueOf(AbilityTimer.nf((float)this.expToMax)) + "exp" : "-"), 470.0f, 90.0f);
                    if (Glbl.DebugOcr) {
                        AbilityTimer.println((String)("Rarelity icon RGB: " + AbilityTimer.nf((float)r) + " " + AbilityTimer.nf((float)g) + " " + AbilityTimer.nf((float)b)));
                        AbilityTimer.this.strokeWeight(1.0f);
                        AbilityTimer.this.stroke(255.0f, 0.0f, 0.0f);
                        AbilityTimer.this.line(240 + rarelityX[view], rarelityY[view], 240 + rarelityX[view] + 10, rarelityY[view] + 10);
                        AbilityTimer.this.image(iconImg, 250.0f, 10.0f);
                    }
                    return true;
                }
                ++view;
            }
            return false;
        }

        public void render() {
            boolean found;
            this.acceFound = false;
            if (this.isKamihimeWindowFound && !(found = this.searchHpBar())) {
                this.acceFound = this.searchAccessory();
                if (this.acceFound) {
                    this.accetotal.setRequiredExp(this.expToMax);
                    this.accetotal.render();
                }
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(String.valueOf(this.name) + " version " + this.ver, 670.0f, 312.0f);
        }

        public void press() {
            if (this.acceFound) {
                this.accetotal.press();
            }
        }

        public void wheel(MouseEvent event) {
            if (this.acceFound) {
                this.accetotal.wheel(event);
            }
        }
    }

    class TimerBar
    extends GuiItem {
        TimerDisplay td;
        static final int W = 64;
        static final int H = 310;

        TimerBar(int _x, int _y, TimerDisplay _td) {
            super(_x, _y, 64, 310);
            this.td = _td;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(224);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.triangle(this.x, this.y, this.x, this.y + 310, this.x + 64 - 1, this.y + 310 - 1);
            AbilityTimer.this.fill(240);
            AbilityTimer.this.triangle(this.x, this.y, this.x + 64, this.y, this.x + 64 - 1, this.y + 310 - 1);
            if (this.isOver()) {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.triangle(this.x, this.y, this.x, AbilityTimer.this.mouseY, this.x + AbilityTimer.this.mouseY / 5, AbilityTimer.this.mouseY);
            }
        }

        public int computeSeconds() {
            return (AbilityTimer.this.mouseY - this.y) / 7 * 5 + 25;
        }

        @Override
        public void press() {
            if (this.isOver()) {
                this.td.start(this.computeSeconds());
            }
        }
    }

    class TimerBarLabel
    extends GuiItem {
        TimerBar tb;

        TimerBarLabel(TimerBar _tb) {
            this.tb = _tb;
        }

        @Override
        public void render() {
            if (this.tb.isOver()) {
                String msg = String.valueOf(AbilityTimer.str((int)this.tb.computeSeconds())) + "sec";
                int y = AbilityTimer.this.mouseY;
                if (y < 20) {
                    y = 20;
                }
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.fill(64);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5 + 2, y + 2);
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                AbilityTimer.this.text(msg, this.tb.x + 15 + AbilityTimer.this.mouseY / 5, y);
            }
        }
    }

    class TimerDisplay
    extends GuiItem {
        int endTime;
        static final int W = 70;
        static final int H = 30;

        TimerDisplay(int _x, int _y) {
            super(_x, _y, 70, 30);
            this.endTime = 0;
        }

        public void start(int seconds) {
            this.endTime = AbilityTimer.this.millis() + 1000 * seconds;
            Glbl.mode = 1;
        }

        @Override
        public void render() {
            int currentTime = AbilityTimer.this.millis();
            int remainTime = this.endTime - currentTime;
            if (remainTime <= 0) {
                Glbl.mode = 0;
                Glbl.chime.play();
            } else {
                AbilityTimer.this.strokeWeight(2.0f);
                AbilityTimer.this.stroke(128);
                AbilityTimer.this.fill(this.isOver() ? 64 : 0);
                AbilityTimer.this.rect(this.x, this.y, 69.0f, 29.0f);
                String msg = "000.0";
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
                int sec = remainTime / 1000;
                int decimal = remainTime / 100 % 10;
                msg = String.valueOf(AbilityTimer.nf((int)sec, (int)3)) + "." + AbilityTimer.str((int)decimal);
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(24.0f);
                AbilityTimer.this.text(msg, this.x + 5, this.y + 22);
            }
        }

        @Override
        public void press() {
            if (this.isOver()) {
                Glbl.mode = 0;
            }
        }
    }

    class Valuebox
    extends GuiItem {
        static final int W = 30;
        static final int H = 20;
        static final int upperLimit = 99;
        static final int lowerLimit = 0;
        static final int threshold = 20;
        int value;

        Valuebox(int _x, int _y, int _value) {
            super(_x, _y, 30, 20);
            this.value = _value;
        }

        @Override
        public void render() {
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(this.isOver() ? 224 : 255);
            AbilityTimer.this.rect(this.x, this.y, 29.0f, 19.0f);
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(16.0f);
            if (this.value > 20) {
                AbilityTimer.this.fill(255.0f, 0.0f, 0.0f);
            } else {
                AbilityTimer.this.fill(0);
            }
            AbilityTimer.this.text(String.valueOf(this.value <= 9 ? " " : "") + AbilityTimer.nf((float)this.value), this.x + 6, this.y + 16);
        }

        public void notify(String str) {
            if (str.equals("+")) {
                ++this.value;
                if (this.value > 99) {
                    this.value = 99;
                }
            } else if (str.equals("-")) {
                --this.value;
                if (this.value < 0) {
                    this.value = 0;
                }
            }
        }

        public void setValue(int _value) {
            this.value = _value;
        }

        public int getValue() {
            return this.value;
        }
    }

    class WallClock
    extends GuiItem {
        ZoneId zid;
        int[] gemTimeTable;
        static final int W = 82;
        static final int H = 20;

        WallClock(ZoneId _zid) {
            super(157, 299, 82, 20);
            this.zid = _zid;
            this.gemTimeTable = new int[AbilityTimer.this.dmmGemTimeTable.length];
            float[] tbl = AbilityTimer.this.dmmGemTimeTable;
            if (this.zid.equals(ZoneId.of("America/Los_Angeles"))) {
                tbl = AbilityTimer.this.nutakuGemTimeTable;
            }
            int i = 0;
            while (i < AbilityTimer.this.dmmGemTimeTable.length) {
                this.gemTimeTable[i] = PApplet.parseInt((float)(tbl[i] * 100.0f));
                ++i;
            }
        }

        @Override
        public void render() {
            Instant currentTime = Instant.now();
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int w = zoneTime.getDayOfWeek().getValue();
            int hour = zoneTime.getHour();
            int minute = zoneTime.getMinute();
            boolean isGemTime = false;
            int nowHour = hour * 100 + minute * 100 / 60;
            Glbl.isLastOneMinute = false;
            int i = 0;
            while (i < 3) {
                int gemHour = this.gemTimeTable[(w - 1) * 3 + i];
                if (gemHour <= nowHour && nowHour < gemHour + 50) {
                    isGemTime = true;
                    if (minute != 29 && minute != 59) break;
                    Glbl.isLastOneMinute = true;
                    break;
                }
                ++i;
            }
            if (this.isOver()) {
                zoneTime = currentTime.atZone(ZoneId.systemDefault());
                hour = zoneTime.getHour();
                minute = zoneTime.getMinute();
            }
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.stroke(128);
            if (isGemTime) {
                AbilityTimer.this.fill(255.0f, 255.0f, 0.0f);
            } else {
                AbilityTimer.this.fill(0);
            }
            AbilityTimer.this.rect(this.x, this.y, 81.0f, 19.0f);
            if (isGemTime) {
                AbilityTimer.this.fill(0);
            } else {
                AbilityTimer.this.fill(0.0f, 255.0f, 0.0f);
            }
            AbilityTimer.this.textFont(Glbl.font24);
            AbilityTimer.this.textSize(12.0f);
            String dow = zoneTime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.US);
            int day = zoneTime.getDayOfMonth();
            String msg = dow;
            if (!Glbl.isLastOneMinute) {
                msg = String.valueOf(msg) + " " + (day < 10 ? " " : "") + AbilityTimer.str((int)day);
                msg = String.valueOf(msg) + " " + AbilityTimer.nf((int)hour, (int)2) + ":" + AbilityTimer.nf((int)minute, (int)2);
                AbilityTimer.this.text(msg, this.x + 4, this.y + 14);
            } else {
                int second = zoneTime.getSecond();
                msg = String.valueOf(msg) + " " + AbilityTimer.nf((int)hour, (int)2) + ":" + AbilityTimer.nf((int)minute, (int)2) + ":" + AbilityTimer.nf((int)second, (int)2);
                AbilityTimer.this.text(msg, this.x + 4, this.y + 14);
            }
            if (this.isOver()) {
                this.putGemQuestTable(currentTime);
            } else {
                AbilityTimer.this.textFont(Glbl.font12);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.textAlign(39);
                AbilityTimer.this.text(this.zid.toString(), this.x - 2, 312.0f);
                AbilityTimer.this.textAlign(37);
            }
        }

        @Override
        public void press() {
        }

        public void putGemQuestTable(Instant currentTime) {
            ZonedDateTime zoneTime = currentTime.atZone(this.zid);
            int m = zoneTime.getMinute();
            if (m % 15 > 0) {
                zoneTime = zoneTime.plusMinutes(15 - m % 15);
            }
            AbilityTimer.this.stroke(128);
            AbilityTimer.this.strokeWeight(1.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.rect(6.0f, 86.0f, 231.0f, 201.0f);
            AbilityTimer.this.fill(255);
            AbilityTimer.this.rect(5.0f, 85.0f, 230.0f, 200.0f);
            int msgY = 100;
            boolean first = true;
            int[] localGemTimeTable = new int[28];
            int i = 0;
            while (i < 28) {
                localGemTimeTable[i] = Integer.MAX_VALUE;
                ++i;
            }
            i = 0;
            while (i < 672) {
                int w = zoneTime.getDayOfWeek().getValue();
                int hour = zoneTime.getHour();
                int minute = zoneTime.getMinute();
                int nowHour = hour * 100 + minute * 100 / 60;
                int j = 0;
                while (j < 3) {
                    int gemHour = this.gemTimeTable[(w - 1) * 3 + j];
                    if (gemHour == nowHour) {
                        Instant t = Instant.from(zoneTime);
                        ZonedDateTime local = t.atZone(ZoneId.systemDefault());
                        int lw = local.getDayOfWeek().getValue();
                        int lh = local.getHour();
                        int lm = local.getMinute();
                        int found = lh * 100 + lm * 100 / 60;
                        if (first) {
                            first = false;
                        }
                        int index = (lw - 1) * 4;
                        int[] part = new int[]{++found, localGemTimeTable[index + 0], localGemTimeTable[index + 1], localGemTimeTable[index + 2], localGemTimeTable[index + 3]};
                        Arrays.sort(part);
                        System.arraycopy(part, 0, localGemTimeTable, index, 4);
                    }
                    ++j;
                }
                zoneTime = zoneTime.plusMinutes(15L);
                ++i;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text("Gem Quest on your Timezone", 10.0f, msgY);
            msgY = (int)((float)msgY + 30.0f);
            int w = 1;
            while (w <= 7) {
                String msg = DayOfWeek.of(w).getDisplayName(TextStyle.SHORT, Locale.US);
                msg = String.valueOf(msg) + " ";
                int i2 = 0;
                while (i2 < 4) {
                    int index = (w - 1) * 4 + i2;
                    int value = localGemTimeTable[index];
                    if (value != Integer.MAX_VALUE) {
                        int lh = value / 100;
                        int lm = value % 100 * 60 / 100;
                        msg = value % 10 == 1 ? String.valueOf(msg) + ">" + AbilityTimer.nf((int)lh, (int)2) + ":" + AbilityTimer.nf((int)lm, (int)2) + "<" : String.valueOf(msg) + " " + AbilityTimer.nf((int)lh, (int)2) + ":" + AbilityTimer.nf((int)lm, (int)2) + " ";
                    }
                    ++i2;
                }
                AbilityTimer.this.textFont(Glbl.font24);
                AbilityTimer.this.textSize(12.0f);
                AbilityTimer.this.fill(0);
                AbilityTimer.this.text(msg, 15.0f, msgY);
                msgY += 20;
                ++w;
            }
            AbilityTimer.this.textFont(Glbl.font12);
            AbilityTimer.this.textSize(12.0f);
            AbilityTimer.this.fill(0);
            AbilityTimer.this.text(ZoneId.systemDefault().toString(), this.x - 55, this.y - 20);
            AbilityTimer.this.stroke(0);
            AbilityTimer.this.strokeWeight(2.0f);
            AbilityTimer.this.line(this.x - 10, this.y - 15, this.x, this.y - 3);
        }
    }
}

