/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a2viewer;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a2.A2Canvas;
import jp.sourceforge.acerola3d.a2.A2Loader;
import jp.sourceforge.acerola3d.a2.Action2D;
import jp.sourceforge.acerola3d.a2viewer.JTextAreaOutputStream;

public class A2Viewer
implements ActionListener {
    JFrame frame;
    JMenuBar menuBar;
    JMenu configMenu;
    JMenuItem consoleMenuItem;
    JMenuItem proxyMenuItem;
    JMenuItem snapshotMenuItem;
    JMenuItem backgroundMenuItem;
    JTextField urlTextField;
    JButton refButton;
    JFileChooser fileChooser;
    A2Canvas a2canvas;
    JComboBox actionNameCB;
    JTextArea commentTextArea;
    JLabel statusBarLabel;
    JFrame consoleFrame;
    JTextArea consoleTextArea;
    JButton clearConsoleButton;
    Action2D a2;
    String actionName = "0";
    ProxyPanel proxyPanel = null;
    String[] proxyData = new String[]{"", "", "", ""};

    public A2Viewer(String[] args) {
        A23.initA23();
        this.frame = new JFrame("A2Viewer");
        Box baseBox = Box.createVerticalBox();
        this.frame.getContentPane().add(baseBox);
        this.menuBar = new JMenuBar();
        this.frame.setJMenuBar(this.menuBar);
        this.menuBar.add(Box.createHorizontalGlue());
        this.configMenu = new JMenu("Config");
        this.menuBar.add(this.configMenu);
        this.consoleMenuItem = new JMenuItem("Console");
        this.consoleMenuItem.addActionListener(this);
        this.configMenu.add(this.consoleMenuItem);
        this.proxyMenuItem = new JMenuItem("Proxy");
        this.proxyMenuItem.addActionListener(this);
        this.configMenu.add(this.proxyMenuItem);
        this.snapshotMenuItem = new JMenuItem("Snapshot");
        this.snapshotMenuItem.addActionListener(this);
        this.configMenu.add(this.snapshotMenuItem);
        this.backgroundMenuItem = new JMenuItem("Background");
        this.backgroundMenuItem.addActionListener(this);
        this.configMenu.add(this.backgroundMenuItem);
        this.consoleFrame = new JFrame("Console");
        Box b = Box.createVerticalBox();
        this.consoleTextArea = new JTextArea(20, 60);
        this.consoleTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.consoleTextArea);
        b.add(sp);
        this.clearConsoleButton = new JButton("Clear");
        this.clearConsoleButton.addActionListener(this);
        b.add(this.clearConsoleButton);
        this.consoleFrame.getContentPane().add(b);
        this.consoleFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                A2Viewer.this.consoleFrame.setVisible(false);
            }
        });
        PrintStream systemOut = System.out;
        JTextAreaOutputStream jtaos = new JTextAreaOutputStream(this.consoleTextArea, systemOut);
        PrintStream ps = new PrintStream(jtaos, true);
        System.setOut(ps);
        System.setErr(ps);
        this.consoleFrame.pack();
        Box box1 = Box.createHorizontalBox();
        baseBox.add(box1);
        box1.add(new JLabel("URL:"));
        this.urlTextField = new JTextField();
        try {
            File f = null;
            f = args != null && args.length == 2 && args[0].equals("-open") ? new File(args[1]) : new File(args[0]);
            URL url = f.toURL();
            this.urlTextField.setText(url.toExternalForm());
        }
        catch (Exception e) {
            this.urlTextField.setText("x-res:///jp/sourceforge/acerola3d/a2viewer/resources/acerola.a2");
        }
        this.urlTextField.addActionListener(this);
        this.urlTextField.setMaximumSize(new Dimension(3000, 30));
        box1.add(this.urlTextField);
        this.refButton = new JButton("ref");
        this.refButton.addActionListener(this);
        box1.add(this.refButton);
        Box box2 = Box.createHorizontalBox();
        baseBox.add(box2);
        this.a2canvas = A2Canvas.createA2Canvas(300, 300);
        box2.add(this.a2canvas);
        Box controlBox = this.makeControlBox();
        box2.add(controlBox);
        this.statusBarLabel = new JLabel("Status:");
        baseBox.add(this.statusBarLabel);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                A2Viewer.this.frame.dispose();
                System.exit(0);
            }
        });
        this.frame.pack();
        this.frame.setVisible(true);
        this.loadAction2D();
    }

    Box makeControlBox() {
        Box controlBox = Box.createVerticalBox();
        controlBox.add(new JLabel("ActionName:"));
        this.actionNameCB = new JComboBox();
        this.actionNameCB.setPreferredSize(new Dimension(50, 30));
        this.actionNameCB.setMaximumSize(new Dimension(30000, 30));
        this.actionNameCB.addActionListener(this);
        controlBox.add(this.actionNameCB);
        controlBox.add(Box.createVerticalGlue());
        controlBox.add(new JLabel("***Comment***"));
        this.commentTextArea = new JTextArea(10, 30);
        this.commentTextArea.setEditable(false);
        JScrollPane sp = new JScrollPane(this.commentTextArea);
        sp.setPreferredSize(new Dimension(50, 150));
        sp.setMaximumSize(new Dimension(30000, 150));
        controlBox.add(sp);
        controlBox.add(Box.createVerticalGlue());
        String buildTime = null;
        try {
            URL url = this.getClass().getClassLoader().getResource("buildTime.txt");
            InputStreamReader isr = new InputStreamReader(url.openStream(), "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            buildTime = br.readLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            buildTime = "???";
        }
        controlBox.add(new JLabel("build time:"));
        controlBox.add(new JLabel("   " + buildTime));
        return controlBox;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.actionNameCB) {
            this.actionName = (String)this.actionNameCB.getSelectedItem();
            if (this.actionName == null) {
                System.out.println("gaha1");
                return;
            }
            System.out.println("actionName:" + this.actionName);
            this.repaint();
        } else if (ae.getSource() == this.urlTextField) {
            this.loadAction2D();
        } else if (ae.getSource() == this.refButton) {
            this.ref();
        } else if (ae.getSource() == this.consoleMenuItem) {
            this.consoleFrame.setVisible(true);
        } else if (ae.getSource() == this.clearConsoleButton) {
            this.consoleTextArea.setText("");
        } else if (ae.getSource() == this.proxyMenuItem) {
            this.proxyConfig();
        } else if (ae.getSource() == this.snapshotMenuItem) {
            try {
                File f = new File("snapshot.png");
                this.a2canvas.saveImage(f);
            }
            catch (Exception e) {
                System.out.println("A2Viewer:snapshot");
                e.printStackTrace();
            }
        } else if (ae.getSource() == this.backgroundMenuItem) {
            this.setBackground();
        } else {
            System.out.append("gaha???");
        }
    }

    void loadAction2D() {
        this.statusBarLabel.setText("Status: Loading ... ");
        this.statusBarLabel.repaint();
        if (this.a2 != null) {
            this.a2canvas.del(this.a2);
        }
        String urlString = this.urlTextField.getText();
        try {
            URL url = new URL(urlString);
            this.a2 = A2Loader.load(url);
        }
        catch (Exception e) {
            System.out.println("A2Viewer.loadAction2D. error!");
            e.printStackTrace();
        }
        this.a2canvas.add(this.a2);
        this.actionNameCB.removeAllItems();
        String[] sss = this.a2.getActionNames();
        for (int i = 0; i < sss.length; ++i) {
            this.actionNameCB.addItem(sss[i]);
        }
        this.commentTextArea.setText(this.a2.getComment());
        this.a2canvas.resetCamera();
        this.statusBarLabel.setText("Status: Loading ... done.");
    }

    void repaint() {
        if (this.a2 == null) {
            return;
        }
        this.a2.change((Serializable)((Object)this.actionName));
    }

    void proxyConfig() {
        if (this.proxyPanel == null) {
            this.proxyPanel = new ProxyPanel();
            this.proxyData[0] = System.getProperty("proxyHost");
            this.proxyData[1] = System.getProperty("proxyPort");
            this.proxyData[2] = System.getProperty("ftpProxyHost");
            this.proxyData[3] = System.getProperty("ftpProxyPort");
        }
        this.proxyPanel.setData(this.proxyData);
        Object[] options = new Object[]{"Ok", "Cancel"};
        int result = JOptionPane.showOptionDialog(this.frame, this.proxyPanel, "proxy", -1, 1, null, options, options[0]);
        if (result == 0) {
            this.proxyData = this.proxyPanel.getData();
            if (!this.proxyData[0].equals("")) {
                System.getProperties().put("proxySet", "true");
                System.getProperties().put("proxyHost", this.proxyData[0]);
                System.getProperties().put("proxyPort", this.proxyData[1]);
            } else {
                System.getProperties().put("proxySet", "false");
                System.getProperties().put("proxyHost", "");
                System.getProperties().put("proxyPort", "");
            }
            if (!this.proxyData[2].equals("")) {
                System.getProperties().put("ftpProxySet", "true");
                System.getProperties().put("ftpProxyHost", this.proxyData[2]);
                System.getProperties().put("ftpProxyPort", this.proxyData[3]);
            } else {
                System.getProperties().put("ftpProxySet", "false");
                System.getProperties().put("ftpProxyHost", "");
                System.getProperties().put("ftpProxyPort", "");
            }
        }
    }

    void ref() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this.frame)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = f.toURL();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        this.urlTextField.setText(url.toExternalForm());
        this.loadAction2D();
    }

    void setBackground() {
        int returnVal;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if ((returnVal = this.fileChooser.showOpenDialog(this.frame)) != 0) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        URL url = null;
        try {
            url = f.toURL();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (url == null) {
            return;
        }
        Action2D a = null;
        try {
            a = A2Loader.load(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (a != null) {
            this.a2canvas.setBackground(a);
        }
    }

    public static void main(String[] args) {
        System.setSecurityManager(null);
        A2Viewer v = new A2Viewer(args);
    }

    class ProxyPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        JTextField httpHostTF;
        JTextField httpPortTF;
        JTextField ftpHostTF;
        JTextField ftpPortTF;

        public ProxyPanel() {
            Box b0 = Box.createVerticalBox();
            Box b1 = Box.createHorizontalBox();
            Box b2 = Box.createHorizontalBox();
            this.add(b0);
            b0.add(b1);
            b0.add(b2);
            b1.add(new JLabel("http: host"));
            this.httpHostTF = new JTextField(40);
            b1.add(this.httpHostTF);
            b1.add(new JLabel(" port "));
            this.httpPortTF = new JTextField(5);
            b1.add(this.httpPortTF);
            b2.add(new JLabel("ftp: host"));
            this.ftpHostTF = new JTextField(40);
            b2.add(this.ftpHostTF);
            b2.add(new JLabel(" port "));
            this.ftpPortTF = new JTextField(5);
            b2.add(this.ftpPortTF);
        }

        public void setData(String[] proxyData) {
            this.httpHostTF.setText(proxyData[0]);
            this.httpPortTF.setText(proxyData[1]);
            this.ftpHostTF.setText(proxyData[2]);
            this.ftpPortTF.setText(proxyData[3]);
        }

        public String[] getData() {
            String[] ret = new String[]{this.httpHostTF.getText(), this.httpPortTF.getText(), this.ftpHostTF.getText(), this.ftpPortTF.getText()};
            return ret;
        }
    }
}

