/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a2viewer;

import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JTextArea;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class JTextAreaOutputStream
extends OutputStream {
    JTextArea textArea;
    PrintStream systemOut;
    byte[] queue;
    int position = 0;

    public JTextAreaOutputStream(JTextArea ta, PrintStream systemOut) {
        this.systemOut = systemOut;
        this.textArea = ta;
        this.queue = new byte[256];
    }

    @Override
    public void write(int b) {
        this.systemOut.write(b);
        this.queue[this.position++] = (byte)b;
        if (this.position >= 256) {
            this.flush();
        }
    }

    @Override
    public void flush() {
        this.systemOut.flush();
        String s = new String(this.queue, 0, this.position);
        this.position = 0;
        this.textArea.append(s);
        Document d = this.textArea.getDocument();
        Position p = d.getEndPosition();
        Caret c = this.textArea.getCaret();
        c.setDot(p.getOffset());
    }
}

