/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.Color;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import jp.sourceforge.acerola3d.a3.A3Canvas;
import jp.sourceforge.acerola3d.a3.A3InitData;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3UpdateData;

public class A3Arc
extends A3Object {
    double headX;
    double headY;
    double headZ;
    double tailX;
    double tailY;
    double tailZ;
    Point3d[] vertex;
    LineArray geometry;

    public A3Arc(A3InitData d) {
        super(d);
        this.headX = d.getDouble(0);
        this.headY = d.getDouble(1);
        this.headZ = d.getDouble(2);
        this.tailX = d.getDouble(3);
        this.tailY = d.getDouble(4);
        this.tailZ = d.getDouble(5);
        this.vertex = new Point3d[2];
        this.geometry = new LineArray(2, 5);
        this.geometry.setCapability(1);
        if (A3Canvas.getUpperDirection() == A3Canvas.UpperDirection.Y) {
            this.vertex[0] = new Point3d(this.headX, this.headY, this.headZ);
            this.vertex[1] = new Point3d(this.tailX, this.tailY, this.tailZ);
        } else if (A3Canvas.getUpperDirection() == A3Canvas.UpperDirection.Z) {
            this.vertex[0] = new Point3d(this.headX, this.headZ, -this.headY);
            this.vertex[1] = new Point3d(this.tailX, this.tailZ, -this.tailY);
        }
        this.geometry.setCoordinates(0, this.vertex);
        this.geometry.setColor(0, new Color3f(Color.blue));
        this.geometry.setColor(1, new Color3f(Color.red));
        Shape3D shape = new Shape3D((Geometry)this.geometry);
        this.setNode((Node)shape);
    }

    @Override
    public void update(A3UpdateData d) {
        super.update(d);
        this.headX = d.getDouble(0);
        this.headY = d.getDouble(1);
        this.headZ = d.getDouble(2);
        this.tailX = d.getDouble(3);
        this.tailY = d.getDouble(4);
        this.tailZ = d.getDouble(5);
        this.repaint();
    }

    public static A3Arc load() {
        return A3Arc.load(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null);
    }

    public static A3Arc load(double hx, double hy, double hz, double tx, double ty, double tz, boolean isEnableBehavior, String label) {
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.A3Arc");
        d.setEnableBehavior(isEnableBehavior);
        d.setLabel(label);
        d.set(Double.valueOf(hx), Double.valueOf(hy), Double.valueOf(hz), Double.valueOf(tx), Double.valueOf(ty), Double.valueOf(tz));
        A3Arc a = new A3Arc(d);
        return a;
    }

    public void setHead(double x, double y, double z) {
        this.headX = x;
        this.headY = y;
        this.headZ = z;
        this.repaint();
    }

    public void setTail(double x, double y, double z) {
        this.tailX = x;
        this.tailY = y;
        this.tailZ = z;
        this.repaint();
    }

    void repaint() {
        if (A3Canvas.getUpperDirection() == A3Canvas.UpperDirection.Y) {
            this.vertex[0] = new Point3d(this.headX, this.headY, this.headZ);
            this.vertex[1] = new Point3d(this.tailX, this.tailY, this.tailZ);
        } else if (A3Canvas.getUpperDirection() == A3Canvas.UpperDirection.Z) {
            this.vertex[0] = new Point3d(this.headX, this.headZ, -this.headY);
            this.vertex[1] = new Point3d(this.tailX, this.tailZ, -this.tailY);
        }
        this.geometry.setCoordinates(0, this.vertex);
    }
}

