/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.QuadArray;
import javax.vecmath.Point3d;
import org.jdesktop.j3d.loaders.vrml97.impl.Geometry;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.SFVec3f;

public class Box
extends Geometry {
    SFVec3f size;
    QuadArray impl;
    BoundingBox bounds;

    public Box(Loader loader) {
        super(loader);
        this.size = new SFVec3f(2.0f, 2.0f, 2.0f);
        this.initFields();
    }

    Box(Loader loader, SFVec3f size) {
        super(loader);
        this.size = size;
        this.initFields();
    }

    private void updatePoints() {
        float[] coords = new float[72];
        float sx = this.size.value[0] / 2.0f;
        float sy = this.size.value[1] / 2.0f;
        float sz = this.size.value[2] / 2.0f;
        Point3d min = new Point3d((double)(-sx), (double)(-sy), (double)(-sz));
        Point3d max = new Point3d((double)sx, (double)sy, (double)sz);
        this.bounds = new BoundingBox(min, max);
        coords[0] = sx;
        coords[1] = -sy;
        coords[2] = sz;
        coords[3] = sx;
        coords[4] = sy;
        coords[5] = sz;
        coords[6] = -sx;
        coords[7] = sy;
        coords[8] = sz;
        coords[9] = -sx;
        coords[10] = -sy;
        coords[11] = sz;
        coords[12] = -sx;
        coords[13] = -sy;
        coords[14] = -sz;
        coords[15] = -sx;
        coords[16] = sy;
        coords[17] = -sz;
        coords[18] = sx;
        coords[19] = sy;
        coords[20] = -sz;
        coords[21] = sx;
        coords[22] = -sy;
        coords[23] = -sz;
        coords[24] = sx;
        coords[25] = -sy;
        coords[26] = -sz;
        coords[27] = sx;
        coords[28] = sy;
        coords[29] = -sz;
        coords[30] = sx;
        coords[31] = sy;
        coords[32] = sz;
        coords[33] = sx;
        coords[34] = -sy;
        coords[35] = sz;
        coords[36] = -sx;
        coords[37] = -sy;
        coords[38] = sz;
        coords[39] = -sx;
        coords[40] = sy;
        coords[41] = sz;
        coords[42] = -sx;
        coords[43] = sy;
        coords[44] = -sz;
        coords[45] = -sx;
        coords[46] = -sy;
        coords[47] = -sz;
        coords[48] = sx;
        coords[49] = sy;
        coords[50] = sz;
        coords[51] = sx;
        coords[52] = sy;
        coords[53] = -sz;
        coords[54] = -sx;
        coords[55] = sy;
        coords[56] = -sz;
        coords[57] = -sx;
        coords[58] = sy;
        coords[59] = sz;
        coords[60] = -sx;
        coords[61] = -sy;
        coords[62] = sz;
        coords[63] = -sx;
        coords[64] = -sy;
        coords[65] = -sz;
        coords[66] = sx;
        coords[67] = -sy;
        coords[68] = -sz;
        coords[69] = sx;
        coords[70] = -sy;
        coords[71] = sz;
        this.impl.setCoordinates(0, coords);
    }

    private void initNormals() {
        float[] normals = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};
        this.impl.setNormals(0, normals);
    }

    void initImpl() {
        this.impl = new QuadArray(24, 3);
        this.updatePoints();
        this.initNormals();
        this.implReady = true;
    }

    public void notifyMethod(String eventInName, double time) {
        if (eventInName.equals("size")) {
            System.out.println("Updating the points size = " + this.size.value[0] + " " + this.size.value[1] + " " + this.size.value[2]);
            this.updatePoints();
        } else {
            System.err.println("Box.notifyMethod: unexpected eventInName: " + eventInName);
        }
    }

    public javax.media.j3d.Geometry getImplGeom() {
        if (this.impl == null) {
            throw new NullPointerException();
        }
        return this.impl;
    }

    public BoundingBox getBoundingBox() {
        return this.bounds;
    }

    public boolean haveTexture() {
        return false;
    }

    public int getNumTris() {
        return 12;
    }

    public Object clone() {
        return new Box(this.loader, (SFVec3f)this.size.clone());
    }

    public String getType() {
        return "Box";
    }

    void initFields() {
        this.size.init(this, this.FieldSpec, 3, "size");
    }
}

