/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import org.jdesktop.j3d.loaders.vrml97.impl.ASCII_CharStream;
import org.jdesktop.j3d.loaders.vrml97.impl.BaseNode;
import org.jdesktop.j3d.loaders.vrml97.impl.Field;
import org.jdesktop.j3d.loaders.vrml97.impl.GroupBase;
import org.jdesktop.j3d.loaders.vrml97.impl.IndexedFaceSet;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.MFColor;
import org.jdesktop.j3d.loaders.vrml97.impl.MFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.MFInt32;
import org.jdesktop.j3d.loaders.vrml97.impl.MFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.MFRotation;
import org.jdesktop.j3d.loaders.vrml97.impl.MFString;
import org.jdesktop.j3d.loaders.vrml97.impl.MFTime;
import org.jdesktop.j3d.loaders.vrml97.impl.MFVec2f;
import org.jdesktop.j3d.loaders.vrml97.impl.MFVec3f;
import org.jdesktop.j3d.loaders.vrml97.impl.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.ParseException;
import org.jdesktop.j3d.loaders.vrml97.impl.ParserConstants;
import org.jdesktop.j3d.loaders.vrml97.impl.ParserTokenManager;
import org.jdesktop.j3d.loaders.vrml97.impl.Proto;
import org.jdesktop.j3d.loaders.vrml97.impl.ProtoInstance;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFColor;
import org.jdesktop.j3d.loaders.vrml97.impl.SFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.SFInt32;
import org.jdesktop.j3d.loaders.vrml97.impl.SFNode;
import org.jdesktop.j3d.loaders.vrml97.impl.SFRotation;
import org.jdesktop.j3d.loaders.vrml97.impl.SFString;
import org.jdesktop.j3d.loaders.vrml97.impl.SFTime;
import org.jdesktop.j3d.loaders.vrml97.impl.SFVec2f;
import org.jdesktop.j3d.loaders.vrml97.impl.SFVec3f;
import org.jdesktop.j3d.loaders.vrml97.impl.Script;
import org.jdesktop.j3d.loaders.vrml97.impl.Time;
import org.jdesktop.j3d.loaders.vrml97.impl.Token;

public class Parser
implements ParserConstants {
    Loader loader;
    int lastLine = 0;
    Object[] loaderParam;
    Class[] loaderClass;
    Hashtable vrmlNodes = null;
    Hashtable fieldTypeCodes = null;
    public ParserTokenManager token_source;
    ASCII_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;

    Parser(Loader loader, Reader reader) {
        this(reader);
        this.loader = loader;
        this.initTables();
    }

    int currentLine() {
        Token curToken = this.getToken(0);
        return curToken.endLine;
    }

    void initTables() {
        this.loaderClass = new Class[1];
        this.loaderClass[0] = this.loader.getClass();
        this.loaderParam = new Object[1];
        this.loaderParam[0] = this.loader;
        this.vrmlNodes = new Hashtable();
        this.addVrmlNode("Anchor");
        this.addVrmlNode("Appearance");
        this.addVrmlNode("AudioClip");
        this.addVrmlNode("Background");
        this.addVrmlNode("Billboard");
        this.addVrmlNode("Box");
        this.addVrmlNode("Collision");
        this.addVrmlNode("Color");
        this.addVrmlNode("ColorInterpolator");
        this.addVrmlNode("Cone");
        this.addVrmlNode("Coordinate");
        this.addVrmlNode("CoordinateInterpolator");
        this.addVrmlNode("Cylinder");
        this.addVrmlNode("CylinderSensor");
        this.addVrmlNode("DirectionalLight");
        this.addVrmlNode("ElevationGrid");
        this.addVrmlNode("Extrusion");
        this.addVrmlNode("Fog");
        this.addVrmlNode("FontStyle");
        this.addVrmlNode("Group");
        this.addVrmlNode("ImageTexture");
        this.addVrmlNode("IndexedFaceSet");
        this.addVrmlNode("IndexedLineSet");
        this.addVrmlNode("Inline");
        this.addVrmlNode("LOD");
        this.addVrmlNode("Material");
        this.addVrmlNode("NavigationInfo");
        this.addVrmlNode("Normal");
        this.addVrmlNode("NormalInterpolator");
        this.addVrmlNode("OrientationInterpolator");
        this.addVrmlNode("PlaneSensor");
        this.addVrmlNode("PointLight");
        this.addVrmlNode("PointSet");
        this.addVrmlNode("PositionInterpolator");
        this.addVrmlNode("ProximitySensor");
        this.addVrmlNode("ScalarInterpolator");
        this.addVrmlNode("Shape");
        this.addVrmlNode("Sound");
        this.addVrmlNode("Sphere");
        this.addVrmlNode("SphereSensor");
        this.addVrmlNode("SpotLight");
        this.addVrmlNode("Switch");
        this.addVrmlNode("Text");
        this.addVrmlNode("TextureCoordinate");
        this.addVrmlNode("TextureTransform");
        this.addVrmlNode("TimeSensor");
        this.addVrmlNode("TouchSensor");
        this.addVrmlNode("Transform");
        this.addVrmlNode("Viewpoint");
        this.addVrmlNode("WorldInfo");
        this.fieldTypeCodes = new Hashtable();
        this.addField("SFBool", 31);
        this.addField("SFColor", 32);
        this.addField("SFFloat", 33);
        this.addField("SFInt32", 34);
        this.addField("SFNode", 35);
        this.addField("SFRotation", 36);
        this.addField("SFString", 37);
        this.addField("SFTime", 38);
        this.addField("SFVec2f", 39);
        this.addField("SFVec3f", 40);
        this.addField("MFColor", 41);
        this.addField("MFFloat", 42);
        this.addField("MFInt32", 43);
        this.addField("MFNode", 44);
        this.addField("MFRotation", 45);
        this.addField("MFString", 46);
        this.addField("MFTime", 47);
        this.addField("MFVec2f", 48);
        this.addField("MFVec3f", 49);
    }

    void addVrmlNode(String nodeTypeId) {
        String className = "org.jdesktop.j3d.loaders.vrml97.impl." + nodeTypeId;
        try {
            Class<?> nodeClass = Class.forName(className);
            try {
                Constructor<?> nodeConstructor = nodeClass.getConstructor(this.loaderClass);
                this.vrmlNodes.put(nodeTypeId, nodeConstructor);
            }
            catch (NoSuchMethodException e) {
                System.out.println("vrml97 Loader: Initialization error: Can't find constructor for VRML node: " + className);
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("vrml97 Loader: Initialization error: Can't find class for VRML node: " + className);
        }
    }

    void addField(String fieldTypeId, int fieldCode) {
        String className = "org.jdesktop.j3d.loaders.vrml97.impl." + fieldTypeId;
        try {
            Class<?> fieldClass = Class.forName(className);
            this.fieldTypeCodes.put(fieldClass, new Integer(fieldCode));
        }
        catch (ClassNotFoundException e) {
            System.out.println("vrml97 Loader: Initialization error: Can't find class for VRML node: " + className);
        }
    }

    Constructor vrmlNodeConstructor(String nodeTypeId) {
        return (Constructor)this.vrmlNodes.get(nodeTypeId);
    }

    public final void Scene() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 20: 
                case 25: 
                case 26: 
                case 50: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.Statement();
        }
        this.jj_consume_token(0);
    }

    public final void Statement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 19: 
            case 50: {
                BaseNode node = this.NodeStatement();
                this.loader.addObject(node);
                break;
            }
            case 26: {
                this.RouteStatement();
                break;
            }
            case 20: 
            case 25: {
                this.ProtoStatement();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final BaseNode NodeStatement() throws ParseException {
        this.loader.cleanUp();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                BaseNode node = this.Node();
                if (node instanceof ProtoInstance) {
                    node = ((ProtoInstance)node).instanceNode();
                }
                return node;
            }
            case 18: {
                this.jj_consume_token(18);
                String defName = this.NodeNameId();
                BaseNode node = this.Node();
                this.loader.namespaceDefine(defName, node);
                if (node instanceof ProtoInstance) {
                    node = ((ProtoInstance)node).instanceNode();
                }
                return node;
            }
            case 19: {
                this.jj_consume_token(19);
                String defName = this.NodeNameId();
                BaseNode node = this.loader.namespaceUse(defName);
                if (node instanceof ProtoInstance) {
                    node = ((ProtoInstance)node).instanceNode();
                }
                node.registerUse(this.loader.scene);
                return node;
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void ProtoStatement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.ProtoDefinition();
                break;
            }
            case 25: {
                this.ExternProtoDefinition();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ProtoDefinition() throws ParseException {
        this.jj_consume_token(20);
        Proto proto = this.ProtoFromName();
        this.ProtoInterface(proto);
        this.jj_consume_token(10);
        this.ProtoBody(proto);
        this.jj_consume_token(11);
        this.loader.endProtoDefine();
    }

    public final Proto ProtoFromName() throws ParseException {
        String protoName = this.NodeNameId();
        Proto proto = new Proto(this.loader, protoName);
        this.loader.beginProtoDefine(proto);
        return proto;
    }

    public final void ProtoInterface(Proto proto) throws ParseException {
        this.jj_consume_token(12);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.ProtoInterface_fields(proto);
        }
        this.jj_consume_token(13);
    }

    public final void ProtoInterface_fields(Proto proto) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                this.ProtoEventIn(proto);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                this.ProtoField(proto);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                this.ProtoEventOut(proto);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                this.ProtoExposedField(proto);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ProtoEventIn(Proto proto) throws ParseException {
        Field field = this.genEvent();
        String name = this.EventInId();
        proto.setEventIn(name, field);
    }

    public final void ProtoField(Proto proto) throws ParseException {
        Field f = this.genField();
        proto.setField(f.fieldName, f);
    }

    public final void ProtoEventOut(Proto proto) throws ParseException {
        Field field = this.genEvent();
        String name = this.EventOutId();
        proto.setEventOut(name, field);
    }

    public final void ProtoExposedField(Proto proto) throws ParseException {
        Field f = this.genField();
        proto.setExposedField(f.fieldName, f);
    }

    public final void ProtoBody(Proto proto) throws ParseException {
        Object node = null;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: 
                case 19: 
                case 20: 
                case 25: 
                case 26: 
                case 50: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.Statement();
        }
    }

    public final void ExternProtoDefinition() throws ParseException {
        Vector protoFields = new Vector();
        Vector urlList = new Vector();
        this.jj_consume_token(25);
        String protoName = this.NodeTypeId();
        this.jj_consume_token(12);
        block8: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: 
                case 22: 
                case 23: 
                case 24: {
                    break;
                }
                default: {
                    break block8;
                }
            }
            this.ExternProtoInterface(protoFields);
        }
        this.jj_consume_token(13);
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            this.ExternProtoURL(urlList);
        }
        boolean found = false;
        int size = urlList.size();
        Exception lastException = null;
        for (int i = 0; !found && i < size; ++i) {
            try {
                String urlString = (String)urlList.elementAt(i);
                this.loader.loadProto(urlString, protoName, protoFields);
                found = true;
                continue;
            }
            catch (Exception e) {
                if (e instanceof ParseException) {
                    throw (ParseException)e;
                }
                lastException = e;
            }
        }
        if (!found && lastException != null) {
            if (this.loader.debug) {
                System.err.println("Exception reading EXTERNPROTO:");
                lastException.printStackTrace(System.err);
            }
            throw new ParseException("Exception " + lastException + " loading EXTERNPROTO");
        }
    }

    public final void ExternProtoInterface(Vector protoFields) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                String name;
                this.jj_consume_token(21);
                Field f = this.genEvent();
                f.fieldName = name = this.EventInId();
                protoFields.add(f);
                break;
            }
            case 23: {
                String name;
                this.jj_consume_token(23);
                Field f = this.genEvent();
                f.fieldName = name = this.FieldId();
                protoFields.add(f);
                break;
            }
            case 22: {
                String name;
                this.jj_consume_token(22);
                Field f = this.genEvent();
                f.fieldName = name = this.EventOutId();
                protoFields.add(f);
                break;
            }
            case 24: {
                String name;
                this.jj_consume_token(24);
                Field f = this.genEvent();
                f.fieldName = name = this.FieldId();
                protoFields.add(f);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ExternProtoURL(Vector urlList) throws ParseException {
        String url = this.String();
        urlList.add(url);
    }

    public final void RouteStatement() throws ParseException {
        this.jj_consume_token(26);
        String fromName = this.NodeNameId();
        this.jj_consume_token(30);
        String fromField = this.EventOutId();
        this.jj_consume_token(27);
        String toName = this.NodeNameId();
        this.jj_consume_token(30);
        String toField = this.EventInId();
        BaseNode fromNode = this.loader.namespaceUse(fromName);
        BaseNode toNode = this.loader.namespaceUse(toName);
        if (fromNode == null || toNode == null) {
            throw new ParseException("To or From node on ROUTE not DEF'd");
        }
        this.loader.addRoute(fromNode, fromField, toNode, toField);
    }

    public final BaseNode Node() throws ParseException {
        String nodeTypeId = this.NodeTypeId();
        BaseNode node = nodeTypeId.equals("Script") ? this.Script() : this.NodeBody(nodeTypeId);
        if (this.loader.curProto == null) {
            if (this.loader.timing) {
                double start = Time.getNow();
                node.initImpl();
                double elapsed = Time.getNow() - start;
                this.loader.nodeInitImpl += elapsed;
                if (node instanceof IndexedFaceSet) {
                    this.loader.ifsInit += elapsed;
                    ++this.loader.numIfs;
                }
                if (node instanceof GroupBase) {
                    ++this.loader.numGroups;
                }
            } else {
                node.initImpl();
            }
        }
        if (this.loader.parserMarks) {
            Token curToken = this.getToken(0);
            if (curToken.beginLine > this.lastLine + 1000) {
                this.lastLine = curToken.beginLine;
                this.lastLine -= this.lastLine % 1000;
                System.out.println("Parser is at about line " + this.lastLine);
            }
        }
        return node;
    }

    public final Node NodeBody(String nodeTypeId) throws ParseException {
        Node node = null;
        Constructor nodeConstructor = this.vrmlNodeConstructor(nodeTypeId);
        if (nodeConstructor != null) {
            try {
                node = (Node)nodeConstructor.newInstance(this.loaderParam);
            }
            catch (Exception e) {
                System.out.println("vrml97 Loader: error in constructor for " + nodeTypeId + ": " + e);
                if (e instanceof InvocationTargetException) {
                    System.out.println(((InvocationTargetException)e).getTargetException());
                    e.printStackTrace();
                }
            }
        } else {
            Proto proto = this.loader.lookupProto(nodeTypeId);
            if (proto != null) {
                ProtoInstance instance = proto.instance();
                if (this.loader.debug && this.loader.browser != null) {
                    this.loader.browser.routePrinter.printRoutes(instance);
                }
                node = instance;
            } else {
                throw new ParseException("Unknown node type: " + nodeTypeId);
            }
        }
        this.jj_consume_token(10);
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: 
                case 25: 
                case 26: 
                case 50: {
                    break;
                }
                default: {
                    break block5;
                }
            }
            this.NodeBodyElement(node);
        }
        this.jj_consume_token(11);
        return node;
    }

    public final void NodeBodyElement(BaseNode node) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 50: {
                this.FieldStatement(node);
                break;
            }
            case 26: {
                this.RouteStatement();
                break;
            }
            case 20: 
            case 25: {
                this.ProtoStatement();
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Field FieldFromId(BaseNode node) throws ParseException {
        String fieldName = this.FieldId();
        Field field = node.getField(fieldName);
        return field;
    }

    public final void FieldStatement(BaseNode node) throws ParseException {
        Field field = this.FieldFromId(node);
        this.FieldInit(field);
    }

    public final void FieldInit(Field field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.IsField(field);
                break;
            }
            default: {
                this.FieldValue(field);
            }
        }
    }

    public final void IsField(Field toField) throws ParseException {
        this.jj_consume_token(29);
        String fieldName = this.FieldId();
        Proto proto = this.loader.curProto();
        if (proto != null) {
            if (!proto.setupIsMap(toField, fieldName)) {
                throw new ParseException("Error setting up IS map in PROTO");
            }
        } else {
            throw new ParseException("IS statement outside PROTO");
        }
    }

    public final void FieldValue(Field field) throws ParseException {
        Integer fieldTypeCode = (Integer)this.fieldTypeCodes.get(field.getClass());
        if (fieldTypeCode == null) {
            throw new ParseException("Parser Error: unexpected field type");
        }
        switch (fieldTypeCode) {
            case 31: {
                this._SFBool((SFBool)field);
                break;
            }
            case 32: {
                this._SFColor((SFColor)field);
                break;
            }
            case 33: {
                this._SFFloat((SFFloat)field);
                break;
            }
            case 34: {
                this._SFInt32((SFInt32)field);
                break;
            }
            case 35: {
                this._SFNode((SFNode)field);
                break;
            }
            case 36: {
                this._SFRotation((SFRotation)field);
                break;
            }
            case 37: {
                this._SFString((SFString)field);
                break;
            }
            case 38: {
                this._SFTime((SFTime)field);
                break;
            }
            case 39: {
                this._SFVec2f((SFVec2f)field);
                break;
            }
            case 40: {
                this._SFVec3f((SFVec3f)field);
                break;
            }
            case 41: {
                this._MFColor((MFColor)field);
                break;
            }
            case 42: {
                this._MFFloat((MFFloat)field);
                break;
            }
            case 43: {
                this._MFInt32((MFInt32)field);
                break;
            }
            case 44: {
                this._MFNode((MFNode)field);
                break;
            }
            case 45: {
                this._MFRotation((MFRotation)field);
                break;
            }
            case 46: {
                this._MFString((MFString)field);
                break;
            }
            case 47: {
                this._MFTime((MFTime)field);
                break;
            }
            case 48: {
                this._MFVec2f((MFVec2f)field);
                break;
            }
            case 49: {
                this._MFVec3f((MFVec3f)field);
                break;
            }
            default: {
                throw new ParseException("Internal error: Field type " + field.getClass() + " not found");
            }
        }
        field.route();
    }

    public final Script Script() throws ParseException {
        Script script = new Script(this.loader);
        this.jj_consume_token(10);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 25: 
                case 26: 
                case 50: {
                    break;
                }
                default: {
                    break block3;
                }
            }
            this.ScriptBodyElement(script);
        }
        this.jj_consume_token(11);
        return script;
    }

    public final void ScriptBodyElement(Script script) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                this.ScriptEventIn(script);
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                this.ScriptEventOut(script);
                break;
            }
            case 23: {
                this.jj_consume_token(23);
                this.ScriptField(script);
                break;
            }
            case 20: 
            case 25: 
            case 26: 
            case 50: {
                this.NodeBodyElement(script);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ScriptEventIn(Script s) throws ParseException {
        Field f = this.genEvent();
        String name = this.EventInId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.IsField(f);
                break;
            }
        }
        s.setEventIn(name, f);
    }

    public final void ScriptField(Script s) throws ParseException {
        Field f = this.genField();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.IsField(f);
                break;
            }
        }
        s.setField(f.fieldName, f);
    }

    public final void ScriptEventOut(Script s) throws ParseException {
        Field f = this.genEvent();
        String name = this.EventOutId();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.IsField(f);
                break;
            }
        }
        s.setEventOut(name, f);
    }

    public final Field genEvent() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                SFBool field = new SFBool(false);
                return field;
            }
            case 32: {
                this.jj_consume_token(32);
                SFColor field = new SFColor(0.0f, 1.0f, 0.0f);
                return field;
            }
            case 33: {
                this.jj_consume_token(33);
                SFFloat field = new SFFloat(0.0f);
                return field;
            }
            case 34: {
                this.jj_consume_token(34);
                SFInt32 field = new SFInt32(0);
                return field;
            }
            case 35: {
                this.jj_consume_token(35);
                SFNode field = new SFNode();
                return field;
            }
            case 36: {
                this.jj_consume_token(36);
                SFRotation field = new SFRotation();
                return field;
            }
            case 37: {
                this.jj_consume_token(37);
                SFString field = new SFString();
                return field;
            }
            case 38: {
                this.jj_consume_token(38);
                SFTime field = new SFTime();
                return field;
            }
            case 39: {
                this.jj_consume_token(39);
                SFVec2f field = new SFVec2f();
                return field;
            }
            case 40: {
                this.jj_consume_token(40);
                SFVec3f field = new SFVec3f();
                return field;
            }
            case 41: {
                this.jj_consume_token(41);
                MFColor field = new MFColor();
                return field;
            }
            case 42: {
                this.jj_consume_token(42);
                MFFloat field = new MFFloat();
                return field;
            }
            case 43: {
                this.jj_consume_token(43);
                MFInt32 field = new MFInt32();
                return field;
            }
            case 44: {
                this.jj_consume_token(44);
                MFNode field = new MFNode();
                return field;
            }
            case 45: {
                this.jj_consume_token(45);
                MFRotation field = new MFRotation();
                return field;
            }
            case 46: {
                this.jj_consume_token(46);
                MFString field = new MFString();
                return field;
            }
            case 47: {
                this.jj_consume_token(47);
                MFTime field = new MFTime();
                return field;
            }
            case 48: {
                this.jj_consume_token(48);
                MFVec2f field = new MFVec2f();
                return field;
            }
            case 49: {
                this.jj_consume_token(49);
                MFVec3f field = new MFVec3f();
                return field;
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Field genField() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 31: {
                this.jj_consume_token(31);
                String name = this.FieldId();
                SFBool field = new SFBool(false);
                field.fieldName = name;
                this._SFBool(field);
                return field;
            }
            case 32: {
                this.jj_consume_token(32);
                String name = this.FieldId();
                SFColor field = new SFColor(0.0f, 1.0f, 0.0f);
                field.fieldName = name;
                this._SFColor(field);
                return field;
            }
            case 33: {
                this.jj_consume_token(33);
                String name = this.FieldId();
                SFFloat field = new SFFloat(0.0f);
                field.fieldName = name;
                this._SFFloat(field);
                return field;
            }
            case 34: {
                this.jj_consume_token(34);
                String name = this.FieldId();
                SFInt32 field = new SFInt32(0);
                field.fieldName = name;
                this._SFInt32(field);
                return field;
            }
            case 35: {
                this.jj_consume_token(35);
                String name = this.FieldId();
                SFNode field = new SFNode();
                field.fieldName = name;
                this._SFNode(field);
                return field;
            }
            case 36: {
                this.jj_consume_token(36);
                String name = this.FieldId();
                SFRotation field = new SFRotation();
                field.fieldName = name;
                this._SFRotation(field);
                return field;
            }
            case 37: {
                this.jj_consume_token(37);
                String name = this.FieldId();
                SFString field = new SFString();
                field.fieldName = name;
                this._SFString(field);
                return field;
            }
            case 38: {
                this.jj_consume_token(38);
                String name = this.FieldId();
                SFTime field = new SFTime();
                field.fieldName = name;
                this._SFTime(field);
                return field;
            }
            case 39: {
                this.jj_consume_token(39);
                String name = this.FieldId();
                SFVec2f field = new SFVec2f();
                field.fieldName = name;
                this._SFVec2f(field);
                return field;
            }
            case 40: {
                this.jj_consume_token(40);
                String name = this.FieldId();
                SFVec3f field = new SFVec3f();
                field.fieldName = name;
                this._SFVec3f(field);
                return field;
            }
            case 41: {
                this.jj_consume_token(41);
                String name = this.FieldId();
                MFColor field = new MFColor();
                field.fieldName = name;
                this._MFColor(field);
                return field;
            }
            case 42: {
                this.jj_consume_token(42);
                String name = this.FieldId();
                MFFloat field = new MFFloat();
                field.fieldName = name;
                this._MFFloat(field);
                return field;
            }
            case 43: {
                this.jj_consume_token(43);
                String name = this.FieldId();
                MFInt32 field = new MFInt32();
                field.fieldName = name;
                this._MFInt32(field);
                return field;
            }
            case 44: {
                this.jj_consume_token(44);
                String name = this.FieldId();
                MFNode field = new MFNode();
                field.fieldName = name;
                this._MFNode(field);
                return field;
            }
            case 45: {
                this.jj_consume_token(45);
                String name = this.FieldId();
                MFRotation field = new MFRotation();
                field.fieldName = name;
                this._MFRotation(field);
                return field;
            }
            case 46: {
                this.jj_consume_token(46);
                String name = this.FieldId();
                MFString field = new MFString();
                field.fieldName = name;
                this._MFString(field);
                return field;
            }
            case 47: {
                this.jj_consume_token(47);
                String name = this.FieldId();
                MFTime field = new MFTime();
                field.fieldName = name;
                this._MFTime(field);
                return field;
            }
            case 48: {
                this.jj_consume_token(48);
                String name = this.FieldId();
                MFVec2f field = new MFVec2f();
                field.fieldName = name;
                this._MFVec2f(field);
                return field;
            }
            case 49: {
                this.jj_consume_token(49);
                String name = this.FieldId();
                MFVec3f field = new MFVec3f();
                field.fieldName = name;
                this._MFVec3f(field);
                return field;
            }
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String NodeNameId() throws ParseException {
        String id = this.Id();
        return id;
    }

    public final String NodeTypeId() throws ParseException {
        String id = this.Id();
        return id;
    }

    public final String FieldId() throws ParseException {
        String id = this.Id();
        return id;
    }

    public final String EventOutId() throws ParseException {
        String id = this.Id();
        return id;
    }

    public final String EventInId() throws ParseException {
        String id = this.Id();
        return id;
    }

    public final String Id() throws ParseException {
        this.jj_consume_token(50);
        return new String(this.token.image);
    }

    public final String String() throws ParseException {
        this.jj_consume_token(9);
        return this.token.image.substring(1, this.token.image.length() - 1);
    }

    public final void MultString(Vector stringVec) throws ParseException {
        this.jj_consume_token(9);
        stringVec.addElement(new String(this.token.image.substring(1, this.token.image.length() - 1)));
    }

    public final int IntegerVal() throws ParseException {
        this.jj_consume_token(8);
        try {
            return Integer.parseInt(this.token.image);
        }
        catch (NumberFormatException ee) {
            throw new ParseException("Can't parse integer");
        }
    }

    public final float FloatVal() throws ParseException {
        this.jj_consume_token(8);
        try {
            return Float.parseFloat(this.token.image);
        }
        catch (NumberFormatException ee) {
            throw new ParseException("Can't parse float");
        }
    }

    public final double DoubleVal() throws ParseException {
        this.jj_consume_token(8);
        try {
            return Double.parseDouble(this.token.image);
        }
        catch (NumberFormatException ee) {
            throw new ParseException("Can't parse double");
        }
    }

    public final void MultIntegerVal() throws ParseException {
        int val = this.IntegerVal();
        this.loader.intBuf.add(val);
    }

    public final void MultFloatVal() throws ParseException {
        float val = this.FloatVal();
        this.loader.floatBuf.add(val);
    }

    public final void MultDoubleVal() throws ParseException {
        double val = this.DoubleVal();
        this.loader.doubleBuf.add(val);
    }

    public final void _MultNode(Vector nodeVec) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 19: 
            case 50: {
                BaseNode val = this.NodeStatement();
                nodeVec.addElement(val);
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                nodeVec.addElement(null);
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _SFString(SFString field) throws ParseException {
        field.string = this.String();
    }

    public final void _MFString(MFString field) throws ParseException {
        Vector stringVec = new Vector();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                String val = this.String();
                String[] strings = new String[]{val};
                field.strings = strings;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 9: {
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    this.MultString(stringVec);
                }
                this.jj_consume_token(13);
                Object[] strings = new String[stringVec.size()];
                stringVec.copyInto(strings);
                field.strings = strings;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _SFBool(SFBool field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                field.value = true;
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                field.value = true;
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                field.value = false;
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                field.value = false;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _SFInt32(SFInt32 field) throws ParseException {
        field.value = this.IntegerVal();
    }

    public final void _SFFloat(SFFloat field) throws ParseException {
        field.value = this.FloatVal();
    }

    public final void _SFTime(SFTime field) throws ParseException {
        field.time = this.FloatVal();
    }

    public final void _SFRotation(SFRotation field) throws ParseException {
        float[] vec = new float[]{this.FloatVal(), this.FloatVal(), this.FloatVal(), this.FloatVal()};
        field.rot = vec;
    }

    public final void _SFVec2f(SFVec2f field) throws ParseException {
        float[] vec = new float[]{this.FloatVal(), this.FloatVal()};
        field.vec2f = vec;
    }

    public final void _SFVec3f(SFVec3f field) throws ParseException {
        float[] vec = new float[]{this.FloatVal(), this.FloatVal(), this.FloatVal()};
        field.value = vec;
    }

    public final void _SFColor(SFColor field) throws ParseException {
        float[] color = new float[]{this.FloatVal(), this.FloatVal(), this.FloatVal()};
        field.color = color;
    }

    public final void _MFFloat(MFFloat field) throws ParseException {
        double start = 0.0;
        this.loader.floatBuf.reset();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                float val = this.FloatVal();
                float[] values = new float[]{val};
                field.mfloat = values;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    this.MultFloatVal();
                }
                this.jj_consume_token(13);
                float[] values = new float[this.loader.floatBuf.size];
                System.arraycopy(this.loader.floatBuf.array, 0, values, 0, this.loader.floatBuf.size);
                field.mfloat = values;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _MFTime(MFTime field) throws ParseException {
        this.loader.doubleBuf.reset();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                double val = this.DoubleVal();
                double[] values = new double[]{val};
                field.time = values;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    this.MultDoubleVal();
                }
                this.jj_consume_token(13);
                double[] values = new double[this.loader.doubleBuf.size];
                System.arraycopy(this.loader.doubleBuf.array, 0, values, 0, this.loader.doubleBuf.size);
                field.time = values;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _MFVec2f(MFVec2f field) throws ParseException {
        double start = 0.0;
        this.loader.floatBuf.reset();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                float x = this.FloatVal();
                float y = this.FloatVal();
                float[] values = new float[]{x, y};
                field.vals = values;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    this.MultFloatVal();
                }
                this.jj_consume_token(13);
                int numVecs = this.loader.floatBuf.size / 2;
                float[] values = new float[numVecs * 2];
                System.arraycopy(this.loader.floatBuf.array, 0, values, 0, numVecs * 2);
                field.vals = values;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _MFVec3f(MFVec3f field) throws ParseException {
        double start = 0.0;
        if (this.loader.timing) {
            start = Time.getNow();
        }
        this.loader.floatBuf.reset();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                float x = this.FloatVal();
                float y = this.FloatVal();
                float z = this.FloatVal();
                field.checkSize(3, false);
                field.size = 3;
                field.value[0] = x;
                field.value[1] = y;
                field.value[2] = z;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    this.MultFloatVal();
                }
                this.jj_consume_token(13);
                if (this.loader.timing) {
                    double now = Time.getNow();
                    this.loader.MFVec3fParse += now - start;
                    start = now;
                }
                int numVecs = this.loader.floatBuf.size / 3;
                field.checkSize(numVecs * 3, false);
                System.arraycopy(this.loader.floatBuf.array, 0, field.value, 0, numVecs * 3);
                field.size = numVecs * 3;
                if (!this.loader.timing) break;
                this.loader.MFVec3fCopy += Time.getNow() - start;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _MFRotation(MFRotation field) throws ParseException {
        double start = 0.0;
        this.loader.floatBuf.reset();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                float x = this.FloatVal();
                float y = this.FloatVal();
                float z = this.FloatVal();
                float angle = this.FloatVal();
                SFRotation[] values = new SFRotation[]{new SFRotation(x, y, z, angle)};
                field.rots = values;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    this.MultFloatVal();
                }
                this.jj_consume_token(13);
                int numRots = this.loader.floatBuf.size / 4;
                SFRotation[] values = new SFRotation[numRots];
                for (int i = 0; i < numRots; ++i) {
                    float x = this.loader.floatBuf.array[i * 4 + 0];
                    float y = this.loader.floatBuf.array[i * 4 + 1];
                    float z = this.loader.floatBuf.array[i * 4 + 2];
                    float angle = this.loader.floatBuf.array[i * 4 + 3];
                    values[i] = new SFRotation(x, y, z, angle);
                }
                field.rots = values;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _MFColor(MFColor field) throws ParseException {
        double start = 0.0;
        this.loader.floatBuf.reset();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                float r = this.FloatVal();
                float g = this.FloatVal();
                float b = this.FloatVal();
                float[] values = new float[]{r, g, b};
                field.vals = values;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    this.MultFloatVal();
                }
                this.jj_consume_token(13);
                int numVecs = this.loader.floatBuf.size / 3;
                float[] values = new float[numVecs * 3];
                System.arraycopy(this.loader.floatBuf.array, 0, values, 0, numVecs * 3);
                field.vals = values;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _MFInt32(MFInt32 field) throws ParseException {
        double start = 0.0;
        if (this.loader.timing) {
            start = Time.getNow();
        }
        this.loader.intBuf.reset();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                int val = this.IntegerVal();
                field.checkSize(1, false);
                field.value[0] = val;
                field.size = 1;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            break block7;
                        }
                    }
                    this.MultIntegerVal();
                }
                this.jj_consume_token(13);
                if (this.loader.intBuf.size <= 0) break;
                if (this.loader.timing) {
                    double now = Time.getNow();
                    this.loader.MFInt32Parse += now - start;
                    start = now;
                }
                field.checkSize(this.loader.intBuf.size, false);
                field.size = this.loader.intBuf.size;
                System.arraycopy(this.loader.intBuf.array, 0, field.value, 0, this.loader.intBuf.size);
                this.loader.intBuf.reset();
                if (!this.loader.timing) break;
                this.loader.MFInt32Copy += Time.getNow() - start;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _SFNode(SFNode field) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: 
            case 19: 
            case 50: {
                field.node = this.NodeStatement();
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                field.node = null;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void _MFNode(MFNode field) throws ParseException {
        Vector nodeVec = new Vector();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                field.nodes = new BaseNode[0];
                break;
            }
            case 18: 
            case 19: 
            case 50: {
                BaseNode single = this.NodeStatement();
                BaseNode[] values = new BaseNode[]{single};
                field.nodes = values;
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                block8: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 18: 
                        case 19: 
                        case 28: 
                        case 50: {
                            break;
                        }
                        default: {
                            break block8;
                        }
                    }
                    this._MultNode(nodeVec);
                }
                this.jj_consume_token(13);
                BaseNode[] values = new BaseNode[nodeVec.size()];
                for (int i = 0; i < nodeVec.size(); ++i) {
                    values[i] = (BaseNode)nodeVec.elementAt(i);
                }
                field.nodes = values;
                break;
            }
            default: {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public Parser(InputStream stream) {
        this.jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public Parser(Reader stream) {
        this.jj_input_stream = new ASCII_CharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public Parser(ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    public void ReInit(ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            return this.token;
        }
        this.token = oldToken;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        Token errortok = this.token.next;
        int line = errortok.beginLine;
        int column = errortok.beginColumn;
        String mess = errortok.kind == 0 ? tokenImage[0] : errortok.image;
        return new ParseException("Parse error at line " + line + ", column " + column + ".  Encountered: " + mess);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

