package jp.sourceforge.acerola3d.a3.bvh;

import java.net.*;
import javax.media.j3d.*;

import jp.sourceforge.acerola3d.a3.Motion;

/**
 * BVH(BioVision Hierarchical data)のモーションキャプチャデータから
 * 生成されるAction3DのためのMotionデータです。
 */
public class BVH implements Motion {
    ParserBVH parser;

    /**
     * URLで指定したファイルからBVHのインスタンスを生成するコンストラクタ。
     */
    public BVH(URL url) throws Exception {
        parser = new ParserBVH(url);
    }

    /**
     * 秒単位でモーションの長さを返します。
     */
    public double getMotionLength() {
        return parser.getMotionLength();
    }

    /**
     * デフォルトのフレームタイムを返します。
     */
    public double getDefaultFrameTime() {
        return parser.getDefaultFrameTime();
    }

    /**
     * rootのBoneの名前を返します。
     */
    public String getRootBone() {
        return parser.getRootBone();
    }

    /**
     * 指定されたBoneに接続されている子のBoneの名前を
     * 文字列の配列で返します。
     */
    public String[] getChildBones(String b) {
        return parser.getChildBones(b);
    }

    /**
     * 指定された骨と時間における座標変換を返します。
     */
    public Transform3D getTransform3D(String bone,double time) {
        return parser.getTransform3D(bone,time);
    }
}
