import jp.sourceforge.acerola3d.a3.*;
import java.awt.*;
import java.awt.event.*;

/*
 * LightWeightでBalloon(ふきだし)とlabelと選択印のテスト。
 */
public class JA3BalloonTest {
    public static void main(String args[]) throws Exception {
        JA3Window w = new JA3Window(300,300);

        Action3D a3 = Action3D.load("x-res:///axis.a3");
        a3.setBalloonLoc(A3Object.BalloonDir.RIGHT,0.5,0.5);
        a3.setBalloon("Balloon:どうよ、日本語。");
        a3.setLabel("axis");
        a3.setSelected(true);
        w.add(a3);
        w.setCameraLocImmediately(0.0,0.0,5.0);
        int t=0;
        while (true) {
            double theta = ((double)t)/10.0;
            try{Thread.sleep(100);}catch(Exception e){;}
            a3.setLoc(Math.cos(theta),Math.sin(theta),0.0);
            t=t+1;
            if (t==30) {
                a3.setBalloon("途中でballoonの内容を変更してみる");
                a3.setLabel(null);
                a3.setSelected(false);
            } else if(t==70) {
                a3.setBalloon(null);
            } else if (t==100) {
                a3.setBalloon("消してからまた付けてみた");
                a3.setLabel("axis");
                a3.setSelected(true);
            } else if (t==140) {
                a3.setBalloon("ながーい文章だとどうなるかのチェック、10文字ごとに改行する簡単な方法で表示してるので英語の場合はちょっと変になる。This is a case of English.");
            }
        }
    }
}
