import jp.sourceforge.acerola3d.a3.*;
import jp.sourceforge.acerola3d.a3.bvh.*;

public class MotionCameraControllerTest {
    public static void main(String args[]) throws Exception {
        A3Window w = new A3Window(300,300);
        Action3D a3_1 = new Action3D("x-res:///axis.a3");
        a3_1.setLoc(0.0,1.0,0.0);
        w.add(a3_1);
        Action3D a3_2 = new Action3D("x-res:///measure.a3");
        a3_2.setRot(Math.PI/2.0,0.0,0.0);
        w.add(a3_2);
        BVH bvh = new BVH("x-res:///cameraMotion.bvh");
        MotionCameraController mcc = new MotionCameraController(bvh,"Bone.002");
        w.setA3Controller(mcc);
        mcc.cue();
        try{Thread.sleep(10000);}catch(Exception e){;}
        System.out.println("debug1");
        mcc.changeMotion(bvh);
        mcc.setLoop(true);
        mcc.cue();
        try{Thread.sleep(15000);}catch(Exception e){;}
        System.out.println("debug2");
        mcc.setLoop(false);
        mcc.reset();
        mcc.cue();
    }
}
