/*
 * Decompiled with CFR 0.152.
 */
package org.sablecc.ant.taskdef;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.sablecc.sablecc.SableCC;

public class Sablecc
extends MatchingTask {
    private File srcDir;
    private File destDir;

    private void doSableccCompile(String[] stringArray) {
        ((Task)this).project.log("Using now SableCC parser generator...", 3);
        int n = 0;
        while (n < stringArray.length) {
            StringWriter stringWriter;
            ((Task)this).project.log("SableCC processing grammar: " + stringArray[n], 3);
            try {
                SableCC.processGrammar(String.valueOf(String.valueOf(this.srcDir)) + System.getProperty("file.separator") + stringArray[n], this.destDir.getAbsolutePath());
            }
            catch (Exception exception) {
                ((Task)this).project.log("SableCC failed.\n" + exception.getMessage(), 0);
                stringWriter = new StringWriter();
                exception.printStackTrace(new PrintWriter(stringWriter));
                ((Task)this).project.log("Exception thrown was:\n" + stringWriter.toString(), 3);
                return;
            }
            catch (Throwable throwable) {
                ((Task)this).project.log("SableCC failed.\n" + throwable.getMessage(), 0);
                stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stringWriter));
                ((Task)this).project.log("Exception thrown was:\n" + stringWriter.toString(), 3);
            }
            ++n;
        }
        ((Task)this).project.log("Using SableCC parser generator finished succesfully!", 3);
    }

    public void execute() throws BuildException {
        if (this.srcDir == null || this.destDir == null) {
            throw new BuildException("srcDir and destDir attributes must be set!");
        }
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        if (stringArray.length > 0) {
            ((Task)this).project.log("Compiling with SableCC " + stringArray.length + " source grammar files to " + this.destDir, 2);
            this.doSableccCompile(stringArray);
        }
    }

    public void setOutputDirectory(String string) {
        this.destDir = ((Task)this).project.resolveFile(string);
    }

    public void setSrc(String string) {
        this.srcDir = ((Task)this).project.resolveFile(string);
    }
}

