import jp.sourceforge.acerola3d.a3.*;

public class SkeletonTest {
    public static void main(String args[]) throws Exception {
        A3Window w = new A3Window(300,300);
        w.setNavigationMode(A3CanvasInterface.NaviMode.EXAMINE);
        Skeleton s = new Skeleton("x-rzip:x-res:///vesma9.a3!/Walk.bvh");

        System.out.println("Bone info.");
        printBoneInfo(s.getRootBone(),s,0);
        System.out.println("face offset");
        System.out.println(s.getOffset("R_foot").toString());

        s.setScale(0.05);
        s.setRot(0.0,-0.3,0.0);
        w.add(s);
        try{Thread.sleep(5000);}catch(Exception e){;}
        s.setBoneSelected("face",true);
        s.start();
        try{Thread.sleep(5000);}catch(Exception e){;}
        s.pause();
        try{Thread.sleep(1000);}catch(Exception e){;}
        s.setPauseTime(0.3);
        try{Thread.sleep(1000);}catch(Exception e){;}
        s.setPauseTime(0.6);
        try{Thread.sleep(1000);}catch(Exception e){;}
        s.start();
        try{Thread.sleep(1000);}catch(Exception e){;}
        s.setBoneSelected("face",false);
        s.defaultPose();
    }
    static void printBoneInfo(String boneName,Skeleton s,int level) {
        for (int i=0;i<level;i++)
            System.out.print("    ");
        System.out.println(boneName);
        String children[] = s.getChildBones(boneName);
        for (int i=0;i<children.length;i++)
            printBoneInfo(children[i],s,level+1);
    }
}
