/*
 * Created on 2004/08/14
 *
 * んー．まだ色々な点できちんと作られてないので，
 * 改良したほうが良いかもしれない．java.net.URLConnectionのAPIを
 * 良く読むべし．
 */
package jp.sourceforge.acerola3d;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class RZipURLConnection extends URLConnection {
    String internalURL = null;
    String entryName = null;
    int size = -1;
    InputStream inputStream = null;

    public RZipURLConnection(URL url) {
        super(url);
        String urlString = url. toExternalForm();
        entryName = urlString.substring(urlString.lastIndexOf('!')+1);
        internalURL = urlString.substring(0,urlString.lastIndexOf('!'));
        internalURL = internalURL.substring(7);
        internalURL = checkInternalURL(internalURL);

        //たぶんj3d-vrml97.jarの仕業だと思うのだけど，
        //x-res:///の部分をx-res://に書換えてしまうようなので，
        //以下のフィックスを入れておく
        if (internalURL.startsWith("x-res://") && !internalURL.startsWith("x-res:///"))
            internalURL="x-res:///"+internalURL.substring(8);
        //if (internalURL.startsWith("x-res:/") && !internalURL.startsWith("x-res://"))
        //    internalURL="x-res:///"+internalURL.substring(7);
        
    }
    public void connect() throws IOException {
        InputStream is = new URL(internalURL).openStream();
        ZipInputStream zis = new ZipInputStream(is);
        if (entryName.startsWith("/"))
            entryName = entryName.substring(1);
        while (true) {
            ZipEntry ze = zis.getNextEntry();
            if (ze == null)
                throw new IOException();
            if (!ze.getName().equals(entryName))
                continue;
            BufferedInputStream bis = new BufferedInputStream(zis);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(baos);
            int len;
            byte buf[] = new byte[1024];
            while((len=bis.read(buf))!=-1) {
                bos.write(buf,0,len);
            }
            bos.flush();
            bos.close();
            bis.close();
            byte b[] = baos.toByteArray();
            size = b.length;
            inputStream = new BufferedInputStream(new ByteArrayInputStream(b));
            connected = true;
            return;
        }
    }
    public int getContentLength() {
        try {
            if (!connected)
                connect();
        } catch(IOException e) {
            ;
        }
        return size;
    }
    public InputStream getInputStream() throws IOException {
        if (!connected)
            connect();
        if (inputStream==null)
            throw new IOException();
        return inputStream;
    }

    //j3d-vrml97.jarを使うと、どっかのだれかが「file:///home...」を「file://home...」
    //に書き換えてしまう。むりやりなおしてしまうことにする。
    String checkInternalURL(String s) {
        if (s.startsWith("file://")&&(!s.startsWith("file:///")))
            return "file:///"+s.substring(7);
        else
            return s;
    }
}
