package jp.sourceforge.acerola3d.a3;

import java.util.*;
import javax.media.j3d.*;
import javax.vecmath.*;

class A3Behavior extends Behavior {
    static long elapsedTime = 100l;
    A3Object a3 = null;
    A3BranchGroup topGroup;
    TransformGroup transGroup;
    Transform3D t;
    A3VirtualUniverse universe = null;
    boolean isInterpolate = false;
    boolean autoDirectionControl = false;
    boolean billboardControl = false;
    double nextS = 1.0;
    Quat4d nextQ = new Quat4d(0.0,0.0,0.0,1.0);
    Vector3d nextV = new Vector3d();
    double nowS = 1.0;
    Quat4d nowQ = new Quat4d(0.0,0.0,0.0,1.0);
    Vector3d nowV = new Vector3d();
    boolean needRecalc = true;
    Vector3d nowTrans = new Vector3d();
    
    A3Behavior(A3Object a) {
        a3 = a;
        topGroup = new A3BranchGroup();
        topGroup.setA3(a3);
        t = new Transform3D();
        transGroup = new TransformGroup(t);
        transGroup.setCapability(TransformGroup.ALLOW_TRANSFORM_WRITE);
        transGroup.addChild(this);
        topGroup.addChild(transGroup);
    }
    void setA3VirtualUniverse(A3VirtualUniverse u) {
        universe = u;
    }
    void setNode(Node n) {
        transGroup.addChild(n);
    }
    void init() {
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
    }
    public void initialize() {
        WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
        wakeupOn(w);
    }
    Quat4d tmpQ = new Quat4d();
    static Quat4d tmpQQ = new Quat4d(1.0*Math.sin(Math.PI/4.0),0.0,0.0,Math.cos(Math.PI/4.0));
    @SuppressWarnings("unchecked")
    public void processStimulus(Enumeration criteria) {
        if (universe==null) {
            WakeupOnElapsedTime w = new WakeupOnElapsedTime(elapsedTime);
            wakeupOn(w);
        } else {
            WakeupOnBehaviorPost w = null;
            w = new WakeupOnBehaviorPost(universe.getTimerBehavior(),1);
            wakeupOn(w);
        }

        if (needRecalc==false)
            return;
        nowTrans.sub(nextV,nowV);
        nowTrans.scale(0.2);
        nowV.add(nowTrans);
        if (autoDirectionControl) {
            autoQuatControl();
        } else if (billboardControl) {
            billboardControl();
        } else {
            nowQ.normalize();
            nowQ.interpolate(nextQ,0.2);
            nowQ.normalize();
        }
        nowS = nowS + 0.2*(nextS - nowS);
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
        if (!isInterpolate) {
            needRecalc = false;
        }
    }
    void autoQuatControl() {
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                autoQuatControlZ();
                return;
            }
        }
        autoQuatControlY();
    }
    void autoQuatControlY() {
        Vector3d dv = new Vector3d(); 
        dv.sub(nextV,nowV);
        if (dv.length()>universe.scene.cameraNowS/1000.0) {
            Vector3d upperVector = new Vector3d(a3.upperVector);
            upperVector.normalize();

            Vector3d newFront = new Vector3d(dv);
            newFront.normalize();
            //なぜかm.get(nowQ)が上手くいかないときがある。
            //原因はよくわかってない。しょうがないので強引に
            //以下のif文を入れる。
            if ((Math.abs(newFront.x)<0.0001)&&(newFront.z<0.0)) {
                newFront.x=0.0001;
                newFront.normalize();
            }
            double d = newFront.dot(upperVector);
            Vector3d vTmp = new Vector3d(newFront);
            vTmp.scale(d);
            Vector3d newTop = new Vector3d(upperVector);
            newTop.sub(vTmp);
            if (newTop.lengthSquared()<0.00001) {
                //この場合とりあえず適当
                newFront.set(0.0,0.0,1.0);
                newTop.set(0.0,1.0,0.0);
            } else {
                newTop.normalize();
            }
            Vector3d newRight = new Vector3d();
            newRight.cross(newFront,newTop);

            Matrix4d m = new Matrix4d();
            m.m00 = -newRight.x;m.m01 = newTop.x;m.m02 = newFront.x;
            m.m10 = -newRight.y;m.m11 = newTop.y;m.m12 = newFront.y;
            m.m20 = -newRight.z;m.m21 = newTop.z;m.m22 = newFront.z;
            m.get(nowQ);
        }
    }
    void autoQuatControlZ() {
        Vector3d dv = new Vector3d(); 
        dv.sub(nextV,nowV);
        if (dv.length()>universe.scene.cameraNowS/1000.0) {
            Vector3d upperVector = new Vector3d(a3.upperVector);
            upperVector.normalize();

            Vector3d newFront = new Vector3d(dv);
            newFront.normalize();
            //なぜかm.get(nowQ)が上手くいかないときがある。
            //原因はよくわかってない。しょうがないので強引に
            //以下のif文を入れる。
            if ((Math.abs(newFront.x)<0.0001)&&(newFront.y>0.0)) {
                newFront.x=0.0001;
                newFront.normalize();
            }
            double d = newFront.dot(upperVector);
            Vector3d vTmp = new Vector3d(newFront);
            vTmp.scale(d);
            Vector3d newTop = new Vector3d(upperVector);
            newTop.sub(vTmp);
            if (newTop.lengthSquared()<0.00001) {
                //この場合とりあえず適当
                newFront.set(0.0,-1.0,0.0);
                newTop.set(0.0,0.0,1.0);
            } else {
                newTop.normalize();
            }
            Vector3d newRight = new Vector3d();
            newRight.cross(newFront,newTop);

            Matrix4d m = new Matrix4d();
            m.m00 = -newRight.x;m.m01 = -newFront.x;m.m02 = newTop.x;
            m.m10 = -newRight.y;m.m11 = -newFront.y;m.m12 = newTop.y;
            m.m20 = -newRight.z;m.m21 = -newFront.z;m.m22 = newTop.z;
            m.get(nowQ);
        }
    }
    void billboardControl() {
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                billboardControlZ();
                return;
            }
        }
        billboardControlY();
    }
    void billboardControlY() {
        Vector3d dv = new Vector3d(); 
        dv.sub(universe.scene.cameraNowV,nowV);
        if (dv.length()>universe.scene.cameraNowS/1000.0) {
            Vector3d upperVector = new Vector3d(a3.upperVector);
            upperVector.normalize();

            Vector3d newFront = new Vector3d(dv);
            newFront.normalize();
            //なぜかm.get(nowQ)が上手くいかないときがある。
            //原因はよくわかってない。しょうがないので強引に
            //以下のif文を入れる。
            if ((Math.abs(newFront.x)<0.0001)&&(newFront.z<0.0)) {
                newFront.x=0.0001;
                newFront.normalize();
            }
            double d = newFront.dot(upperVector);
            Vector3d vTmp = new Vector3d(newFront);
            vTmp.scale(d);
            Vector3d newTop = new Vector3d(upperVector);
            newTop.sub(vTmp);
            if (newTop.lengthSquared()<0.00001) {
                //この場合とりあえず適当
                newFront.set(0.0,0.0,1.0);
                newTop.set(0.0,1.0,0.0);
            } else {
                newTop.normalize();
            }
            Vector3d newRight = new Vector3d();
            newRight.cross(newFront,newTop);

            Matrix4d m = new Matrix4d();
            m.m00 = -newRight.x;m.m01 = newTop.x;m.m02 = newFront.x;
            m.m10 = -newRight.y;m.m11 = newTop.y;m.m12 = newFront.y;
            m.m20 = -newRight.z;m.m21 = newTop.z;m.m22 = newFront.z;
            m.get(nowQ);
        }
    }
    void billboardControlZ() {
        Vector3d dv = new Vector3d(); 
        dv.sub(universe.scene.cameraNowV,nowV);
        if (dv.length()>universe.scene.cameraNowS/1000.0) {
            Vector3d upperVector = new Vector3d(a3.upperVector);
            upperVector.normalize();

            Vector3d newFront = new Vector3d(dv);
            newFront.normalize();
            //なぜかm.get(nowQ)が上手くいかないときがある。
            //原因はよくわかってない。しょうがないので強引に
            //以下のif文を入れる。
            if ((Math.abs(newFront.x)<0.0001)&&(newFront.y>0.0)) {
                newFront.x=0.0001;
                newFront.normalize();
            }
            double d = newFront.dot(upperVector);
            Vector3d vTmp = new Vector3d(newFront);
            vTmp.scale(d);
            Vector3d newTop = new Vector3d(upperVector);
            newTop.sub(vTmp);
            if (newTop.lengthSquared()<0.00001) {
                //この場合とりあえず適当
                newFront.set(0.0,-1.0,0.0);
                newTop.set(0.0,0.0,1.0);
            } else {
                newTop.normalize();
            }
            Vector3d newRight = new Vector3d();
            newRight.cross(newFront,newTop);

            Matrix4d m = new Matrix4d();
            m.m00 = -newRight.x;m.m01 = -newFront.x;m.m02 = newTop.x;
            m.m10 = -newRight.y;m.m11 = -newFront.y;m.m12 = newTop.y;
            m.m20 = -newRight.z;m.m21 = -newFront.z;m.m22 = newTop.z;
            m.get(nowQ);
        }
    }
    void setEnableBehavior(boolean b) {
        isInterpolate = b;
    }
    void setAutoDirectionControl(boolean b) {
        autoDirectionControl = b;
        if (autoDirectionControl&&billboardControl)
            billboardControl=false;
    }
    void setBillboardControl(boolean b) {
        billboardControl = b;
        if (billboardControl&&autoDirectionControl)
            autoDirectionControl=false;
    }
    void move(Vector3d v, Quat4d q, double s) {
        if (isInterpolate) {
            nextS = s;
            nextV.set(v);
            nextQ.set(q);
            nextQ.normalize();
        } else {
            nowS = s;
            nowV.set(v);
            nowQ.set(q);
            nextS = s;
            nextV.set(v);
            nextQ.set(q);
        }
        needRecalc = true;
    }
    void moveImmediately(Vector3d v, Quat4d q, double s) {
        nowS = s;
        nowV.set(v);
        nowQ.set(q);
        nextS = s;
        nextV.set(v);
        nextQ.set(q);
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    void setLoc(Vector3d v) {
        if (isInterpolate) {
            nextV.set(v);
        } else {
            nowV.set(v);
            nextV.set(v);
        }
        needRecalc = true;
    }
    void setLocImmediately(Vector3d v) {
        nowV.set(v);
        nextV.set(v);
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    Vector3d getLoc() {
        return new Vector3d(nowV);
    }
    void setQuat(Quat4d q) {
        if (isInterpolate) {
            nextQ.set(q);
        } else {
            nowQ.set(q);
            nextQ.set(q);
        }
        needRecalc = true;
    }
    void setQuatImmediately(Quat4d q) {
        nowQ.set(q);
        nextQ.set(q);
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    Quat4d getQuat() {
        return new Quat4d(nowQ);
    }
    void setScale(double s) {
        if (isInterpolate) {
            nextS = s;
        } else {
            nowS = s;
            nextS = s;
        }
        needRecalc = true;
    }
    void setScaleImmediately(double s) {
        nowS = s;
        nextS = s;
        if (universe!=null) {
            if (universe.scene.upperDirection==A3Object.UpperDirection.Z) {
                tmpQ.mul(nowQ,tmpQQ);
            } else {
                tmpQ.set(nowQ);
            }
        } else {
            tmpQ.set(nowQ);
        }
        t.set(tmpQ,nowV,nowS);
        transGroup.setTransform(t);
//        needRecalc = true;
    }
    double getScale() {
        return nowS;
    }
    double getSpeed() {
        if (isInterpolate) {
            if (universe!=null)
                return nowTrans.length()/(TimerBehavior.elapsedTime/1000.0);
            else
                return nowTrans.length()/(elapsedTime/1000.0);
        } else {
            return 0.0;
        }
    }
}
