package jp.sourceforge.acerola3d.sound;

import net.java.games.joal.*;

import javax.vecmath.*;
import javax.sound.sampled.*;
import java.io.*;
import java.net.URL;
import java.nio.*;

public class ShortSound implements A3Sound {
    String file;
    A3SoundSystem soundSystem;
    float segnoTime;
    A3SoundType type;
    float gain;
    boolean loop=false;
    int buffer[] = new int[1];
    int source[] = new int[1];

    ShortSound() {
    }
    
    public void init(String file,A3SoundSystem ss,float segno,A3SoundType t,float g,boolean l) throws Exception {
        this.file = file;
        soundSystem = ss;
        segnoTime = segno;
        type = t;
        gain = g;
        loop = l;

        initBuffer();
        initSource();
    }

    void initBuffer() throws Exception {
        int format[] = new int[1];
        ByteBuffer data[] = new ByteBuffer[1];
        int size[] = new int[1];
        int freq[] = new int[1];

        URL url = new URL(file);
        InputStream is = url.openStream();
        AudioInputStream ais = AudioSystem.getAudioInputStream(is);
        AudioFormat audioFormat = ais.getFormat();
        audioFormat = new AudioFormat(
            audioFormat.getSampleRate(),
            16,
            audioFormat.getChannels(),
            true,
            false);
        ais = AudioSystem.getAudioInputStream(audioFormat,ais);
/*
long skipB=50000l;
long sum=0;
long count=0;
while (sum<skipB) {
    count = ais.skip(skipB-sum);
    System.out.println(count);
    sum+=count;
}
System.out.println("sum:"+sum);
*/
        //ais.skip(100000l);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte b[] = new byte[1024];
        int cnt=0;
        while (true) {
            if ((cnt=ais.read(b))==-1)
                break;
            baos.write(b,0,cnt);
        }
        b = baos.toByteArray();
        data[0] = ByteBuffer.wrap(b);
        if (audioFormat.getChannels()==1)
            format[0] = AL.AL_FORMAT_MONO16;
        else
            format[0] = AL.AL_FORMAT_STEREO16;
        size[0] = b.length;
        freq[0] = (int)audioFormat.getSampleRate();

        soundSystem.al.alGenBuffers(1,buffer,0); check(1);
        soundSystem.al.alBufferData(buffer[0],format[0],data[0],size[0],freq[0]); check(2);
    }
    void initSource() {
        soundSystem.al.alGenSources(1,source,0); check(3);

        soundSystem.al.alSourcei(source[0],AL.AL_BUFFER,buffer[0]);
        soundSystem.al.alSourcef(source[0],AL.AL_PITCH,1.0f);
        soundSystem.al.alSourcef(source[0],AL.AL_GAIN,1.0f);
        soundSystem.al.alSource3f(source[0],AL.AL_POSITION,0.0f,0.0f,0.0f);
        //al.alSource3i(source[0],AL.AL_VELOCITY,0,0,0);
        soundSystem.al.alSourcef(source[0],AL.AL_GAIN,gain);
        if (loop)
            soundSystem.al.alSourcei(source[0],AL.AL_LOOPING,AL.AL_TRUE);
        else
            soundSystem.al.alSourcei(source[0],AL.AL_LOOPING,AL.AL_FALSE);
        if (type==A3SoundType.BackgroundSound) {
            soundSystem.al.alSourcei(source[0],AL.AL_SOURCE_RELATIVE,AL.AL_TRUE);
            soundSystem.al.alSource3f(source[0],AL.AL_POSITION,0.0f,0.0f,1.0f);
        }
        if (type==A3SoundType.ConeSound) {
            soundSystem.al.alSourcef(source[0],AL.AL_CONE_INNER_ANGLE,90.0f);
            soundSystem.al.alSourcef(source[0],AL.AL_CONE_OUTER_ANGLE,135.0f);
            soundSystem.al.alSourcef(source[0],AL.AL_CONE_OUTER_GAIN,0.0f);
            soundSystem.al.alSource3f(source[0],AL.AL_DIRECTION,0.0f,0.0f,1.0f);
        }
        check(4);
    }
    public void start() {
        soundSystem.al.alSourcePlay(source[0]); check(5);
    }
    public void segno() {
        soundSystem.al.alSourcef(source[0],AL.AL_SEC_OFFSET,segnoTime);// check(6);
        soundSystem.al.alGetError();//上の行，Linuxだと必ずErrorになるようなので，とりあえず無視してエラーをリセット
        soundSystem.al.alSourcePlay(source[0]); check(7);
    }
    public void stop() {
        soundSystem.al.alSourceStop(source[0]);
    }
    public void pause() {
        soundSystem.al.alSourcePause(source[0]);
    }
    public void rewind() {
        soundSystem.al.alSourceRewind(source[0]);
    }
    public void setLoc(float x,float y,float z) {
        if (type!=A3SoundType.BackgroundSound)
            soundSystem.al.alSource3f(source[0],AL.AL_POSITION,x,y,z);
    }
    public void setLoc(Vector3d v) {
        if (type!=A3SoundType.BackgroundSound) {
            float x = (float)v.x;
            float y = (float)v.y;
            float z = (float)v.z;
            soundSystem.al.alSource3f(source[0],AL.AL_POSITION,x,y,z);
        }
    }
    public void setRot(float x,float y,float z) {
        Quat4d qx = new Quat4d(Math.sin(x/2.0),0.0,0.0,Math.cos(x/2.0));
        Quat4d qy = new Quat4d(0.0,Math.sin(y/2.0),0.0,Math.cos(y/2.0));
        Quat4d qz = new Quat4d(0.0,0.0,Math.sin(z/2.0),Math.cos(z/2.0));
        Quat4d q = new Quat4d(0.0,0.0,0.0,1.0);
        q.mul(qx);
        q.mul(qy);
        q.mul(qz);
        setQuat(q);
    }
    public void setRot(Vector3d r) {
        float x = (float)r.x;
        float y = (float)r.y;
        float z = (float)r.z;
        setRot(x,y,z);
    }
    public void setQuat(Quat4d q) {
        if (type!=A3SoundType.BackgroundSound) {
            Quat4d qTmp = new Quat4d(0.0,0.0,1.0,0.0);
            Quat4d qq = new Quat4d(q);
            Quat4d qc = new Quat4d(q);
            qc.conjugate();
            qTmp.mul(qq,qTmp);
            qTmp.mul(qc);
            float x = (float)qTmp.x;
            float y = (float)qTmp.y;
            float z = (float)qTmp.z;
            soundSystem.al.alSource3f(source[0],AL.AL_DIRECTION,x,y,z);
        }
    }
    public void setVel() {
    }
    public void setGain(float g) {
        soundSystem.al.alSourcef(source[0],AL.AL_GAIN,g);
    }
    public float getGain() {
        float f[] = new float[1];
        soundSystem.al.alGetSourcef(source[0],AL.AL_GAIN,f,0);
        return f[0];
    }
    public void setDirection(float x,float y,float z) {
        soundSystem.al.alSource3f(source[0],AL.AL_DIRECTION,x,y,z);
    }
    public void setDirection(Vector3d d) {
        setDirection((float)d.x,(float)d.y,(float)d.z);
    }
    public void setLoop(boolean l) {
        loop = l;
        if (loop)
            soundSystem.al.alSourcei(source[0],AL.AL_LOOPING,AL.AL_TRUE);
        else
            soundSystem.al.alSourcei(source[0],AL.AL_LOOPING,AL.AL_FALSE);
    }
    public void cleanUp() {
        soundSystem.al.alSourceStop(source[0]);
        soundSystem.al.alDeleteSources(1,source,0);
        soundSystem.al.alDeleteBuffers(1,buffer,0);
        synchronized (soundSystem.sounds) {
            soundSystem.sounds.remove(this);
        }
    }
    public void setType(A3SoundType t) {
        if (t==A3SoundType.BackgroundSound) {
            type = t;
            soundSystem.al.alSourcei(source[0],AL.AL_SOURCE_RELATIVE,AL.AL_TRUE);
            soundSystem.al.alSource3f(source[0],AL.AL_POSITION,0.0f,0.0f,1.0f);
        } else if (t==A3SoundType.ConeSound) {
            type = t;
            soundSystem.al.alSourcef(source[0],AL.AL_CONE_INNER_ANGLE,90.0f);
            soundSystem.al.alSourcef(source[0],AL.AL_CONE_OUTER_ANGLE,135.0f);
            soundSystem.al.alSourcef(source[0],AL.AL_CONE_OUTER_GAIN,0.0f);
            soundSystem.al.alSource3f(source[0],AL.AL_DIRECTION,0.0f,0.0f,1.0f);
        } else {
            type = t;
            soundSystem.al.alSourcef(source[0],AL.AL_CONE_INNER_ANGLE,360.0f);
            soundSystem.al.alSourcef(source[0],AL.AL_CONE_OUTER_ANGLE,360.0f);
            soundSystem.al.alSourcef(source[0],AL.AL_CONE_OUTER_GAIN,0.0f);
            soundSystem.al.alSource3f(source[0],AL.AL_DIRECTION,0.0f,0.0f,0.0f);
        }
    }
    public void setSegno(float s) {
        segnoTime = s;
    }
    public A3Sound copy() {
        ShortSound ret = new ShortSound();
        ret.file = file;
        ret.soundSystem = soundSystem;
        ret.segnoTime = segnoTime;
        ret.type = type;
        ret.gain = gain;
        ret.loop = loop;
        ret.buffer[0] = buffer[0];
        soundSystem.al.alGenSources(1,ret.source,0); check(8);
        soundSystem.al.alSourcei(ret.source[0],AL.AL_BUFFER,ret.buffer[0]);
        soundSystem.al.alSourcef(ret.source[0],AL.AL_PITCH,1.0f);
        soundSystem.al.alSourcef(ret.source[0],AL.AL_GAIN,1.0f);
        soundSystem.al.alSource3f(ret.source[0],AL.AL_POSITION,0.0f,0.0f,0.0f);
        //al.alSource3i(ret.source[0],AL.AL_VELOCITY,0,0,0);
        //soundSystem.al.alSourcei(ret.source[0],AL.AL_LOOPING,AL.AL_FALSE);
        check(9);
        return ret;
    }
    void check(int i) {
        int e = soundSystem.al.alGetError();
        if (e==AL.AL_NO_ERROR)
            return;
        String s = "??????";
        switch(e) {
            case AL.AL_INVALID_NAME: s="AL_INVALID_NAME";break;
            case AL.AL_INVALID_ENUM: s="AL_INVALID_ENUM";break;
            case AL.AL_INVALID_VALUE: s="AL_INVALID_VALUE";break;
            case AL.AL_INVALID_OPERATION: s="AL_INVALID_OPERATION";break;
            case AL.AL_OUT_OF_MEMORY: s="AL_OUT_OF_MEMORY";break;
        }
        System.out.println("----------ShortSound----------");
        System.out.println("OpenAL error raised..."+s+i);
        System.out.println("------------------------------\n");
    }
}
