/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.j3dbvh;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.filechooser.FileNameExtensionFilter;
import jp.sourceforge.acerola3d.j3dbvh.J3DBVH;

public class BvhTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private FileNameExtensionFilter filter = new FileNameExtensionFilter("", "bvh");
    private J3DBVH j3dbvh;

    public BvhTransferHandler(J3DBVH j3dbvh) {
        this.j3dbvh = j3dbvh;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        support.setShowDropLocation(true);
        return true;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        try {
            Object obj = support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            File file = (File)((List)obj).get(0);
            if (file != null && this.filter.accept(file)) {
                this.j3dbvh.loadBVH(file);
            }
            return true;
        }
        catch (UnsupportedFlavorException ex) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

