/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.sound;

import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.sound.A3Sound;
import jp.sourceforge.acerola3d.sound.A3SoundType;
import jp.sourceforge.acerola3d.sound.LongSound;
import jp.sourceforge.acerola3d.sound.ShortSound;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALCcontext;
import net.java.games.joal.ALCdevice;
import net.java.games.joal.ALFactory;
import net.java.games.joal.util.ALut;

public class A3SoundSystem {
    static final A3SoundSystem defaultSoundSystem = new A3SoundSystem();
    static ArrayList<A3SoundSystem> soundSystems = new ArrayList();
    AL al;
    ArrayList<A3Sound> sounds = new ArrayList();
    ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);

    public static A3SoundSystem getDefaultSoundSystem() {
        return defaultSoundSystem;
    }

    A3SoundSystem() {
        ALCcontext context;
        ALC alc = ALFactory.getALC();
        ALCdevice device = alc.alcOpenDevice(null);
        if (device != null && (context = alc.alcCreateContext(device, null)) != null) {
            alc.alcMakeContextCurrent(context);
        }
        this.al = ALFactory.getAL();
        this.al.alGetError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public A3Sound load(String url, float segno, A3SoundType type, float gain, boolean loop) throws Exception {
        URL url1;
        URLConnection c;
        boolean isLongSound = false;
        if ((url.toLowerCase().endsWith(".mp3") || url.toLowerCase().endsWith(".ogg")) && (c = (url1 = new URL(url)).openConnection()).getContentLength() > 65536) {
            isLongSound = true;
        }
        A3Sound newSound = null;
        if (isLongSound) {
            newSound = new LongSound();
            newSound.init(url, this, segno, type, gain, loop);
        } else {
            newSound = new ShortSound();
            newSound.init(url, this, segno, type, gain, loop);
        }
        ArrayList<A3Sound> arrayList = this.sounds;
        synchronized (arrayList) {
            this.sounds.add(newSound);
        }
        return newSound;
    }

    public void setListenerLoc(float x, float y, float z) {
        this.al.alListener3f(4100, x, y, z);
    }

    public void setListenerLoc(Vector3d l) {
        this.al.alListener3f(4100, (float)l.x, (float)l.y, (float)l.z);
    }

    public void setListenerRot(float x, float y, float z) {
        Quat4d qx = new Quat4d(Math.sin((double)x / 2.0), 0.0, 0.0, Math.cos((double)x / 2.0));
        Quat4d qy = new Quat4d(0.0, Math.sin((double)y / 2.0), 0.0, Math.cos((double)y / 2.0));
        Quat4d qz = new Quat4d(0.0, 0.0, Math.sin((double)z / 2.0), Math.cos((double)z / 2.0));
        Quat4d q = new Quat4d(0.0, 0.0, 0.0, 1.0);
        q.mul(qx);
        q.mul(qy);
        q.mul(qz);
        this.setListenerQuat(q);
    }

    public void setListenerRot(Vector3d r) {
        float x = (float)r.x;
        float y = (float)r.y;
        float z = (float)r.z;
        this.setListenerRot(x, y, z);
    }

    public void setListenerQuat(Quat4d q) {
        Quat4d qTmp = new Quat4d(0.0, 0.0, -1.0, 0.0);
        Quat4d qq = new Quat4d(q);
        Quat4d qc = new Quat4d(q);
        qc.conjugate();
        qTmp.mul(qq, qTmp);
        qTmp.mul(qc);
        float lx = (float)qTmp.x;
        float ly = (float)qTmp.y;
        float lz = (float)qTmp.z;
        qTmp = new Quat4d(0.0, 1.0, 0.0, 0.0);
        qTmp.mul(qq, qTmp);
        qTmp.mul(qc);
        float ux = (float)qTmp.x;
        float uy = (float)qTmp.y;
        float uz = (float)qTmp.z;
        float[] lookAtAndUp = new float[]{lx, ly, lz, ux, uy, uz};
        this.al.alListenerfv(4111, lookAtAndUp, 0);
    }

    public void setListenerVel(float x, float y, float z) {
        this.al.alListener3f(4102, x, y, z);
    }

    public void setListenerVel(Vector3d v) {
        this.al.alListener3f(4102, (float)v.x, (float)v.y, (float)v.z);
    }

    public Vector3d getListenerVel() {
        return null;
    }

    public void setListenerGain(double g) {
        this.al.alListenerf(4106, (float)g);
    }

    public double getListenerGain() {
        float[] f = new float[1];
        this.al.alGetListenerf(4106, f, 0);
        return f[0];
    }

    public void cleanUp() {
        this.executor.shutdownNow();
        ArrayList<A3Sound> sTmp = new ArrayList<A3Sound>(this.sounds);
        for (A3Sound s : sTmp) {
            s.cleanUp();
        }
        ALut.alutExit();
        System.out.println("SoundSystem.cleanUp()");
    }
}

