/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.util;

import java.util.AbstractList;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayList<T>
extends AbstractList<T>
implements RandomAccess {
    private T[] array;
    private int size;

    public ObjectArrayList() {
        this(16);
    }

    public ObjectArrayList(int initialCapacity) {
        this.array = new Object[initialCapacity];
    }

    @Override
    public boolean add(T value) {
        if (this.size == this.array.length) {
            this.expand();
        }
        this.array[this.size++] = value;
        return true;
    }

    private void expand() {
        Object[] newArray = new Object[this.array.length << 1];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        this.array = newArray;
    }

    @Override
    public T remove(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        T old = this.array[index];
        System.arraycopy(this.array, index + 1, this.array, index, this.size - index - 1);
        --this.size;
        return old;
    }

    @Override
    public T get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[index];
    }

    @Override
    public T set(int index, T value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        T old = this.array[index];
        this.array[index] = value;
        return old;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.array.length;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!(o == null ? this.array[i] == null : o.equals(this.array[i]))) continue;
            return i;
        }
        return -1;
    }
}

