/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SharedGroup;
import org.jdesktop.j3d.loaders.vrml97.impl.Leafer;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.Scene;

public abstract class NonSharedNode
extends Node {
    SharedGroup sharedGroup = null;
    boolean linkTested = false;
    boolean linkable = true;

    NonSharedNode(Loader loader) {
        super(loader);
    }

    public void registerUse(Scene scene) {
        if (this.loader.debug) {
            System.out.println("Use of non-sharable tree " + this.defName + " = " + this.toStringId() + " impl = " + this.implNode);
        }
        if (!this.linkTested) {
            if (Leafer.has((SceneGraphObject)this.implNode, 9)) {
                this.linkable = false;
            }
            if (this.loader.debug) {
                System.out.println("Tested, linkable = " + this.linkable);
            }
            this.linkTested = true;
        }
        if (this.linkable && this.sharedGroup == null) {
            this.sharedGroup = new SharedGroup();
            scene.addSharedGroup(this.sharedGroup);
            javax.media.j3d.Node parent = this.implNode.getParent();
            if (parent != null) {
                Group parentGroup = (Group)parent;
                boolean found = false;
                for (int i = 0; i < parentGroup.numChildren(); ++i) {
                    javax.media.j3d.Node child = parentGroup.getChild(i);
                    if (child != this.implNode) continue;
                    found = true;
                    Link link = new Link(this.sharedGroup);
                    parentGroup.setChild((javax.media.j3d.Node)link, i);
                    if (!this.loader.debug) continue;
                    System.out.println("Updated reference to " + this.implNode + " in parent " + parentGroup + " to link " + link);
                }
                if (this.loader.debug && !found) {
                    System.out.println("Could not find " + this.implNode + " in parent " + parentGroup);
                }
            }
            this.sharedGroup.addChild(this.implNode);
            if (this.loader.debug) {
                System.out.println("nonShared tree: " + this.toStringId() + " is now in SharedGroup " + this.sharedGroup);
            }
        }
    }

    public javax.media.j3d.Node getImplNode() {
        if (this.linkTested && !this.linkable) {
            if (this.implNode.getParent() == null) {
                return this.implNode;
            }
            if (this.loader.debug) {
                System.out.println("cloning a non linkable subtree:" + this.implNode);
            }
            javax.media.j3d.Node clone = this.implNode.cloneTree(false, true);
            if (this.implNode.getUserData() != null) {
                clone.setUserData(this.implNode.getUserData());
            }
            if (this.loader.debug) {
                System.out.println("cloning is: " + clone);
            }
            return clone;
        }
        if (this.sharedGroup != null) {
            return new Link(this.sharedGroup);
        }
        return this.implNode;
    }
}

