/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.utils.geometry.Edge;
import com.sun.j3d.utils.geometry.EdgeTable;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.Triangulator;
import java.util.ArrayList;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class NormalGenerator {
    private double creaseAngle;
    private Vector3f[] facetNorms;
    private ArrayList tally;
    private GeometryInfo gi;
    private int[] coordInds;
    private int[] normalInds;
    private int[] colorInds;
    private int[][] texInds;
    private int[] stripCounts;
    private static long t1 = 0L;
    private static long t2 = 0L;
    private static long t3 = 0L;
    private static long t4 = 0L;
    private static long t5 = 0L;
    private static long t6 = 0L;
    private Triangulator tr = null;
    private int numTexSets;
    private static final int DEBUG = 0;

    private void calculatefacetNorms() {
        Point3f[] point3fArray = this.gi.getCoordinates();
        this.facetNorms = new Vector3f[this.coordInds.length / 3];
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        if (this.gi.getOldPrim() != 2) {
            for (int i = 0; i < this.coordInds.length; i += 3) {
                vector3f.sub(point3fArray[this.coordInds[i + 2]], point3fArray[this.coordInds[i + 1]]);
                vector3f2.sub(point3fArray[this.coordInds[i + 0]], point3fArray[this.coordInds[i + 1]]);
                this.facetNorms[i / 3] = new Vector3f();
                this.facetNorms[i / 3].cross(vector3f, vector3f2);
                this.facetNorms[i / 3].normalize();
                if (!Float.isNaN(this.facetNorms[i / 3].x)) continue;
                this.facetNorms[i / 3].x = 1.0f;
                this.facetNorms[i / 3].z = 0.0f;
                this.facetNorms[i / 3].y = 0.0f;
            }
        } else {
            for (int i = 0; i < this.coordInds.length; i += 6) {
                vector3f.sub(point3fArray[this.coordInds[i + 2]], point3fArray[this.coordInds[i + 0]]);
                vector3f2.sub(point3fArray[this.coordInds[i + 5]], point3fArray[this.coordInds[i + 1]]);
                this.facetNorms[i / 3] = new Vector3f();
                this.facetNorms[i / 3].cross(vector3f, vector3f2);
                this.facetNorms[i / 3].normalize();
                if (Float.isNaN(this.facetNorms[i / 3].x)) {
                    this.facetNorms[i / 3].x = 1.0f;
                    this.facetNorms[i / 3].z = 0.0f;
                    this.facetNorms[i / 3].y = 0.0f;
                }
                this.facetNorms[i / 3 + 1] = new Vector3f(this.facetNorms[i / 3]);
            }
        }
    }

    private int createHardEdges() {
        int n;
        EdgeTable edgeTable = new EdgeTable(this.coordInds);
        this.tally = new ArrayList();
        int[] nArray = new int[this.coordInds.length];
        int n2 = 1;
        float f = (float)Math.cos(this.creaseAngle);
        for (n = 0; n < this.coordInds.length; ++n) {
            nArray[n] = Integer.MAX_VALUE;
        }
        for (n = 0; n < this.coordInds.length; ++n) {
            boolean bl;
            if (nArray[n] != Integer.MAX_VALUE) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            this.tally.add(arrayList);
            arrayList.add(new Integer(n));
            nArray[n] = this.tally.size() - 1;
            boolean bl2 = true;
            Edge edge = new Edge(this.coordInds[n], this.coordInds[(n + 1) % 3 == 0 ? n - 2 : n + 1]);
            int n3 = this.coordInds[n % 3 == 0 ? n + 2 : n - 1];
            int n4 = n;
            do {
                Integer n5;
                if ((n5 = edgeTable.get(edge.v2, edge.v1)) == null) {
                    bl = false;
                } else {
                    int n6 = n5;
                    float f2 = this.facetNorms[n4 / 3].dot(this.facetNorms[n6 / 3]);
                    boolean bl3 = bl = f2 > f;
                    if (bl) {
                        int n7;
                        int n8 = n7 = (n6 + 1) % 3 == 0 ? n6 - 2 : n6 + 1;
                        if (this.coordInds[n] != this.coordInds[n7]) {
                            int n9 = n7 = n6 % 3 == 0 ? n6 + 2 : n6 - 1;
                        }
                        if (nArray[n7] != Integer.MAX_VALUE) {
                            bl = false;
                        } else {
                            nArray[n7] = this.tally.size() - 1;
                            arrayList.add(new Integer(n7));
                            if (arrayList.size() > n2) {
                                n2 = arrayList.size();
                            }
                            n4 = n6;
                            if (bl2) {
                                edge.v2 = this.coordInds[n4];
                            } else {
                                edge.v1 = this.coordInds[n4];
                            }
                        }
                    }
                }
                if (bl || !bl2) continue;
                bl2 = false;
                bl = true;
                n4 = n;
                edge = new Edge(this.coordInds[n % 3 == 0 ? n + 2 : n - 1], this.coordInds[n]);
            } while (bl && (bl2 && edge.v2 != n3 || !bl2));
        }
        return n2;
    }

    private void calculateVertexNormals(int n) {
        Vector3f[] vector3fArray;
        if (this.creaseAngle != 0.0) {
            Vector3f[] vector3fArray2 = new Vector3f[n];
            vector3fArray = new Vector3f[this.tally.size()];
            this.normalInds = new int[this.coordInds.length];
            for (int i = 0; i < this.tally.size(); ++i) {
                ArrayList arrayList = (ArrayList)this.tally.get(i);
                int n2 = 0;
                vector3fArray[i] = new Vector3f();
                for (int j = 0; j < arrayList.size(); ++j) {
                    int n3;
                    int n4 = (Integer)arrayList.get(j);
                    if (n4 == -1) continue;
                    int n5 = n4 / 3;
                    if (Float.isNaN(this.facetNorms[n5].x)) continue;
                    for (n3 = 0; n3 < n2 && !vector3fArray2[n3].equals(this.facetNorms[n5]); ++n3) {
                    }
                    this.normalInds[n4] = i;
                    if (n3 != n2) continue;
                    vector3fArray[i].add(this.facetNorms[n5]);
                    vector3fArray2[n2++] = this.facetNorms[n5];
                }
                vector3fArray[i].normalize();
                if (!Float.isNaN(vector3fArray[i].x)) continue;
                vector3fArray[i].x = 1.0f;
                vector3fArray[i].z = 0.0f;
                vector3fArray[i].y = 0.0f;
            }
        } else {
            vector3fArray = this.facetNorms;
            this.normalInds = new int[this.facetNorms.length * 3];
            for (int i = 0; i < this.facetNorms.length; ++i) {
                this.normalInds[i * 3 + 0] = i;
                this.normalInds[i * 3 + 1] = i;
                this.normalInds[i * 3 + 2] = i;
            }
        }
        this.gi.setNormals(vector3fArray);
    }

    private int[] triToQuadIndices(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length / 6 * 4];
        for (int i = 0; i < nArray.length / 6; ++i) {
            nArray2[i * 4 + 0] = nArray[i * 6 + 0];
            nArray2[i * 4 + 1] = nArray[i * 6 + 1];
            nArray2[i * 4 + 2] = nArray[i * 6 + 2];
            nArray2[i * 4 + 3] = nArray[i * 6 + 5];
        }
        return nArray2;
    }

    private void convertTriToQuad(GeometryInfo geometryInfo) {
        geometryInfo.setCoordinateIndices(this.triToQuadIndices(geometryInfo.getCoordinateIndices()));
        geometryInfo.setColorIndices(this.triToQuadIndices(geometryInfo.getColorIndices()));
        geometryInfo.setNormalIndices(this.triToQuadIndices(geometryInfo.getNormalIndices()));
        int n = geometryInfo.getTexCoordSetCount();
        for (int i = 0; i < n; ++i) {
            geometryInfo.setTextureCoordinateIndices(i, this.triToQuadIndices(geometryInfo.getTextureCoordinateIndices(i)));
        }
        geometryInfo.setPrimitive(2);
    }

    private int[] triToFanIndices(int[] nArray, int[] nArray2, int n) {
        if (nArray2 == null) {
            return null;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[n3++] = nArray2[n2++];
            nArray3[n3++] = nArray2[n2++];
            nArray3[n3++] = nArray2[n2++];
            for (int j = 3; j < nArray[i]; ++j) {
                nArray3[n3++] = nArray2[n2 + 2];
                n2 += 3;
            }
        }
        return nArray3;
    }

    private void convertTriToFan(GeometryInfo geometryInfo, int[] nArray) {
        int n;
        int n2;
        int[] nArray2 = geometryInfo.getNormalIndices();
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length + 100);
        for (int i = 0; i < nArray.length; ++i) {
            n2 = 3;
            for (n = 0; n < nArray[i] - 3; ++n) {
                if (nArray2[n3 * 3] == nArray2[(n3 + 1) * 3] && nArray2[n3 * 3 + 2] == nArray2[(n3 + 1) * 3 + 1]) {
                    ++n2;
                } else {
                    arrayList.add(new Integer(n2));
                    n2 = 3;
                }
                ++n3;
            }
            ++n3;
            arrayList.add(new Integer(n2));
        }
        int[] nArray3 = new int[arrayList.size()];
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            nArray3[n2] = (Integer)arrayList.get(n2);
        }
        arrayList = null;
        n2 = 0;
        for (n = 0; n < nArray3.length; ++n) {
            n2 += nArray3[n];
        }
        geometryInfo.setCoordinateIndices(this.triToFanIndices(nArray3, geometryInfo.getCoordinateIndices(), n2));
        geometryInfo.setColorIndices(this.triToFanIndices(nArray3, geometryInfo.getColorIndices(), n2));
        geometryInfo.setNormalIndices(this.triToFanIndices(nArray3, geometryInfo.getNormalIndices(), n2));
        n = geometryInfo.getTexCoordSetCount();
        for (int i = 0; i < n; ++i) {
            geometryInfo.setTextureCoordinateIndices(i, this.triToFanIndices(nArray3, geometryInfo.getTextureCoordinateIndices(i), n2));
        }
        geometryInfo.setStripCounts(nArray3);
        geometryInfo.setPrimitive(3);
    }

    private int[] triToStripIndices(int[] nArray, int[] nArray2, int n) {
        if (nArray2 == null) {
            return null;
        }
        int[] nArray3 = new int[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray3[n3++] = nArray2[n2++];
            nArray3[n3++] = nArray2[n2++];
            nArray3[n3++] = nArray2[n2++];
            for (int j = 3; j < nArray[i]; ++j) {
                nArray3[n3++] = nArray2[n2 + 2 - j % 2];
                n2 += 3;
            }
        }
        return nArray3;
    }

    private void convertTriToStrip(GeometryInfo geometryInfo, int[] nArray) {
        int n;
        int n2;
        int[] nArray2 = geometryInfo.getNormalIndices();
        int n3 = 0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(nArray.length + 100);
        for (int i = 0; i < nArray.length; ++i) {
            n2 = 3;
            for (n = 0; n < nArray[i] - 3; ++n) {
                if (n % 2 == 0) {
                    if (nArray2[n3 * 3 + 1] == nArray2[(n3 + 1) * 3] && nArray2[n3 * 3 + 2] == nArray2[(n3 + 1) * 3 + 2]) {
                        ++n2;
                    } else {
                        arrayList.add(new Integer(n2));
                        n2 = 3;
                        if (n < nArray[i] - 4) {
                            arrayList.add(new Integer(3));
                            ++n;
                        }
                    }
                } else if (nArray2[n3 * 3 + 1] == nArray2[(n3 + 1) * 3 + 1] && nArray2[n3 * 3 + 2] == nArray2[(n3 + 1) * 3]) {
                    ++n2;
                } else {
                    arrayList.add(new Integer(n2));
                    n2 = 3;
                }
                ++n3;
            }
            ++n3;
            arrayList.add(new Integer(n2));
        }
        int[] nArray3 = new int[arrayList.size()];
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            nArray3[n2] = (Integer)arrayList.get(n2);
        }
        arrayList = null;
        n2 = 0;
        for (n = 0; n < nArray3.length; ++n) {
            n2 += nArray3[n];
        }
        geometryInfo.setCoordinateIndices(this.triToStripIndices(nArray3, geometryInfo.getCoordinateIndices(), n2));
        geometryInfo.setColorIndices(this.triToStripIndices(nArray3, geometryInfo.getColorIndices(), n2));
        geometryInfo.setNormalIndices(this.triToStripIndices(nArray3, geometryInfo.getNormalIndices(), n2));
        n = geometryInfo.getTexCoordSetCount();
        for (int i = 0; i < n; ++i) {
            geometryInfo.setTextureCoordinateIndices(i, this.triToStripIndices(nArray3, geometryInfo.getTextureCoordinateIndices(i), n2));
        }
        geometryInfo.setStripCounts(nArray3);
        geometryInfo.setPrimitive(4);
    }

    void convertBackToOldPrim(GeometryInfo geometryInfo, int n, int[] nArray) {
        if (n == 1) {
            return;
        }
        switch (n) {
            case 2: {
                this.convertTriToQuad(geometryInfo);
                break;
            }
            case 3: {
                this.convertTriToFan(geometryInfo, nArray);
                break;
            }
            case 4: {
                this.convertTriToStrip(geometryInfo, nArray);
            }
        }
    }

    public void generateNormals(GeometryInfo geometryInfo) {
        int n;
        this.gi = geometryInfo;
        this.gi.setNormals((Vector3f[])null);
        this.gi.setNormalIndices(null);
        long l = 0L;
        if (this.gi.getPrimitive() == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this.gi);
        } else {
            this.gi.rememberOldPrim();
            this.gi.convertToIndexedTriangles();
        }
        this.coordInds = this.gi.getCoordinateIndices();
        this.colorInds = this.gi.getColorIndices();
        this.normalInds = this.gi.getNormalIndices();
        this.numTexSets = this.gi.getTexCoordSetCount();
        this.texInds = new int[this.numTexSets][];
        for (n = 0; n < this.numTexSets; ++n) {
            this.texInds[n] = this.gi.getTextureCoordinateIndices(n);
        }
        this.stripCounts = this.gi.getStripCounts();
        this.calculatefacetNorms();
        n = this.createHardEdges();
        this.calculateVertexNormals(n);
        this.gi.setCoordinateIndices(this.coordInds);
        this.gi.setColorIndices(this.colorInds);
        this.gi.setNormalIndices(this.normalInds);
        for (int i = 0; i < this.numTexSets; ++i) {
            this.gi.setTextureCoordinateIndices(i, this.texInds[i]);
        }
        this.gi.setStripCounts(this.stripCounts);
    }

    public void setCreaseAngle(double d) {
        if (d > Math.PI) {
            d = Math.PI;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        this.creaseAngle = d;
    }

    public double getCreaseAngle() {
        return this.creaseAngle;
    }

    public NormalGenerator(double d) {
        this.creaseAngle = d;
    }

    public NormalGenerator() {
        this(0.767944870877505);
    }
}

