/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import com.bulletphysics.collision.shapes.ConvexHullShape;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.collision.shapes.ShapeHull;
import com.sun.j3d.loaders.Scene;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Group;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jp.sourceforge.acerola3d.a3.VRML;

public class Util {
    public static void cleanUp() {
    }

    public static Quat4d mul(Quat4d a, Quat4d b) {
        Quat4d ret = new Quat4d();
        ret.x = a.w * b.x + a.x * b.w + a.y * b.z - a.z * b.y;
        ret.y = a.w * b.y - a.x * b.z + a.y * b.w + a.z * b.x;
        ret.z = a.w * b.z + a.x * b.y - a.y * b.x + a.z * b.w;
        ret.w = a.w * b.w - a.x * b.x - a.y * b.y - a.z * b.z;
        return ret;
    }

    public static Vector3d trans(Quat4d q, Vector3d v) {
        Quat4d qc = new Quat4d();
        qc.x = -q.x;
        qc.y = -q.y;
        qc.z = -q.z;
        qc.w = q.w;
        Quat4d vq = new Quat4d();
        vq.x = v.x;
        vq.y = v.y;
        vq.z = v.z;
        vq.w = 0.0;
        vq.mul(q, vq);
        vq.mul(qc);
        return new Vector3d(vq.x, vq.y, vq.z);
    }

    public static Quat4d euler2quat(Vector3d v) {
        return Util.euler2quat(v.x, v.y, v.z);
    }

    public static Quat4d euler2quat(double x, double y, double z) {
        Quat4d q = new Quat4d(0.0, 0.0, 0.0, 1.0);
        q.mul(new Quat4d(0.0, Math.sin(y / 2.0), 0.0, Math.cos(y / 2.0)));
        q.mul(new Quat4d(Math.sin(x / 2.0), 0.0, 0.0, Math.cos(x / 2.0)));
        q.mul(new Quat4d(0.0, 0.0, Math.sin(z / 2.0), Math.cos(z / 2.0)));
        return q;
    }

    static Quat4d euler2quat_OLD(Vector3d v) {
        Transform3D t0 = new Transform3D();
        Transform3D t1 = new Transform3D();
        t1.rotY(v.y);
        t0.mul(t1);
        t1.rotX(v.x);
        t0.mul(t1);
        t1.rotZ(v.z);
        t0.mul(t1);
        Quat4d q = new Quat4d();
        t0.get(q);
        return q;
    }

    public static Vector3d quat2euler(Quat4d q) {
        Matrix3d m = new Matrix3d();
        m.set(q);
        Vector3d ret = new Vector3d();
        if (m.m12 == 1.0) {
            ret.x = 1.5707963267948966;
            ret.y = Math.atan2(-m.m20, m.m00);
            ret.z = 0.0;
        } else if (m.m12 == -1.0) {
            ret.x = -1.5707963267948966;
            ret.y = Math.atan2(-m.m20, m.m00);
            ret.z = 0.0;
        } else {
            ret.x = Math.asin(-m.m12);
            ret.y = Math.atan2(m.m02, m.m22);
            ret.z = Math.atan2(m.m10, m.m11);
        }
        return ret;
    }

    public static Matrix3d quat2matrix(Quat4d q) {
        Matrix3d m = new Matrix3d();
        m.m00 = 1.0 - 2.0 * q.y * q.y - 2.0 * q.z * q.z;
        m.m01 = 2.0 * q.x * q.y - 2.0 * q.w * q.z;
        m.m02 = 2.0 * q.x * q.z + 2.0 * q.w * q.y;
        m.m10 = 2.0 * q.x * q.y + 2.0 * q.w * q.z;
        m.m11 = 1.0 - 2.0 * q.x * q.x - 2.0 * q.z * q.z;
        m.m12 = 2.0 * q.y * q.z - 2.0 * q.w * q.x;
        m.m20 = 2.0 * q.x * q.z - 2.0 * q.w * q.y;
        m.m21 = 2.0 * q.y * q.z + 2.0 * q.w * q.x;
        m.m22 = 1.0 - 2.0 * q.x * q.x - 2.0 * q.y * q.y;
        return m;
    }

    public static Quat4d matrix2quat(Matrix3d m) {
        double[] elem = new double[]{m.m00 - m.m11 - m.m22 + 1.0, -m.m00 + m.m11 - m.m22 + 1.0, -m.m00 - m.m11 + m.m22 + 1.0, m.m00 + m.m11 + m.m22 + 1.0};
        int biggestIndex = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(elem[i] > elem[biggestIndex])) continue;
            biggestIndex = i;
        }
        if (elem[biggestIndex] < 0.0) {
            return null;
        }
        double v = Math.sqrt(elem[biggestIndex]) * 0.5;
        double mult = 0.25 / v;
        Quat4d q = new Quat4d();
        switch (biggestIndex) {
            case 0: {
                q.x = v;
                q.y = (m.m10 + m.m01) * mult;
                q.z = (m.m02 + m.m20) * mult;
                q.w = (m.m21 - m.m12) * mult;
                break;
            }
            case 1: {
                q.x = (m.m10 + m.m01) * mult;
                q.y = v;
                q.z = (m.m21 + m.m12) * mult;
                q.w = (m.m02 - m.m20) * mult;
                break;
            }
            case 2: {
                q.x = (m.m02 + m.m20) * mult;
                q.y = (m.m21 + m.m12) * mult;
                q.z = v;
                q.w = (m.m10 - m.m01) * mult;
                break;
            }
            case 3: {
                q.x = (m.m21 - m.m12) * mult;
                q.y = (m.m02 - m.m20) * mult;
                q.z = (m.m10 - m.m01) * mult;
                q.w = v;
            }
        }
        return q;
    }

    public static Quat4d a2bQuat(Vector3d a, Vector3d b) {
        double aLen = a.length();
        double bLen = b.length();
        double ct = a.dot(b) / aLen / bLen;
        double ct2 = Math.sqrt(0.5 * (1.0 + ct));
        double st2 = Math.sqrt(0.5 * (1.0 - ct));
        double k = Math.sqrt(bLen / aLen);
        Vector3d na = new Vector3d(a);
        na.normalize();
        Vector3d nb = new Vector3d(b);
        nb.normalize();
        Vector3d jiku = new Vector3d();
        jiku.cross(na, nb);
        if (jiku.length() < 1.0E-5) {
            if (ct > 0.0) {
                Quat4d ret = new Quat4d();
                ret.z = 0.0;
                ret.y = 0.0;
                ret.x = 0.0;
                ret.w = k;
                return ret;
            }
            Quat4d ret = new Quat4d();
            ret.w = 0.0;
            ret.z = 0.0;
            ret.x = 0.0;
            ret.y = k;
            return ret;
        }
        jiku.normalize();
        Quat4d ret = new Quat4d();
        ret.x = k * st2 * jiku.x;
        ret.y = k * st2 * jiku.y;
        ret.z = k * st2 * jiku.z;
        ret.w = k * ct2;
        return ret;
    }

    public static Quat4d frontFacingQuat(Vector3d oldFront, Vector3d oldTop, Vector3d newFront, Vector3d up) {
        Vector3d oldFrontN = new Vector3d(oldFront);
        oldFrontN.normalize();
        Vector3d oldTopN = new Vector3d(oldTop);
        oldTopN.normalize();
        Vector3d oldRightN = new Vector3d();
        oldRightN.cross(oldFrontN, oldTopN);
        Vector3d newFrontN = new Vector3d(newFront);
        newFrontN.normalize();
        Vector3d upN = new Vector3d(up);
        upN.normalize();
        Matrix3d a = new Matrix3d();
        a.m00 = oldRightN.x;
        a.m01 = oldTopN.x;
        a.m02 = oldFrontN.x;
        a.m10 = oldRightN.y;
        a.m11 = oldTopN.y;
        a.m12 = oldFrontN.y;
        a.m20 = oldRightN.z;
        a.m21 = oldTopN.z;
        a.m22 = oldFrontN.z;
        a.invert();
        double dTmp = upN.dot(newFrontN);
        Vector3d vTmp1 = new Vector3d(newFrontN);
        vTmp1.scale(dTmp);
        Vector3d newTopN = new Vector3d(upN);
        newTopN.sub((Tuple3d)vTmp1);
        newTopN.normalize();
        Vector3d newRightN = new Vector3d();
        newRightN.cross(newFrontN, newTopN);
        Matrix3d b = new Matrix3d();
        b.m00 = newRightN.x;
        b.m01 = newTopN.x;
        b.m02 = newFrontN.x;
        b.m10 = newRightN.y;
        b.m11 = newTopN.y;
        b.m12 = newFrontN.y;
        b.m20 = newRightN.z;
        b.m21 = newTopN.z;
        b.m22 = newFrontN.z;
        b.mul(a);
        Quat4d q = Util.matrix2quat(b);
        return q;
    }

    public static Quat4d frontFacingQuat_A3Y(Vector3d front, Vector3d up) {
        Vector3d frontN = new Vector3d(front);
        Vector3d upN = new Vector3d(up);
        upN.normalize();
        frontN.normalize();
        double d = frontN.dot(upN);
        Vector3d vTmp = new Vector3d(frontN);
        vTmp.scale(d);
        Vector3d top = new Vector3d(upN);
        top.sub((Tuple3d)vTmp);
        if (top.lengthSquared() < 1.0E-5) {
            frontN.set(0.0, 0.0, 1.0);
            top.set(0.0, 1.0, 0.0);
        } else {
            top.normalize();
        }
        Vector3d right = new Vector3d();
        right.cross(frontN, top);
        Matrix3d m = new Matrix3d();
        m.m00 = -right.x;
        m.m01 = top.x;
        m.m02 = frontN.x;
        m.m10 = -right.y;
        m.m11 = top.y;
        m.m12 = frontN.y;
        m.m20 = -right.z;
        m.m21 = top.z;
        m.m22 = frontN.z;
        Quat4d q = Util.matrix2quat(m);
        return q;
    }

    public static Quat4d frontFacingQuat_A3Z(Vector3d front, Vector3d up) {
        Vector3d frontN = new Vector3d(front);
        Vector3d upN = new Vector3d(up);
        upN.normalize();
        frontN.normalize();
        double d = frontN.dot(upN);
        Vector3d vTmp = new Vector3d(frontN);
        vTmp.scale(d);
        Vector3d top = new Vector3d(upN);
        top.sub((Tuple3d)vTmp);
        if (top.lengthSquared() < 1.0E-5) {
            frontN.set(0.0, -1.0, 0.0);
            top.set(0.0, 0.0, 1.0);
        } else {
            top.normalize();
        }
        Vector3d right = new Vector3d();
        right.cross(frontN, top);
        Matrix3d m = new Matrix3d();
        m.m00 = -right.x;
        m.m01 = -frontN.x;
        m.m02 = top.x;
        m.m10 = -right.y;
        m.m11 = -frontN.y;
        m.m12 = top.y;
        m.m20 = -right.z;
        m.m21 = -frontN.z;
        m.m22 = top.z;
        Quat4d q = Util.matrix2quat(m);
        return q;
    }

    public static Quat4d frontFacingQuat_CAMERA(Vector3d front, Vector3d up) {
        Vector3d frontN = new Vector3d(front);
        Vector3d upN = new Vector3d(up);
        upN.normalize();
        frontN.normalize();
        double d = frontN.dot(upN);
        Vector3d vTmp = new Vector3d(frontN);
        vTmp.scale(d);
        Vector3d top = new Vector3d(upN);
        top.sub((Tuple3d)vTmp);
        if (top.lengthSquared() < 1.0E-5) {
            frontN.set(0.0, 0.0, -1.0);
            top.set(0.0, 1.0, 0.0);
        } else {
            top.normalize();
        }
        Vector3d right = new Vector3d();
        right.cross(frontN, top);
        Matrix3d m = new Matrix3d();
        m.m00 = right.x;
        m.m01 = top.x;
        m.m02 = -frontN.x;
        m.m10 = right.y;
        m.m11 = top.y;
        m.m12 = -frontN.y;
        m.m20 = right.z;
        m.m21 = top.z;
        m.m22 = -frontN.z;
        Quat4d q = Util.matrix2quat(m);
        return q;
    }

    public static ConvexHullShape makeConvexHullShape(Node n) {
        ArrayList<Vector3f> vertexes1 = new ArrayList<Vector3f>();
        Util.listingVertexes(n, vertexes1);
        ConvexHullShape chs1 = new ConvexHullShape(vertexes1);
        float margin = chs1.getMargin();
        ShapeHull sh = new ShapeHull((ConvexShape)chs1);
        sh.buildHull(margin);
        List vertexes2 = sh.getVertexPointer();
        System.out.println("v1:" + vertexes1.size());
        System.out.println("v2:" + vertexes2.size());
        ConvexHullShape chs2 = new ConvexHullShape(vertexes2);
        return chs2;
    }

    static void listingVertexes(Node n, ArrayList<Vector3f> vertexes) {
        if (n instanceof Shape3D) {
            Shape3D s = (Shape3D)n;
            Transform3D t = new Transform3D();
            try {
                s.getLocalToVworld(t);
            }
            catch (Exception ee) {
                // empty catch block
            }
            int numGeo = s.numGeometries();
            for (int i = 0; i < numGeo; ++i) {
                Geometry geo = s.getGeometry(i);
                if (geo instanceof GeometryArray) {
                    GeometryArray ga = (GeometryArray)geo;
                    try {
                        int nn1 = ga.getVertexCount();
                        int nn3 = ga.getInitialVertexIndex();
                        Point3f p = new Point3f();
                        for (int j = nn3; j < nn1; ++j) {
                            ga.getCoordinate(j, p);
                            t.transform(p);
                            vertexes.add(new Vector3f((Tuple3f)p));
                        }
                        continue;
                    }
                    catch (Exception ee) {
                        continue;
                    }
                }
                System.out.println("Util.listingVertexes():" + geo.getClass().getName());
                System.out.print("  " + geo.getClass().getName());
                System.out.println(" is not GeometryArray.");
            }
        } else if (n instanceof Group) {
            Enumeration e = ((Group)n).getAllChildren();
            while (e.hasMoreElements()) {
                Util.listingVertexes((Node)e.nextElement(), vertexes);
            }
        } else if (n instanceof Link) {
            SharedGroup sg = ((Link)n).getSharedGroup();
            Enumeration e = sg.getAllChildren();
            while (e.hasMoreElements()) {
                Util.listingVertexes((Node)e.nextElement(), vertexes);
            }
        } else if (!(n instanceof Behavior)) {
            System.out.print("Util.listingVertexes().???: ");
            System.out.println(n.getClass().getName());
        }
    }

    public static Node loadVRML_A(URL url) throws Exception {
        VRML.initVRML();
        Scene scene = VRML.loader.load(url);
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)scene.getSceneGroup());
        for (Background background : scene.getBackgroundNodes()) {
            bg.addChild((Node)background);
        }
        for (Background background : scene.getFogNodes()) {
            bg.addChild((Node)background);
        }
        return bg;
    }

    public static Node loadVRML_B(URL url) throws Exception {
        VRML.initVRML();
        Scene scene = VRML.loader.load(url);
        BranchGroup bg = new BranchGroup();
        bg.addChild((Node)scene.getSceneGroup());
        return bg;
    }
}

