package jp.sourceforge.acerola3d.j3dvrml;

import java.awt.datatransfer.*;
import java.io.*;
import java.util.List;
import javax.swing.*;
import javax.swing.filechooser.FileNameExtensionFilter;

public class VrmlTransferHandler extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private FileNameExtensionFilter filter;
    private J3DVrml j3dvrml;

    public VrmlTransferHandler(J3DVrml j3dvrml) {
    	filter = new FileNameExtensionFilter("","wrl");
        this.j3dvrml = j3dvrml;
    }

    public boolean canImport(TransferSupport support) {
        // クリップボード経由のデータ転送は扱わない
        if (!support.isDrop()) {
            return false;
        }

        // ファイル以外のフレーバーは受け入れない
        if (!support.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }

        // ドロップする位置を常に表示する
        support.setShowDropLocation(true);

        return true;
    }

    public int getSourceActions(JComponent c) {
        return COPY_OR_MOVE;
    }

    @SuppressWarnings("unchecked")
    public boolean importData(TransferSupport support) {
        if (!canImport(support)) {
            return false;
        }

        try {
            Object obj = support.getTransferable()
                .getTransferData(DataFlavor.javaFileListFlavor);
            File file = ((List<File>)obj).get(0);

            if (file!=null) {
            	if (filter.accept(file)) {
                    j3dvrml.loadVRML(file);
            	}
            }

            return true;
        } catch (UnsupportedFlavorException ex) {
            // 失敗したら false を返すだけ
        } catch (Exception ex) {
            // 失敗したら false を返すだけ
        }

        return false;
    }
}
