/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3Controller;
import jp.sourceforge.acerola3d.a3.A3Event;
import jp.sourceforge.acerola3d.a3.A3Object;

class EditController
extends A3Controller {
    int lastMouseX;
    int lastMouseY;

    EditController() {
    }

    @Override
    public void init() {
        this.lastMouseX = 0;
        this.lastMouseY = 0;
    }

    @Override
    public void mousePressed(A3Event ae) {
        MouseEvent me = ae.getMouseEvent();
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
    }

    @Override
    public void mouseDragged(A3Event ae) {
        A3Object a3 = ae.getA3Object();
        if (a3 == null) {
            return;
        }
        MouseEvent me = ae.getMouseEvent();
        if ((me.getModifiersEx() & 0x400) != 0) {
            Vector3d v = a3.getLoc();
            v = this.a3canvas.virtualCSToPhysicalCS(v);
            Point3d vTmp1 = this.a3canvas.canvasToPhysicalCS(this.lastMouseX, this.lastMouseY, -v.z);
            Point3d vTmp2 = this.a3canvas.canvasToPhysicalCS(me.getX(), me.getY(), -v.z);
            v.sub((Tuple3d)vTmp2, (Tuple3d)vTmp1);
            if ((me.getModifiers() & 1) != 0) {
                v.set(v.x, 0.0, -v.y);
            }
            v = this.a3canvas.physicalCSToVirtualCS(v);
            v.sub((Tuple3d)this.a3canvas.getCameraLoc());
            v.add((Tuple3d)a3.getLoc());
            a3.setLocImmediately(v);
        } else if ((me.getModifiersEx() & 0x800) != 0) {
            double s = (double)(100 - (me.getY() - this.lastMouseY)) / 100.0;
            a3.setScaleImmediately(s *= a3.getScale());
        } else if ((me.getModifiersEx() & 0x1000) != 0) {
            int shiftX = me.getX() - this.lastMouseX;
            int shiftY = me.getY() - this.lastMouseY;
            Quat4d q0 = new Quat4d(0.0, 0.0, 0.0, 1.0);
            double t = (double)shiftX * 0.01;
            Quat4d q1 = new Quat4d(0.0, Math.sin(t), 0.0, Math.cos(t));
            t = (double)shiftY * 0.01;
            Quat4d q2 = new Quat4d(Math.sin(t), 0.0, 0.0, Math.cos(t));
            q0.mul(q1);
            q0.mul(q2);
            Quat4d cameraQ = this.a3canvas.getCameraQuat();
            q1.set(q0.x, q0.y, q0.z, 0.0);
            q2.mul(cameraQ, q1);
            cameraQ.conjugate();
            q2.mul(cameraQ);
            q0.x = q2.x;
            q0.y = q2.y;
            q0.z = q2.z;
            q1 = a3.getQuat();
            q0.mul(q1);
            a3.setQuatImmediately(q0);
        }
        this.lastMouseX = me.getX();
        this.lastMouseY = me.getY();
    }

    @Override
    public void mouseReleased(A3Event ae) {
    }

    @Override
    public void mouseClicked(A3Event ae) {
    }

    @Override
    public void mouseDoubleClicked(A3Event ae) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

