/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.j3d.loaders.vrml97.impl;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.ExponentialFog;
import javax.media.j3d.LinearFog;
import javax.media.j3d.Node;
import org.jdesktop.j3d.loaders.vrml97.impl.BindableNode;
import org.jdesktop.j3d.loaders.vrml97.impl.Loader;
import org.jdesktop.j3d.loaders.vrml97.impl.RGroup;
import org.jdesktop.j3d.loaders.vrml97.impl.SFBool;
import org.jdesktop.j3d.loaders.vrml97.impl.SFColor;
import org.jdesktop.j3d.loaders.vrml97.impl.SFFloat;
import org.jdesktop.j3d.loaders.vrml97.impl.SFString;
import org.jdesktop.j3d.loaders.vrml97.impl.SFTime;
import vrml.BaseNode;

public class Fog
extends BindableNode {
    SFColor color;
    SFString fogType;
    SFFloat visibilityRange;
    BranchGroup fogImpl;
    javax.media.j3d.Fog fog;

    public Fog(Loader loader) {
        super(loader, loader.getFogStack());
        this.color = new SFColor(1.0f, 1.0f, 1.0f);
        this.fogType = new SFString("LINEAR");
        this.visibilityRange = new SFFloat(0.0f);
        loader.addFog(this);
        this.initFields();
    }

    Fog(Loader loader, SFBool bind, SFTime bindTime, SFBool isBound, SFColor color, SFString fogType, SFFloat visibilityRange) {
        super(loader, loader.getFogStack(), bind, bindTime, isBound);
        this.color = color;
        this.fogType = fogType;
        this.visibilityRange = visibilityRange;
        loader.addFog(this);
        this.initFields();
    }

    public void initImpl() {
        if (this.fogType.getValue().equals("LINEAR")) {
            LinearFog linearFog = new LinearFog(this.color.color[0], this.color.color[1], this.color.color[2]);
            linearFog.setCapability(17);
            linearFog.setBackDistance((double)this.visibilityRange.getValue());
            linearFog.setFrontDistance((double)this.visibilityRange.getValue() / 10.0);
            this.fog = linearFog;
        } else {
            ExponentialFog expFog = new ExponentialFog(this.color.color[0], this.color.color[1], this.color.color[2]);
            expFog.setCapability(17);
            expFog.setDensity(this.visibilityRange.getValue());
            this.fog = expFog;
        }
        this.fog.setCapability(14);
        this.fog.setCapability(15);
        this.fogImpl = new RGroup();
        if ((double)this.visibilityRange.getValue() == 0.0) {
            this.fog.setInfluencingBounds(this.loader.zeroBounds);
        } else {
            this.fog.setInfluencingBounds(this.loader.infiniteBounds);
        }
        this.fogImpl.addChild((Node)this.fog);
        this.implReady = true;
    }

    public BranchGroup getFogImpl() {
        return this.fogImpl;
    }

    public void initFields() {
        this.initBindableFields();
        this.color.init(this, this.FieldSpec, 3, "color");
        this.fogType.init(this, this.FieldSpec, 3, "fogType");
        this.visibilityRange.init(this, this.FieldSpec, 3, "visibilityRange");
    }

    public Object clone() {
        return new Fog(this.loader, (SFBool)this.bind.clone(), this.bindTime, this.isBound, (SFColor)this.color.clone(), (SFString)this.fogType.clone(), (SFFloat)this.visibilityRange.clone());
    }

    public BaseNode wrap() {
        return new org.jdesktop.j3d.loaders.vrml97.node.Fog(this);
    }

    public String getType() {
        return "Fog";
    }
}

