/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.apng;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import jp.sourceforge.acerola3d.apng.APNGImageReader;
import jp.sourceforge.acerola3d.apng.Chunk;

class Frame {
    APNGImageReader apng;
    int width;
    int height;
    int x_offset;
    int y_offset;
    short delay_num;
    short delay_den;
    byte dispose_op;
    byte blend_op;
    BufferedImage image;
    ByteArrayOutputStream tmpData = new ByteArrayOutputStream();

    public Frame(APNGImageReader apng, Chunk c, int seq) throws IOException {
        this.apng = apng;
        if (c == null) {
            this.width = apng.width;
            this.height = apng.height;
        } else {
            DataInputStream dis = c.getDataInputStream();
            int dSeq = dis.readInt();
            if (seq != dSeq) {
                System.out.println("ERROR!: seq!=dSeq: " + seq + "," + dSeq);
            }
            this.width = dis.readInt();
            this.height = dis.readInt();
            this.x_offset = dis.readInt();
            this.y_offset = dis.readInt();
            this.delay_num = dis.readShort();
            this.delay_den = dis.readShort();
            this.dispose_op = dis.readByte();
            this.blend_op = dis.readByte();
        }
    }

    public String toString() {
        String ret = "";
        ret = ret + "Frame:\n";
        ret = ret + "  width=" + this.width + "\n";
        ret = ret + "  height=" + this.height + "\n";
        ret = ret + "  x_offset=" + this.x_offset + "\n";
        ret = ret + "  y_offset=" + this.y_offset + "\n";
        ret = ret + "  delay_num=" + this.delay_num + "\n";
        ret = ret + "  delay_den=" + this.delay_den + "\n";
        ret = ret + "  dispose_op=" + this.dispose_op + "\n";
        ret = ret + "  blend_op=" + this.blend_op + "\n";
        return ret;
    }

    void addChunk(Chunk c, int seq) {
        if (c.typeStr.equals("IDAT")) {
            this.tmpData.write(c.data, 0, c.data.length);
        } else if (c.typeStr.equals("fdAT")) {
            int dSeq = 0;
            dSeq |= 0xFF & c.data[0];
            dSeq <<= 8;
            dSeq |= 0xFF & c.data[1];
            dSeq <<= 8;
            dSeq |= 0xFF & c.data[2];
            dSeq <<= 8;
            if (seq != (dSeq |= 0xFF & c.data[3])) {
                System.out.println("ERROR!: seq!=dSeq: " + seq + "," + dSeq);
            }
            this.tmpData.write(c.data, 4, c.data.length - 4);
        }
    }

    void createImage() throws DataFormatException {
        int y;
        int x;
        byte[] bs = this.tmpData.toByteArray();
        Inflater inflater = new Inflater();
        inflater.setInput(bs);
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        do {
            int size = inflater.inflate(buffer);
            baos.write(buffer, 0, size);
        } while (!inflater.finished());
        inflater.end();
        bs = baos.toByteArray();
        int bpp = 1;
        switch (this.apng.colorType) {
            case 0: {
                bpp = this.apng.bitDepth > 8 ? 2 : 1;
                break;
            }
            case 2: {
                bpp = this.apng.bitDepth > 8 ? 6 : 3;
                break;
            }
            case 3: {
                bpp = 1;
                break;
            }
            case 4: {
                bpp = this.apng.bitDepth > 8 ? 4 : 2;
                break;
            }
            case 6: {
                bpp = this.apng.bitDepth > 8 ? 8 : 4;
            }
        }
        byte ft = 0;
        block15: for (int idx = 0; idx < bs.length; ++idx) {
            if (idx % (1 + bpp * this.width) == 0) {
                ft = bs[idx];
                continue;
            }
            x = (idx % (1 + bpp * this.width) - 1) / bpp;
            y = idx / (1 + bpp * this.width);
            int m = 0xFF & bs[idx];
            int w = 0;
            int n = 0;
            int nw = 0;
            if (x != 0) {
                w = 0xFF & bs[idx - bpp];
            }
            if (y != 0) {
                n = 0xFF & bs[idx - (1 + bpp * this.width)];
            }
            if (x != 0 && y != 0) {
                nw = 0xFF & bs[idx - bpp - (1 + bpp * this.width)];
            }
            switch (ft) {
                case 0: {
                    bs[idx] = (byte)this.filter0(m, w, n, nw);
                    continue block15;
                }
                case 1: {
                    bs[idx] = (byte)this.filter1(m, w, n, nw);
                    continue block15;
                }
                case 2: {
                    bs[idx] = (byte)this.filter2(m, w, n, nw);
                    continue block15;
                }
                case 3: {
                    bs[idx] = (byte)this.filter3(m, w, n, nw);
                    continue block15;
                }
                case 4: {
                    bs[idx] = (byte)this.filter4(m, w, n, nw);
                }
            }
        }
        BufferedImage bi = new BufferedImage(this.width, this.height, 2);
        if (this.apng.colorType != 0 && this.apng.colorType != 2) {
            if (this.apng.colorType == 3) {
                for (x = 0; x < this.width; ++x) {
                    for (y = 0; y < this.height; ++y) {
                        Integer a;
                        byte idx = bs[1 + bpp * x + (1 + bpp * this.width) * y];
                        int alp = -1;
                        if (this.apng.alpha != null && (a = this.apng.alpha.get(idx)) != null) {
                            alp = (byte)a.intValue();
                        }
                        byte[] rgb = this.apng.palette[0xFF & idx];
                        int argb = 0;
                        argb |= 0xFF & alp;
                        argb <<= 8;
                        argb |= 0xFF & rgb[0];
                        argb <<= 8;
                        argb |= 0xFF & rgb[1];
                        argb <<= 8;
                        bi.setRGB(x, y, argb |= 0xFF & rgb[2]);
                    }
                }
            } else if (this.apng.colorType != 4 && this.apng.colorType == 6) {
                for (x = 0; x < this.width; ++x) {
                    for (y = 0; y < this.height; ++y) {
                        byte r = bs[1 + 4 * x + (1 + bpp * this.width) * y + 0];
                        byte g = bs[1 + 4 * x + (1 + bpp * this.width) * y + 1];
                        byte b = bs[1 + 4 * x + (1 + bpp * this.width) * y + 2];
                        byte a = bs[1 + 4 * x + (1 + bpp * this.width) * y + 3];
                        int argb = 0;
                        argb |= 0xFF & a;
                        argb <<= 8;
                        argb |= 0xFF & r;
                        argb <<= 8;
                        argb |= 0xFF & g;
                        argb <<= 8;
                        bi.setRGB(x, y, argb |= 0xFF & b);
                    }
                }
            }
        }
        this.tmpData.reset();
        this.image = bi;
    }

    int filter0(int m, int w, int n, int nw) {
        return m;
    }

    int filter1(int m, int w, int n, int nw) {
        return m + w;
    }

    int filter2(int m, int w, int n, int nw) {
        return m + n;
    }

    int filter3(int m, int w, int n, int nw) {
        return m + (w + n) / 2;
    }

    int filter4(int m, int w, int n, int nw) {
        return m + this.paethPredictor(w, n, nw);
    }

    int paethPredictor(int a, int b, int c) {
        int p = a + b - c;
        int pa = Math.abs(p - a);
        int pb = Math.abs(p - b);
        int pc = Math.abs(p - c);
        if (pa <= pb && pa <= pc) {
            return a;
        }
        if (pb <= pc) {
            return b;
        }
        return c;
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

