/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import com.sun.j3d.utils.scenegraph.io.SceneGraphIO;
import com.sun.j3d.utils.scenegraph.io.SceneGraphObjectReferenceControl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.Node;
import javax.media.j3d.NodeReferenceTable;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.sf.nwn.loader.AnimationBehavior;
import net.sf.nwn.loader.EmitterNode;
import net.sf.nwn.loader.ParticleCollection;

public class EmitterBehavior
extends Behavior
implements GeometryUpdater,
SceneGraphIO {
    private WakeupOnElapsedFrames wakeup = new WakeupOnElapsedFrames(0, false);
    private ParticleCollection pc;
    private int maxParticles;
    private float[] life;
    private float[] position;
    private float[] velocity;
    private long lastTime = AnimationBehavior.getTime();
    private float partialBirth;
    private Color3f colorStart;
    private Color3f colorEnd;
    private float alphaStart;
    private float alphaEnd;
    private float sizeStart;
    private float sizeEnd;
    private float sizeStart_y;
    private float sizeEnd_y;
    private int frameStart;
    private int frameEnd;
    private float birthrate;
    private float lifeExp;
    private float mass;
    private float spread;
    private float particleRot;
    private float startVelocity;
    private float randvel;
    private float fps;
    private float xsize;
    private float ysize;
    private int blend;
    private int xgrid;
    private int ygrid;
    private int render;
    private int p2pType;
    private float grav;
    private float drag;
    private int inheritType;
    private int update;
    private Transform3D eyeT = new Transform3D();
    private Transform3D eyeTI = new Transform3D();
    private Vector3f velVec = new Vector3f();
    private Vector3f dirVec = new Vector3f();
    private Point3f pos = new Point3f();
    private float[] tcoords = new float[]{0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.5f, 0.5f, 0.0f};
    private static float BIRTH_GRID_SCALE = 0.01f;
    private static float EMITTER_TIME_SCALE = 1.0f;
    private static Canvas3D canvas;
    private int particleCollectionReference;
    public static float ACTIVATION_RADIUS;
    public static int INHERIT_WORLD;
    public static int INHERIT_POSITION;
    public static int INHERIT_ALL;

    public EmitterBehavior() {
    }

    public EmitterBehavior(EmitterNode emitterNode, TransformGroup transformGroup, Appearance appearance) {
        this.setSchedulingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), (double)ACTIVATION_RADIUS));
        this.colorStart = emitterNode.getColorStart();
        this.colorEnd = emitterNode.getColorEnd();
        this.alphaStart = emitterNode.getAlphaStart();
        this.alphaEnd = emitterNode.getAlphaEnd();
        this.sizeStart = emitterNode.getSizeStart();
        this.sizeEnd = emitterNode.getSizeEnd();
        this.sizeStart_y = emitterNode.getSizeStart_y();
        this.sizeEnd_y = emitterNode.getSizeEnd_y();
        this.frameStart = emitterNode.getFrameStart();
        this.frameEnd = emitterNode.getFrameEnd();
        this.birthrate = emitterNode.getBirthrate();
        this.lifeExp = emitterNode.getLifeExp();
        this.mass = emitterNode.getMass();
        this.spread = emitterNode.getSpread();
        this.particleRot = emitterNode.getParticleRot();
        this.startVelocity = emitterNode.getVelocity();
        this.randvel = emitterNode.getRandvel();
        this.fps = emitterNode.getFps();
        this.xsize = emitterNode.getXsize();
        this.ysize = emitterNode.getYsize();
        this.blend = emitterNode.getBlend();
        this.xgrid = emitterNode.getXgrid();
        this.ygrid = emitterNode.getYgrid();
        this.render = emitterNode.getRender();
        this.p2pType = emitterNode.getP2pType();
        this.grav = emitterNode.getGrav();
        this.drag = emitterNode.getDrag();
        this.update = emitterNode.getUpdate();
        this.maxParticles = this.update == 2 ? 1 : (int)Math.ceil(this.birthrate * this.lifeExp) + 2;
        this.pc = new ParticleCollection(this.maxParticles, appearance);
        this.life = new float[this.maxParticles];
        this.position = new float[this.maxParticles * 3];
        this.velocity = new float[this.maxParticles * 3];
        this.inheritType = emitterNode.getInherit() == 1 ? INHERIT_ALL : (emitterNode.getInherit_local() == 1 ? INHERIT_WORLD : (emitterNode.getInherit_part() == 1 ? INHERIT_POSITION : INHERIT_ALL));
        for (int i = 0; i < this.maxParticles; ++i) {
            this.life[i] = -1.0f;
        }
        transformGroup.addChild((Node)this.pc);
        if (this.particleRot != 0.0f && this.render == 2) {
            System.err.println("WARN: particleRot and motionBlur are not possible together - turning off particleRotation");
        }
    }

    public void initialize() {
        this.wakeupOn((WakeupCondition)this.wakeup);
    }

    public void processStimulus(Enumeration enumeration) {
        this.wakeupOn((WakeupCondition)this.wakeup);
        this.pc.updateGeometry(this);
    }

    public void updateData(Geometry geometry) {
        if (canvas == null) {
            canvas = this.getView().getCanvas3D(0);
        }
        canvas.getImagePlateToVworld(this.eyeT);
        this.eyeT.setScale(1.0);
        this.eyeTI.invert(this.eyeT);
        this.pc.updateTransforms(this.eyeT);
        Transform3D transform3D = this.pc.getLocalTransform();
        Transform3D transform3D2 = this.pc.getLocalTransformI();
        Vector3f vector3f = this.pc.getEyeVector();
        long l = AnimationBehavior.getTime();
        float f = (float)((double)(l - this.lastTime) / AnimationBehavior.TIMER_SCALE) * EMITTER_TIME_SCALE;
        this.lastTime = l;
        f = (float)Math.min((double)f, 0.05);
        this.partialBirth += f * this.birthrate;
        int n = 0;
        int n2 = 0;
        while (n < this.maxParticles) {
            float f2;
            this.pos.set(this.position[n2], this.position[n2 + 1], this.position[n2 + 2]);
            if (this.inheritType == INHERIT_WORLD) {
                transform3D2.transform(this.pos);
            } else if (this.inheritType == INHERIT_POSITION) {
                this.dirVec.set((Tuple3f)this.pos);
                transform3D2.transform(this.dirVec);
                this.pos.set((Tuple3f)this.dirVec);
            }
            if (this.life[n] < 0.0f) {
                if (this.update == 2 || this.partialBirth > 1.0f) {
                    this.partialBirth -= 1.0f;
                    this.life[n] = 0.0f;
                    this.pos.x = (float)((Math.random() - 0.5) * (double)this.xsize * (double)BIRTH_GRID_SCALE);
                    this.pos.y = (float)((Math.random() - 0.5) * (double)this.ysize * (double)BIRTH_GRID_SCALE);
                    this.pos.z = 0.0f;
                    double d = (double)this.startVelocity + (Math.random() - 0.5) * (double)this.randvel * 2.0;
                    double d2 = (Math.random() - 0.5) * (double)this.spread;
                    double d3 = (Math.random() - 0.5) * (double)this.spread;
                    double d4 = Math.sin(d2);
                    double d5 = Math.sin(d3);
                    double d6 = Math.cos(d2) + Math.cos(d3);
                    double d7 = d / (Math.abs(d4) + Math.abs(d5) + Math.abs(d6));
                    this.velocity[n2] = (float)(d7 * d4);
                    this.velocity[n2 + 1] = (float)(d7 * d5);
                    this.velocity[n2 + 2] = (float)(d7 * d6);
                }
            } else if (this.update == 2 || this.life[n] < this.lifeExp) {
                this.dirVec.set(0.0f, 0.0f, -this.mass * f * 10.0f);
                transform3D2.transform(this.dirVec);
                int n3 = n2;
                this.velocity[n3] = this.velocity[n3] + this.dirVec.x;
                int n4 = n2 + 1;
                this.velocity[n4] = this.velocity[n4] + this.dirVec.y;
                int n5 = n2 + 2;
                this.velocity[n5] = this.velocity[n5] + this.dirVec.z;
                if (this.p2pType == 2) {
                    f2 = Math.abs(this.pos.x) + Math.abs(this.pos.y) + Math.abs(this.pos.z);
                    int n6 = n2;
                    this.velocity[n6] = this.velocity[n6] - f * this.grav * this.pos.x / f2;
                    int n7 = n2 + 1;
                    this.velocity[n7] = this.velocity[n7] - f * this.grav * this.pos.y / f2;
                    int n8 = n2 + 2;
                    this.velocity[n8] = this.velocity[n8] - f * this.grav * this.pos.z / f2;
                }
                this.pos.x += this.velocity[n2] * f;
                this.pos.y += this.velocity[n2 + 1] * f;
                this.pos.z += this.velocity[n2 + 2] * f;
                int n9 = n;
                this.life[n9] = this.life[n9] + f;
                if (this.p2pType == 2 && this.pos.x * (this.pos.x - this.velocity[n2] * f) < 0.0f) {
                    int n10 = n2;
                    this.velocity[n10] = this.velocity[n10] * this.drag;
                    int n11 = n2 + 1;
                    this.velocity[n11] = this.velocity[n11] * this.drag;
                    int n12 = n2 + 2;
                    this.velocity[n12] = this.velocity[n12] * this.drag;
                }
            } else {
                this.life[n] = -1.0f;
            }
            if ((f2 = this.life[n]) < 0.0f) {
                this.pc.updateParticle(n, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, this.tcoords);
            } else {
                float f3;
                float f4 = f2 / this.lifeExp;
                if (this.update == 2) {
                    f4 = 0.0f;
                }
                Color3f color3f = this.colorStart;
                Color3f color3f2 = this.colorEnd;
                float f5 = color3f.x + (color3f2.x - color3f.x) * f4;
                float f6 = color3f.y + (color3f2.y - color3f.y) * f4;
                float f7 = color3f.z + (color3f2.z - color3f.z) * f4;
                float f8 = this.alphaStart + (this.alphaEnd - this.alphaStart) * f4;
                float f9 = f3 = this.sizeStart + (this.sizeEnd - this.sizeStart) * f4;
                if (this.sizeStart_y != 0.0f || this.sizeEnd_y != 0.0f) {
                    f9 = this.sizeStart_y + (this.sizeEnd_y - this.sizeStart_y) * f4;
                }
                float f10 = 1.0f / (float)this.xgrid;
                float f11 = 1.0f / (float)this.ygrid;
                int n13 = this.frameStart + (int)(this.fps * f2) % (this.frameEnd + 1 - this.frameStart);
                float f12 = f10 * (float)(n13 % this.xgrid);
                float f13 = f10 * (float)(n13 / this.xgrid % this.ygrid);
                float f14 = f2 * this.particleRot;
                this.tcoords[0] = f12;
                this.tcoords[1] = f13;
                this.tcoords[2] = f12;
                this.tcoords[3] = f13 + f11;
                this.tcoords[4] = f12 + f10;
                this.tcoords[5] = f13 + f11;
                this.tcoords[6] = f12 + f10;
                this.tcoords[7] = f13;
                if (this.render == 2) {
                    this.velVec.set(this.velocity[n2], this.velocity[n2 + 1], this.velocity[n2 + 2]);
                    float f15 = this.velVec.length();
                    transform3D.transform(this.velVec);
                    this.velVec.normalize();
                    float f16 = Math.abs(this.velVec.dot(vector3f));
                    float f17 = 1.0f * f15;
                    f17 = Math.min(f17, f15 * f2);
                    f9 = f9 * f16 + f17 * (1.0f - f16);
                    this.eyeTI.transform(this.velVec);
                    this.velVec.z = 0.0f;
                    this.dirVec.set(0.0f, 1.0f, 0.0f);
                    f14 = this.velVec.angle(this.dirVec);
                    if (this.velVec.x > 0.0f) {
                        f14 = -f14;
                    }
                } else if (this.render != 4 && this.render == 3) {
                    System.err.println("Render mode 'linked' not supported");
                }
                this.pc.updateParticle(n, this.pos.x, this.pos.y, this.pos.z, f3, f9, f14, f5, f6, f7, f8, this.tcoords);
            }
            if (this.inheritType == INHERIT_WORLD) {
                transform3D.transform(this.pos);
            } else if (this.inheritType == INHERIT_POSITION) {
                this.dirVec.set((Tuple3f)this.pos);
                transform3D.transform(this.dirVec);
                this.pos.set((Tuple3f)this.dirVec);
            }
            this.position[n2] = this.pos.x;
            this.position[n2 + 1] = this.pos.y;
            this.position[n2 + 2] = this.pos.z;
            ++n;
            n2 += 3;
        }
        if (this.update != 2 && this.partialBirth > 1.0f) {
            System.err.println("Partial birth " + this.partialBirth);
        }
    }

    public float getBirthrate() {
        return this.birthrate;
    }

    public void setBirthrate(float f) {
        this.birthrate = f;
    }

    public Node cloneNode(boolean bl) {
        EmitterBehavior emitterBehavior = new EmitterBehavior();
        emitterBehavior.duplicateNode((Node)this, bl);
        return emitterBehavior;
    }

    public void duplicateNode(Node node, boolean bl) {
        super.duplicateNode(node, bl);
        EmitterBehavior emitterBehavior = (EmitterBehavior)node;
        this.colorStart = emitterBehavior.colorStart;
        this.colorEnd = emitterBehavior.colorEnd;
        this.alphaStart = emitterBehavior.alphaStart;
        this.alphaEnd = emitterBehavior.alphaEnd;
        this.sizeStart = emitterBehavior.sizeStart;
        this.sizeEnd = emitterBehavior.sizeEnd;
        this.sizeStart_y = emitterBehavior.sizeStart_y;
        this.sizeEnd_y = emitterBehavior.sizeEnd_y;
        this.frameStart = emitterBehavior.frameStart;
        this.frameEnd = emitterBehavior.frameEnd;
        this.birthrate = emitterBehavior.birthrate;
        this.lifeExp = emitterBehavior.lifeExp;
        this.mass = emitterBehavior.mass;
        this.spread = emitterBehavior.spread;
        this.particleRot = emitterBehavior.particleRot;
        this.startVelocity = emitterBehavior.startVelocity;
        this.randvel = emitterBehavior.randvel;
        this.fps = emitterBehavior.fps;
        this.xsize = emitterBehavior.xsize;
        this.ysize = emitterBehavior.ysize;
        this.blend = emitterBehavior.blend;
        this.xgrid = emitterBehavior.xgrid;
        this.ygrid = emitterBehavior.ygrid;
        this.render = emitterBehavior.render;
        this.p2pType = emitterBehavior.p2pType;
        this.grav = emitterBehavior.grav;
        this.drag = emitterBehavior.drag;
        this.maxParticles = emitterBehavior.maxParticles;
        this.inheritType = emitterBehavior.inheritType;
        this.life = new float[this.maxParticles];
        this.position = new float[this.maxParticles * 3];
        this.velocity = new float[this.maxParticles * 3];
        for (int i = 0; i < this.maxParticles; ++i) {
            this.life[i] = -1.0f;
        }
        this.pc = emitterBehavior.pc;
    }

    public void updateNodeReferences(NodeReferenceTable nodeReferenceTable) {
        super.updateNodeReferences(nodeReferenceTable);
        this.pc = (ParticleCollection)nodeReferenceTable.getNewObjectReference((SceneGraphObject)this.pc);
    }

    public void createSceneGraphObjectReferences(SceneGraphObjectReferenceControl sceneGraphObjectReferenceControl) {
        this.particleCollectionReference = sceneGraphObjectReferenceControl.addReference((SceneGraphObject)this.pc);
    }

    public void readSceneGraphObject(DataInput dataInput) throws IOException {
        this.particleCollectionReference = dataInput.readInt();
        this.maxParticles = dataInput.readInt();
        this.colorStart = this.readColor(dataInput);
        this.colorEnd = this.readColor(dataInput);
        this.alphaStart = dataInput.readFloat();
        this.alphaEnd = dataInput.readFloat();
        this.sizeStart = dataInput.readFloat();
        this.sizeEnd = dataInput.readFloat();
        this.sizeStart_y = dataInput.readFloat();
        this.sizeEnd_y = dataInput.readFloat();
        this.frameStart = dataInput.readInt();
        this.frameEnd = dataInput.readInt();
        this.birthrate = dataInput.readFloat();
        this.lifeExp = dataInput.readFloat();
        this.mass = dataInput.readFloat();
        this.spread = dataInput.readFloat();
        this.particleRot = dataInput.readFloat();
        this.startVelocity = dataInput.readFloat();
        this.randvel = dataInput.readFloat();
        this.fps = dataInput.readFloat();
        this.xsize = dataInput.readFloat();
        this.ysize = dataInput.readFloat();
        this.blend = dataInput.readInt();
        this.xgrid = dataInput.readInt();
        this.ygrid = dataInput.readInt();
        this.render = dataInput.readInt();
        this.p2pType = dataInput.readInt();
        this.grav = dataInput.readFloat();
        this.drag = dataInput.readFloat();
        this.inheritType = dataInput.readInt();
        this.life = new float[this.maxParticles];
        this.position = new float[this.maxParticles * 3];
        this.velocity = new float[this.maxParticles * 3];
        for (int i = 0; i < this.maxParticles; ++i) {
            this.life[i] = -1.0f;
        }
        this.lastTime = AnimationBehavior.getTime();
        this.partialBirth = 0.0f;
    }

    public void restoreSceneGraphObjectReferences(SceneGraphObjectReferenceControl sceneGraphObjectReferenceControl) {
        this.pc = (ParticleCollection)sceneGraphObjectReferenceControl.resolveReference(this.particleCollectionReference);
    }

    public boolean saveChildren() {
        return false;
    }

    public void writeSceneGraphObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.particleCollectionReference);
        dataOutput.writeInt(this.maxParticles);
        this.writeColor(dataOutput, this.colorStart);
        this.writeColor(dataOutput, this.colorEnd);
        dataOutput.writeFloat(this.alphaStart);
        dataOutput.writeFloat(this.alphaEnd);
        dataOutput.writeFloat(this.sizeStart);
        dataOutput.writeFloat(this.sizeEnd);
        dataOutput.writeFloat(this.sizeStart_y);
        dataOutput.writeFloat(this.sizeEnd_y);
        dataOutput.writeInt(this.frameStart);
        dataOutput.writeInt(this.frameEnd);
        dataOutput.writeFloat(this.birthrate);
        dataOutput.writeFloat(this.lifeExp);
        dataOutput.writeFloat(this.mass);
        dataOutput.writeFloat(this.spread);
        dataOutput.writeFloat(this.particleRot);
        dataOutput.writeFloat(this.startVelocity);
        dataOutput.writeFloat(this.randvel);
        dataOutput.writeFloat(this.fps);
        dataOutput.writeFloat(this.xsize);
        dataOutput.writeFloat(this.ysize);
        dataOutput.writeInt(this.blend);
        dataOutput.writeInt(this.xgrid);
        dataOutput.writeInt(this.ygrid);
        dataOutput.writeInt(this.render);
        dataOutput.writeInt(this.p2pType);
        dataOutput.writeFloat(this.grav);
        dataOutput.writeFloat(this.drag);
        dataOutput.writeInt(this.inheritType);
    }

    private void writeColor(DataOutput dataOutput, Color3f color3f) throws IOException {
        dataOutput.writeFloat(color3f.x);
        dataOutput.writeFloat(color3f.y);
        dataOutput.writeFloat(color3f.z);
    }

    private Color3f readColor(DataInput dataInput) throws IOException {
        return new Color3f(dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat());
    }

    static {
        ACTIVATION_RADIUS = 15.0f;
        INHERIT_WORLD = 1;
        INHERIT_POSITION = 2;
        INHERIT_ALL = 3;
    }
}

