/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import java.net.URL;
import javax.media.j3d.Appearance;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3f;
import net.sf.nwn.loader.DummyGeomNode;
import net.sf.nwn.loader.EmitterBehavior;
import net.sf.nwn.loader.GeomNode;
import net.sf.nwn.loader.NWNUserData;
import net.sf.nwn.loader.TrimeshGeomNode;

public final class EmitterNode
extends DummyGeomNode {
    private Color3f colorStart;
    private Color3f colorEnd;
    private float alphaStart;
    private float alphaEnd;
    private float sizeStart;
    private float sizeEnd;
    private float sizeStart_y;
    private float sizeEnd_y;
    private int frameStart;
    private int frameEnd;
    private float birthrate;
    private float lifeExp;
    private float mass;
    private float spread;
    private float particleRot;
    private float velocity;
    private float randvel;
    private float fps;
    private int inherit;
    private int inherit_local;
    private int inherit_part;
    private float xsize;
    private float ysize;
    private int update;
    private int render;
    private int blend;
    private int p2pType;
    private float drag;
    private float grav;
    private String texture;
    private int xgrid;
    private int ygrid;
    private static Color3f black = new Color3f(0.0f, 0.0f, 0.0f);
    public static final int BLEND_LIGHTEN = 1;
    public static final int BLEND_NORMAL = 2;
    public static final int RENDER_NORMAL = 1;
    public static final int RENDER_MOTION_BLUR = 2;
    public static final int RENDER_LINKED = 3;
    public static final int RENDER_ALIGNED_TO_WORLD_Z = 4;
    public static final int P2P_TYPE_BEZIER = 1;
    public static final int P2P_TYPE_GRAVITY = 2;
    public static final int UPDATE_FOUNTAIN = 1;
    public static final int UPDATE_SINGLE = 2;
    public static final String EMITTER_POSTFIX = "%EMITTER";

    public EmitterNode(GeomNode geomNode) {
        super(geomNode);
    }

    public float getAlphaEnd() {
        return this.alphaEnd;
    }

    public void setAlphaEnd(float f) {
        this.alphaEnd = f;
    }

    public float getAlphaStart() {
        return this.alphaStart;
    }

    public void setAlphaStart(float f) {
        this.alphaStart = f;
    }

    public float getBirthrate() {
        return this.birthrate;
    }

    public void setBirthrate(float f) {
        this.birthrate = f;
    }

    public int getBlend() {
        return this.blend;
    }

    public void setBlend(int n) {
        this.blend = n;
    }

    public void setBlend(String string) {
        if (string.equalsIgnoreCase("Lighten")) {
            this.blend = 1;
        } else if (string.equalsIgnoreCase("Normal")) {
            this.blend = 2;
        } else {
            this.blend = 2;
            System.out.println("WARN: Unknown blend mode " + string);
        }
    }

    public Color3f getColorEnd() {
        return this.colorEnd;
    }

    public void setColorEnd(Color3f color3f) {
        this.colorEnd = color3f;
    }

    public Color3f getColorStart() {
        return this.colorStart;
    }

    public void setColorStart(Color3f color3f) {
        this.colorStart = color3f;
    }

    public float getFps() {
        return this.fps;
    }

    public void setFps(float f) {
        this.fps = f;
    }

    public int getFrameEnd() {
        return this.frameEnd;
    }

    public void setFrameEnd(int n) {
        this.frameEnd = n;
    }

    public int getFrameStart() {
        return this.frameStart;
    }

    public void setFrameStart(int n) {
        this.frameStart = n;
    }

    public float getLifeExp() {
        return this.lifeExp;
    }

    public void setLifeExp(float f) {
        this.lifeExp = f;
    }

    public float getMass() {
        return this.mass;
    }

    public void setMass(float f) {
        this.mass = f;
    }

    public float getRandvel() {
        return this.randvel;
    }

    public void setRandvel(float f) {
        this.randvel = f;
    }

    public float getSizeEnd() {
        return this.sizeEnd;
    }

    public void setSizeEnd(float f) {
        this.sizeEnd = f;
    }

    public float getSizeEnd_y() {
        return this.sizeEnd_y;
    }

    public void setSizeEnd_y(float f) {
        this.sizeEnd_y = f;
    }

    public float getSizeStart() {
        return this.sizeStart;
    }

    public void setSizeStart(float f) {
        this.sizeStart = f;
    }

    public float getSizeStart_y() {
        return this.sizeStart_y;
    }

    public void setSizeStart_y(float f) {
        this.sizeStart_y = f;
    }

    public float getSpread() {
        return this.spread;
    }

    public void setSpread(float f) {
        this.spread = f;
    }

    public String getTexture() {
        return this.texture;
    }

    public void setTexture(String string) {
        this.texture = string;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float f) {
        this.velocity = f;
    }

    public int getXgrid() {
        return this.xgrid;
    }

    public void setXgrid(int n) {
        this.xgrid = n;
    }

    public int getYgrid() {
        return this.ygrid;
    }

    public void setYgrid(int n) {
        this.ygrid = n;
    }

    public float getParticleRot() {
        return this.particleRot;
    }

    public void setParticleRot(float f) {
        this.particleRot = f;
    }

    public float getXsize() {
        return this.xsize;
    }

    public void setXsize(float f) {
        this.xsize = f;
    }

    public float getYsize() {
        return this.ysize;
    }

    public void setYsize(float f) {
        this.ysize = f;
    }

    public int getRender() {
        return this.render;
    }

    public void setRender(int n) {
        this.render = n;
    }

    public void setRender(String string) {
        if (string.equalsIgnoreCase("normal")) {
            this.render = 1;
        } else if (string.equalsIgnoreCase("motion_blur")) {
            this.render = 2;
        } else if (string.equalsIgnoreCase("linked")) {
            this.render = 3;
        } else if (string.equalsIgnoreCase("aligned_to_world_z")) {
            this.render = 4;
        } else {
            System.out.println("WARN: Unknown render type " + string);
            this.render = 1;
        }
    }

    public float getDrag() {
        return this.drag;
    }

    public void setDrag(float f) {
        this.drag = f;
    }

    public float getGrav() {
        return this.grav;
    }

    public void setGrav(float f) {
        this.grav = f;
    }

    public int getP2pType() {
        return this.p2pType;
    }

    public void setP2pType(int n) {
        this.p2pType = n;
    }

    public void setP2pType(String string) {
        if (string.equalsIgnoreCase("bezier")) {
            this.p2pType = 1;
        } else if (string.equalsIgnoreCase("gravity")) {
            this.p2pType = 2;
        } else {
            System.out.println("WARN: Unknown p2p_type " + string);
            this.p2pType = 1;
        }
    }

    @Override
    public void dumpSingle(StringBuffer stringBuffer) {
        super.dumpSingle(stringBuffer);
        stringBuffer.append("  colorStart ");
        this.dump(stringBuffer, (Tuple3f)this.colorStart);
        stringBuffer.append('\n');
        stringBuffer.append("  colorEnd ");
        this.dump(stringBuffer, (Tuple3f)this.colorEnd);
        stringBuffer.append('\n');
        stringBuffer.append("  alphaStart ").append(this.alphaStart).append('\n');
        stringBuffer.append("  alphaEnd ").append(this.alphaEnd).append('\n');
        stringBuffer.append("  sizeStart ").append(this.sizeStart).append('\n');
        stringBuffer.append("  sizeEnd ").append(this.sizeEnd).append('\n');
        stringBuffer.append("  sizeStart_y ").append(this.sizeStart_y).append('\n');
        stringBuffer.append("  sizeEnd_y ").append(this.sizeEnd_y).append('\n');
    }

    @Override
    public TransformGroup createSingleTG(URL uRL, boolean bl) {
        TransformGroup transformGroup = super.createSingleTG(uRL, bl);
        EmitterBehavior emitterBehavior = new EmitterBehavior(this, transformGroup, this.createAppearance(uRL));
        emitterBehavior.setUserData(new NWNUserData(this.getName() + EMITTER_POSTFIX, (Node)emitterBehavior));
        transformGroup.addChild((Node)emitterBehavior);
        return transformGroup;
    }

    private Appearance createAppearance(URL uRL) {
        Appearance appearance = new Appearance();
        Texture texture = TrimeshGeomNode.findTexture(uRL, this.texture);
        appearance.setTexture(texture);
        Material material = new Material(black, black, black, black, 64.0f);
        appearance.setMaterial(material);
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(2);
        textureAttributes.setPerspectiveCorrectionMode(0);
        appearance.setTextureAttributes(textureAttributes);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setTransparencyMode(2);
        if (this.blend == 1) {
            transparencyAttributes.setSrcBlendFunction(2);
            transparencyAttributes.setDstBlendFunction(1);
        } else {
            transparencyAttributes.setSrcBlendFunction(2);
            transparencyAttributes.setDstBlendFunction(3);
        }
        appearance.setTransparencyAttributes(transparencyAttributes);
        return appearance;
    }

    public int getInherit() {
        return this.inherit;
    }

    public void setInherit(int n) {
        this.inherit = n;
    }

    public int getInherit_local() {
        return this.inherit_local;
    }

    public void setInherit_local(int n) {
        this.inherit_local = n;
    }

    public int getInherit_part() {
        return this.inherit_part;
    }

    public void setInherit_part(int n) {
        this.inherit_part = n;
    }

    public int getUpdate() {
        return this.update;
    }

    public void setUpdate(int n) {
        this.update = n;
    }

    public void setUpdate(String string) {
        if (string.equalsIgnoreCase("fountain")) {
            this.update = 1;
        } else if (string.equalsIgnoreCase("single")) {
            this.update = 2;
        } else {
            System.err.println("WARN: Unknown update type " + string);
            this.update = 1;
        }
    }
}

