/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;

public abstract class Node {
    protected Node supernode;
    private String name;
    protected LinkedHashMap children = new LinkedHashMap();

    public Node(Node node) {
        this.supernode = node;
    }

    public void setSupernode(Node node) {
        this.supernode = node;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.toLowerCase();
    }

    public String getType() {
        return "unknown";
    }

    public void addChild(Node node) {
        this.children.put(node.getName(), node);
    }

    public boolean containsChild(String string) {
        return this.findChild(string) != null;
    }

    public Node findChild(String string) {
        Node node = (Node)this.children.get(string);
        if (node != null) {
            return node;
        }
        for (Node node2 : this.children.values()) {
            node = node2.findChild(string);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public int getDepth() {
        int n = 0;
        Node node = this.supernode;
        while (node != null) {
            ++n;
            node = node.supernode;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = this.getDepth();
        while (n-- > 0) {
            stringBuffer.append("    ");
        }
        stringBuffer.append(this.getName()).append('(').append(this.getType());
        stringBuffer.append(')');
        Iterator iterator = this.children.values().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n").append(iterator.next());
        }
        return stringBuffer.toString();
    }

    public void dumpSingle(StringBuffer stringBuffer) {
        stringBuffer.append("node ").append(this.getType()).append(" ").append(this.getName()).append("\n");
        if (this.supernode == null) {
            stringBuffer.append("parent NULL\n");
        } else {
            stringBuffer.append("parent ").append(this.supernode.getName()).append("\n");
        }
    }

    public void dump(StringBuffer stringBuffer) {
        this.dumpSingle(stringBuffer);
        stringBuffer.append("endnode\n");
        for (Node node : this.children.values()) {
            node.dump(stringBuffer);
        }
    }

    protected void dump(StringBuffer stringBuffer, Tuple2f tuple2f) {
        stringBuffer.append(tuple2f.x).append(' ').append(tuple2f.y);
    }

    protected void dump(StringBuffer stringBuffer, Tuple3f tuple3f) {
        stringBuffer.append(tuple3f.x).append(' ').append(tuple3f.y).append(' ').append(tuple3f.z);
    }

    protected void dump(StringBuffer stringBuffer, AxisAngle4f axisAngle4f) {
        stringBuffer.append(axisAngle4f.x).append(' ').append(axisAngle4f.y).append(' ').append(axisAngle4f.z).append(' ').append(axisAngle4f.angle);
    }
}

