/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.viewer;

import com.sun.j3d.demos.utils.scenegraph.traverser.AppearanceChangeProcessor;
import com.sun.j3d.demos.utils.scenegraph.traverser.ProcessNodeInterface;
import com.sun.j3d.demos.utils.scenegraph.traverser.TreeScan;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.EventHandler;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.Appearance;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.Node;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Raster;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TextureUnitState;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.sf.nwn.loader.AnimationBehavior;
import net.sf.nwn.loader.ParticleCollection;
import net.sf.nwn.loader.Walkmesh;
import net.sf.nwn.viewer.AnimPanel;
import net.sf.nwn.viewer.Display;

public class ControlPanel
extends JPanel {
    private AnimationBehavior anim;
    private AnimPanel animPanel;
    private Display display;
    private Walkmesh walkmesh;
    private JTabbedPane tabs = new JTabbedPane(3);
    private float currentExplosion = 1.0f;
    JRadioButton[] polygonModes = new JRadioButton[3];
    JRadioButton[] cullFaces = new JRadioButton[3];
    JCheckBox skeleton = new JCheckBox("Show skeleton", false);
    JCheckBox skeletonLabelsCB = new JCheckBox("Show labels", false);
    JCheckBox geometry = new JCheckBox("Show geometry", true);
    JCheckBox reflective = new JCheckBox("Enabled", true);
    JCheckBox reflectionBlend = new JCheckBox("Combine", true);
    JCheckBox maintex = new JCheckBox("Enabled", true);
    JCheckBox maintexTransp = new JCheckBox("Light blend", true);
    JCheckBox walkmeshCB = new JCheckBox("Walkmesh", false);
    JSlider animSlider = new JSlider();
    private static final int TEX_METAL = 1;
    private static final int TEX_MAIN = 0;
    int lastPoly = 2;
    int lastFace = 1;
    private BranchGroup skeletonGroup;
    private boolean skeletonLabels;
    private Transform3D t3 = new Transform3D();
    private Transform3D tt = new Transform3D();
    private Vector3f v = new Vector3f();
    private Point3f p = new Point3f();
    private Font font = new Font("monospaced", 0, 12);
    private FontRenderContext renderContext = new FontRenderContext(null, true, false);
    private boolean geometryShown = true;
    private BranchGroup gridGroup;
    private boolean gridVisible;

    public ControlPanel(Display display, AnimPanel animPanel) {
        this.animPanel = animPanel;
        this.display = display;
        this.setLayout(new BorderLayout());
        this.add("Center", this.tabs);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new TitledBorder("Explode parts"));
        final JTextField jTextField = new JTextField(5);
        jTextField.setText("1.0");
        jPanel2.add(jTextField);
        JButton jButton = new JButton("Explode");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    float f = Float.parseFloat(jTextField.getText());
                    if (ControlPanel.this.anim == null) {
                        return;
                    }
                    ControlPanel.this.explodeTransforms(ControlPanel.this.anim.getNamedTransforms().values(), f / ControlPanel.this.currentExplosion);
                    ControlPanel.this.currentExplosion = f;
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(ControlPanel.this, numberFormatException, "Wrong scale", 0);
                }
            }
        });
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        this.skeleton.addChangeListener(EventHandler.create(ChangeListener.class, this, "showSkeleton", "source.selected"));
        jPanel.add(this.skeleton);
        this.skeletonLabelsCB.addChangeListener(EventHandler.create(ChangeListener.class, this, "showSkeletonLabels", "source.selected"));
        this.skeletonLabelsCB.setEnabled(false);
        jPanel.add(this.skeletonLabelsCB);
        this.geometry.addChangeListener(EventHandler.create(ChangeListener.class, this, "showGeometry", "source.selected"));
        jPanel.add(this.geometry);
        JCheckBox jCheckBox = new JCheckBox("Show grid", false);
        jCheckBox.addChangeListener(EventHandler.create(ChangeListener.class, this, "showGrid", "source.selected"));
        jPanel.add(jCheckBox);
        this.walkmeshCB.addChangeListener(EventHandler.create(ChangeListener.class, this, "showWalkmesh", "source.selected"));
        jPanel.add(this.walkmeshCB);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new TitledBorder("Reflection map"));
        jPanel4.setLayout(new GridLayout(2, 1));
        this.reflective.addChangeListener(new ChangeListener(){
            boolean pstate = true;

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ControlPanel.this.reflective.isSelected() == this.pstate) {
                    return;
                }
                this.pstate = ControlPanel.this.reflective.isSelected();
                ControlPanel.this.setTextureUnitState(1, ControlPanel.this.reflective.isSelected());
                ControlPanel.this.reflectionBlend.setEnabled(ControlPanel.this.reflective.isSelected());
            }
        });
        this.reflectionBlend.addChangeListener(new ChangeListener(){
            boolean pstate = true;

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ControlPanel.this.reflectionBlend.isSelected() == this.pstate) {
                    return;
                }
                this.pstate = ControlPanel.this.reflectionBlend.isSelected();
                if (ControlPanel.this.reflectionBlend.isSelected()) {
                    ControlPanel.this.setTextureUnitMode(1, 6);
                } else {
                    ControlPanel.this.setTextureUnitMode(1, 5);
                }
            }
        });
        jPanel4.add(this.reflective);
        jPanel4.add(this.reflectionBlend);
        jPanel3.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(2, 1));
        jPanel5.setBorder(new TitledBorder("Main texture"));
        this.maintex.addChangeListener(new ChangeListener(){
            boolean pstate = true;

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ControlPanel.this.maintex.isSelected() == this.pstate) {
                    return;
                }
                this.pstate = ControlPanel.this.maintex.isSelected();
                ControlPanel.this.setTextureUnitState(0, ControlPanel.this.maintex.isSelected());
                ControlPanel.this.maintexTransp.setEnabled(ControlPanel.this.maintex.isSelected());
            }
        });
        this.maintexTransp.addChangeListener(new ChangeListener(){
            boolean pstate = true;

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ControlPanel.this.maintexTransp.isSelected() == this.pstate) {
                    return;
                }
                this.pstate = ControlPanel.this.maintexTransp.isSelected();
                if (ControlPanel.this.maintexTransp.isSelected()) {
                    ControlPanel.this.setTextureUnitMode(0, 2);
                } else {
                    ControlPanel.this.setTextureUnitMode(0, 5);
                }
            }
        });
        jPanel5.add(this.maintex);
        jPanel5.add(this.maintexTransp);
        jPanel3.add(jPanel5);
        ChangeListener changeListener = EventHandler.create(ChangeListener.class, this, "updatePolygonMode");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(3, 1));
        jPanel6.setBorder(new TitledBorder("Polygon fill"));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("Fill", true);
        jRadioButton.addChangeListener(changeListener);
        buttonGroup.add(jRadioButton);
        this.polygonModes[0] = jRadioButton;
        jPanel6.add(jRadioButton);
        jRadioButton = new JRadioButton("Line");
        jRadioButton.addChangeListener(changeListener);
        buttonGroup.add(jRadioButton);
        this.polygonModes[1] = jRadioButton;
        jPanel6.add(jRadioButton);
        jRadioButton = new JRadioButton("Point");
        jRadioButton.addChangeListener(changeListener);
        buttonGroup.add(jRadioButton);
        this.polygonModes[2] = jRadioButton;
        jPanel6.add(jRadioButton);
        jPanel3.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(3, 1));
        jPanel7.setBorder(new TitledBorder("Cull faces"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        jRadioButton = new JRadioButton("Cull back", true);
        jRadioButton.addChangeListener(changeListener);
        buttonGroup2.add(jRadioButton);
        this.cullFaces[0] = jRadioButton;
        jPanel7.add(jRadioButton);
        jRadioButton = new JRadioButton("Cull front");
        jRadioButton.addChangeListener(changeListener);
        buttonGroup2.add(jRadioButton);
        this.cullFaces[1] = jRadioButton;
        jPanel7.add(jRadioButton);
        jRadioButton = new JRadioButton("Cull none");
        jRadioButton.addChangeListener(changeListener);
        buttonGroup2.add(jRadioButton);
        this.cullFaces[2] = jRadioButton;
        jPanel7.add(jRadioButton);
        jPanel3.add(jPanel7);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout());
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 0));
        jPanel9.setBorder(new TitledBorder("Time scale"));
        final JTextField jTextField2 = new JTextField(5);
        jTextField2.setText("1.0");
        jPanel9.add(jTextField2);
        JButton jButton2 = new JButton("Set Scale");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    float f = Float.parseFloat(jTextField2.getText());
                    if (ControlPanel.this.anim == null) {
                        return;
                    }
                    ControlPanel.this.anim.setAnimationTimeScale(f);
                }
                catch (NumberFormatException numberFormatException) {
                    JOptionPane.showMessageDialog(ControlPanel.this, numberFormatException, "Wrong scale", 0);
                }
            }
        });
        jPanel9.add(jButton2);
        jPanel8.add(jPanel9);
        JCheckBox jCheckBox2 = new JCheckBox("Loop animation");
        jCheckBox2.addChangeListener(EventHandler.create(ChangeListener.class, this.animPanel, "animationLoop", "source.selected"));
        jPanel8.add(jCheckBox2);
        JPanel jPanel10 = new JPanel();
        jPanel10.setBorder(new TitledBorder("Default animations"));
        jPanel10.setLayout(new GridLayout(1, 2));
        JButton jButton3 = new JButton("Display");
        JButton jButton4 = new JButton("Set");
        jButton3.addActionListener(EventHandler.create(ActionListener.class, this.animPanel, "showDefaultAnimations"));
        jButton4.addActionListener(EventHandler.create(ActionListener.class, this.animPanel, "setDefaultAnimations"));
        jPanel10.add(jButton3);
        jPanel10.add(jButton4);
        jPanel8.add(jPanel10);
        this.animSlider.setMinimum(0);
        this.animSlider.setMaximum(512);
        this.animSlider.setBorder(new TitledBorder("Animation Slider"));
        this.animSlider.addChangeListener(EventHandler.create(ChangeListener.class, this, "animSliderMoved"));
        jPanel8.add(this.animSlider);
        this.tabs.addTab("Geometry", jPanel);
        this.tabs.addTab("Appearance", jPanel3);
        this.tabs.addTab("Animation", jPanel8);
    }

    public void setAnimationBehavior(AnimationBehavior animationBehavior, Walkmesh walkmesh) {
        this.anim = animationBehavior;
        this.currentExplosion = 1.0f;
        this.skeleton.setSelected(false);
        this.geometry.setSelected(true);
        this.reflective.setSelected(true);
        this.reflectionBlend.setSelected(true);
        this.maintex.setSelected(true);
        this.maintexTransp.setSelected(true);
        this.polygonModes[0].setSelected(true);
        this.cullFaces[0].setSelected(true);
        this.walkmesh = walkmesh;
        this.walkmeshCB.setSelected(false);
        this.walkmeshCB.setEnabled(this.walkmesh != null);
    }

    public void explodeTransforms(Collection collection, float f) {
        Vector3f vector3f = new Vector3f();
        Transform3D transform3D = new Transform3D();
        for (Object e : collection) {
            if (!(e instanceof TransformGroup)) continue;
            TransformGroup transformGroup = (TransformGroup)e;
            transformGroup.getTransform(transform3D);
            transform3D.get(vector3f);
            vector3f.scale(f);
            transform3D.setTranslation(vector3f);
            transformGroup.setTransform(transform3D);
        }
    }

    public void setTextureUnitState(final int n, final boolean bl) {
        ControlPanel.treeScan(new AppearanceChangeProcessor(){

            @Override
            public void changeAppearance(Shape3D shape3D, Appearance appearance) {
                if (shape3D instanceof ParticleCollection || shape3D instanceof Walkmesh) {
                    return;
                }
                if (n == 1 && appearance.getTextureUnitCount() == 1) {
                    return;
                }
                TextureUnitState textureUnitState = appearance.getTextureUnitState(n);
                if (textureUnitState != null) {
                    textureUnitState.getTexture().setEnable(bl);
                }
            }
        }, (Node)this.display.getModelGroup());
    }

    public void setTextureUnitMode(final int n, final int n2) {
        ControlPanel.treeScan(new AppearanceChangeProcessor(){

            @Override
            public void changeAppearance(Shape3D shape3D, Appearance appearance) {
                if (shape3D instanceof ParticleCollection || shape3D instanceof Walkmesh) {
                    return;
                }
                if (n == 1 && appearance.getTextureUnitCount() == 1) {
                    return;
                }
                TextureUnitState textureUnitState = appearance.getTextureUnitState(n);
                if (textureUnitState != null) {
                    textureUnitState.getTextureAttributes().setTextureMode(n2);
                }
            }
        }, (Node)this.display.getModelGroup());
    }

    public void updatePolygonMode() {
        int n = 2;
        int n2 = 1;
        if (this.polygonModes[1].isSelected()) {
            n = 1;
        } else if (this.polygonModes[2].isSelected()) {
            n = 0;
        }
        if (this.cullFaces[1].isSelected()) {
            n2 = 2;
        } else if (this.cullFaces[2].isSelected()) {
            n2 = 0;
        }
        if (this.lastPoly == n && this.lastFace == n2) {
            return;
        }
        this.lastPoly = n;
        this.lastFace = n2;
        final int n3 = n;
        final int n4 = n2;
        ControlPanel.treeScan(new AppearanceChangeProcessor(){

            @Override
            public void changeAppearance(Shape3D shape3D, Appearance appearance) {
                if (shape3D instanceof Walkmesh) {
                    return;
                }
                PolygonAttributes polygonAttributes = new PolygonAttributes(n3, n4, 0.0f);
                appearance.setPolygonAttributes(polygonAttributes);
            }
        }, (Node)this.display.getModelGroup());
    }

    public static void treeScan(ProcessNodeInterface processNodeInterface, Node node) {
        TreeScan.findNode(node, Shape3D.class, processNodeInterface, false, false);
    }

    public void showSkeletonLabels(boolean bl) {
        if (this.skeletonGroup == null) {
            this.skeletonLabels = bl;
        } else if (this.skeletonLabels != bl && this.skeletonGroup != null) {
            this.showSkeleton(true, bl);
        }
    }

    public void showSkeleton(boolean bl) {
        this.showSkeleton(bl, this.skeletonLabels);
    }

    public void showSkeleton(boolean bl, boolean bl2) {
        this.skeletonLabelsCB.setEnabled(bl);
        BranchGroup branchGroup = this.display.getScene();
        if (!(this.skeletonGroup == null || bl && bl2 == this.skeletonLabels)) {
            branchGroup.removeChild((Node)this.skeletonGroup);
            this.skeletonGroup = null;
        }
        if (bl && this.anim != null && this.skeletonGroup == null) {
            TransformGroup transformGroup;
            Raster[] rasterArray;
            Node node;
            TransformGroup transformGroup22;
            this.skeletonLabels = bl2;
            this.skeletonGroup = new BranchGroup();
            this.skeletonGroup.setCapability(17);
            final Collection collection = this.anim.getNamedTransforms().values();
            final PointArray pointArray = new PointArray(collection.size(), 1);
            pointArray.setCapability(1);
            Appearance appearance = new Appearance();
            appearance.setPointAttributes(new PointAttributes(8.0f, true));
            appearance.setRenderingAttributes(new RenderingAttributes(false, true, 0.0f, 0));
            appearance.setTransparencyAttributes(new TransparencyAttributes(2, 0.3f));
            Shape3D shape3D = new Shape3D((Geometry)pointArray, appearance);
            final IndexedLineArray indexedLineArray = new IndexedLineArray(collection.size(), 513, collection.size() * 2 - 2);
            indexedLineArray.setCapability(1);
            int n = 0;
            HashMap hashMap = new HashMap();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                hashMap.put(iterator.next(), new Integer(n++));
            }
            n = 0;
            for (TransformGroup transformGroup22 : collection) {
                for (int i = 0; i < transformGroup22.numChildren(); ++i) {
                    node = transformGroup22.getChild(i);
                    if (!(node instanceof TransformGroup)) continue;
                    indexedLineArray.setCoordinateIndex(n * 2, ((Integer)hashMap.get(transformGroup22)).intValue());
                    indexedLineArray.setCoordinateIndex(n * 2 + 1, ((Integer)hashMap.get(node)).intValue());
                    ++n;
                }
            }
            transformGroup22 = new Shape3D((Geometry)indexedLineArray, appearance);
            final LineArray lineArray = new LineArray(collection.size() * 6, 5);
            lineArray.setCapability(1);
            lineArray.setCapability(3);
            node = new Color3f(0.0f, 1.0f, 0.0f);
            Color3f color3f = new Color3f(1.0f, 0.0f, 0.0f);
            for (int i = 0; i < collection.size(); ++i) {
                lineArray.setColor(i * 6, (Color3f)node);
                lineArray.setColor(i * 6 + 1, color3f);
                lineArray.setColor(i * 6 + 2, (Color3f)node);
                lineArray.setColor(i * 6 + 3, color3f);
                lineArray.setColor(i * 6 + 4, (Color3f)node);
                lineArray.setColor(i * 6 + 5, color3f);
            }
            Shape3D shape3D2 = new Shape3D((Geometry)lineArray, appearance);
            Raster[] rasterArray2 = rasterArray = this.skeletonLabels ? new Raster[collection.size()] : null;
            if (this.skeletonLabels) {
                iterator = collection.iterator();
                for (int i = 0; i < collection.size(); ++i) {
                    transformGroup = (TransformGroup)iterator.next();
                    Raster raster = this.createLabel(transformGroup.getUserData().toString());
                    Shape3D shape3D3 = new Shape3D((Geometry)raster, appearance);
                    rasterArray[i] = raster;
                    this.skeletonGroup.addChild((Node)shape3D3);
                }
            }
            this.setCoords((GeometryArray)pointArray, (GeometryArray)indexedLineArray, (GeometryArray)lineArray, rasterArray, collection);
            Behavior behavior = new Behavior(){
                private WakeupOnElapsedFrames wakeup = new WakeupOnElapsedFrames(1, false);

                public void initialize() {
                    this.wakeupOn((WakeupCondition)this.wakeup);
                }

                public void processStimulus(Enumeration enumeration) {
                    ControlPanel.this.setCoords((GeometryArray)pointArray, (GeometryArray)indexedLineArray, (GeometryArray)lineArray, rasterArray, collection);
                    this.wakeupOn((WakeupCondition)this.wakeup);
                }
            };
            transformGroup = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 20.0);
            behavior.setSchedulingBounds((Bounds)transformGroup);
            shape3D.setBoundsAutoCompute(false);
            shape3D.setBounds((Bounds)transformGroup);
            transformGroup22.setBoundsAutoCompute(false);
            transformGroup22.setBounds((Bounds)transformGroup);
            shape3D2.setBoundsAutoCompute(false);
            shape3D2.setBounds((Bounds)transformGroup);
            this.skeletonGroup.addChild((Node)shape3D);
            this.skeletonGroup.addChild((Node)transformGroup22);
            this.skeletonGroup.addChild((Node)shape3D2);
            this.skeletonGroup.addChild((Node)behavior);
            branchGroup.addChild((Node)this.skeletonGroup);
        }
    }

    private void setCoords(GeometryArray geometryArray, GeometryArray geometryArray2, GeometryArray geometryArray3, Raster[] rasterArray, Collection collection) {
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TransformGroup transformGroup = (TransformGroup)iterator.next();
            transformGroup.getLocalToVworld(this.t3);
            transformGroup.getTransform(this.tt);
            this.t3.mul(this.tt);
            this.t3.get(this.v);
            this.p.set((Tuple3f)this.v);
            geometryArray.setCoordinate(n, this.p);
            geometryArray2.setCoordinate(n, this.p);
            geometryArray3.setCoordinate(n * 6, this.p);
            geometryArray3.setCoordinate(n * 6 + 2, this.p);
            geometryArray3.setCoordinate(n * 6 + 4, this.p);
            if (rasterArray != null) {
                rasterArray[n].setPosition(this.p);
            }
            float f = 0.1f;
            this.v.set(f, 0.0f, 0.0f);
            this.t3.transform(this.v);
            this.p.add((Tuple3f)this.v);
            geometryArray3.setCoordinate(n * 6 + 1, this.p);
            this.p.sub((Tuple3f)this.v);
            this.v.set(0.0f, f, 0.0f);
            this.t3.transform(this.v);
            this.p.add((Tuple3f)this.v);
            geometryArray3.setCoordinate(n * 6 + 3, this.p);
            this.p.sub((Tuple3f)this.v);
            this.v.set(0.0f, 0.0f, f);
            this.t3.transform(this.v);
            this.p.add((Tuple3f)this.v);
            geometryArray3.setCoordinate(n * 6 + 5, this.p);
            this.p.sub((Tuple3f)this.v);
            ++n;
        }
    }

    private Raster createLabel(String string) {
        Raster raster = new Raster();
        raster.setCapability(1);
        Rectangle2D rectangle2D = this.font.getStringBounds(string, this.renderContext);
        raster.setSize((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        raster.setType(1);
        raster.setClipMode(1);
        BufferedImage bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawString(string, 0, (int)(-rectangle2D.getY()));
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, bufferedImage);
        raster.setImage(imageComponent2D);
        return raster;
    }

    public void showGeometry(final boolean bl) {
        if (bl != this.geometryShown) {
            this.geometryShown = bl;
            ControlPanel.treeScan(new AppearanceChangeProcessor(){

                @Override
                public void changeAppearance(Shape3D shape3D, Appearance appearance) {
                    if (shape3D instanceof Walkmesh) {
                        return;
                    }
                    RenderingAttributes renderingAttributes = new RenderingAttributes();
                    renderingAttributes.setVisible(bl);
                    appearance.setRenderingAttributes(renderingAttributes);
                }
            }, (Node)this.display.getModelGroup());
        }
    }

    public void showGrid(boolean bl) {
        if (!bl && this.gridVisible) {
            this.gridVisible = false;
            this.display.getScene().removeChild((Node)this.gridGroup);
        } else if (bl && !this.gridVisible) {
            this.gridVisible = true;
            if (this.gridGroup == null) {
                this.gridGroup = this.createGridGroup();
            }
            this.display.getScene().addChild((Node)this.gridGroup);
        }
    }

    private BranchGroup createGridGroup() {
        int n;
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.clearCapabilityIsFrequent(17);
        LineArray lineArray = new LineArray(56, 5);
        Color3f color3f = new Color3f(0.0f, 0.0f, 0.9f);
        int n2 = 0;
        Point3f point3f = new Point3f();
        for (n = -5; n <= 5; ++n) {
            point3f.set((float)n, -5.0f, 0.0f);
            lineArray.setColor(n2, color3f);
            lineArray.setCoordinate(n2++, point3f);
            point3f.set((float)n, 5.0f, 0.0f);
            lineArray.setColor(n2, color3f);
            lineArray.setCoordinate(n2++, point3f);
            point3f.set(-5.0f, (float)n, 0.0f);
            lineArray.setColor(n2, color3f);
            lineArray.setCoordinate(n2++, point3f);
            point3f.set(5.0f, (float)n, 0.0f);
            lineArray.setColor(n2, color3f);
            lineArray.setCoordinate(n2++, point3f);
        }
        for (n = 0; n < 3; ++n) {
            point3f.set(1.0f, -1.0f, (float)n);
            lineArray.setColor(n2, color3f);
            lineArray.setCoordinate(n2++, point3f);
            point3f.set(1.0f, -1.0f, (float)(n + 1));
            lineArray.setColor(n2, color3f);
            lineArray.setCoordinate(n2++, point3f);
            point3f.set(1.0f, -1.0f, (float)(n + 1));
            lineArray.setColor(n2, color3f);
            lineArray.setCoordinate(n2++, point3f);
            point3f.set(0.9f, -0.9f, (float)(n + 1));
            lineArray.setColor(n2, color3f);
            lineArray.setCoordinate(n2++, point3f);
        }
        Shape3D shape3D = new Shape3D((Geometry)lineArray);
        branchGroup.addChild((Node)shape3D);
        return branchGroup;
    }

    public void animSliderMoved() {
        if (this.anim != null) {
            this.anim.setExplicitAnimationStage((float)this.animSlider.getValue() / 512.0f);
        }
    }

    public void showWalkmesh(boolean bl) {
        if (this.walkmesh != null) {
            this.walkmesh.getAppearance().getRenderingAttributes().setVisible(bl);
        }
    }
}

