/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.ac3d;

import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.newdawn.j3d.loaders.ac3d.AC3DModel;
import org.newdawn.j3d.loaders.ac3d.AC3DSurface;
import org.newdawn.j3d.loaders.ac3d.tree.ShapeTree;
import org.newdawn.j3d.loaders.resourcepools.TextureResourcePool;
import org.newdawn.loaders.InvalidDataException;
import org.newdawn.loaders.resourcepools.ResourceLoadFailedException;

public class AC3DObject {
    private URL textureURL;
    private String texturePath;
    private Matrix3f rotation = null;
    private Vector3f location = null;
    private ArrayList surfaces = new ArrayList();
    private ArrayList kids = new ArrayList();
    private Transform3D transform = new Transform3D();
    private Transform3D adjustedTransform;
    private org.newdawn.loaders.ac3d.AC3DObject object;
    private AC3DObject parentObject = null;
    private AC3DModel theModel = null;
    private Point3f[] adjustedVerts;
    private Vector3f[] smoothedNormals;

    public AC3DObject(org.newdawn.loaders.ac3d.AC3DObject object, AC3DObject parentObject) throws InvalidDataException, ResourceLoadFailedException {
        if (object == null) {
            throw new NullPointerException("object must be non null");
        }
        if (parentObject == null) {
            throw new NullPointerException("parentObject must be non null");
        }
        this.object = object;
        this.parentObject = parentObject;
        this.init();
    }

    public AC3DObject(org.newdawn.loaders.ac3d.AC3DObject object, AC3DModel theModel) throws InvalidDataException, ResourceLoadFailedException {
        if (object == null) {
            throw new NullPointerException("object must be non null");
        }
        if (theModel == null) {
            throw new NullPointerException("theModel must be non null");
        }
        this.object = object;
        this.theModel = theModel;
        this.init();
    }

    private void init() throws InvalidDataException, ResourceLoadFailedException {
        float[][] vertData = this.object.getVerticies();
        this.transform.set(new Matrix3f(this.object.getRotation()));
        this.transform.setTranslation(new Vector3f(this.object.getLocation()));
        this.adjustedTransform = new Transform3D(this.transform);
        if (this.parentObject != null) {
            this.adjustedTransform.mul(this.parentObject.getAdjustedTransform());
        }
        this.texturePath = this.parentObject != null ? this.parentObject.getTexturePath() : this.theModel.getTexturePath();
        if (this.object.getTextureName() != null) {
            try {
                this.textureURL = new URL(this.texturePath + this.object.getTextureName());
            }
            catch (MalformedURLException e) {
                throw new InvalidDataException("Texture URL \"" + this.texturePath + this.object.getTextureName() + "\" is invalid");
            }
            TextureResourcePool.getTexture(this.textureURL);
        }
        Iterator objIt = this.object.getKids().iterator();
        while (objIt.hasNext()) {
            this.kids.add(new AC3DObject((org.newdawn.loaders.ac3d.AC3DObject)objIt.next(), this));
        }
        this.adjustedVerts = new Point3f[vertData.length];
        for (int i = 0; i < this.adjustedVerts.length; ++i) {
            this.adjustedVerts[i] = new Point3f(vertData[i][0], vertData[i][1], vertData[i][2]);
            this.adjustedTransform.transform(this.adjustedVerts[i]);
        }
        this.generateSmoothedNormalArray(this.object);
        ArrayList realSurfaces = this.object.getSurfaces();
        Iterator surfIt = realSurfaces.iterator();
        int surfCount = 0;
        while (surfIt.hasNext()) {
            org.newdawn.loaders.ac3d.AC3DSurface realSurf = (org.newdawn.loaders.ac3d.AC3DSurface)surfIt.next();
            this.surfaces.add(new AC3DSurface(realSurf, this));
            ++surfCount;
        }
    }

    private void generateSmoothedNormalArray(org.newdawn.loaders.ac3d.AC3DObject object) {
        ArrayList realSurfaces = object.getSurfaces();
        int[] strips = new int[realSurfaces.size()];
        int[][] coordTemp = new int[realSurfaces.size()][];
        int totalVerts = 0;
        for (int i = 0; i < realSurfaces.size(); ++i) {
            org.newdawn.loaders.ac3d.AC3DSurface current = (org.newdawn.loaders.ac3d.AC3DSurface)realSurfaces.get(i);
            int[] vertexReferences = current.getVertexReferences();
            strips[i] = vertexReferences.length;
            coordTemp[i] = vertexReferences;
            totalVerts += vertexReferences.length;
        }
        int c = 0;
        Point3f[] coords = new Point3f[totalVerts];
        for (int i = 0; i < realSurfaces.size(); ++i) {
            for (int j = 0; j < coordTemp[i].length; ++j) {
                coords[c] = this.adjustedVerts[coordTemp[i][j]];
                ++c;
            }
        }
        GeometryInfo geoInfo = new GeometryInfo(5);
        geoInfo.setCoordinates(coords);
        geoInfo.setStripCounts(strips);
        new NormalGenerator(Math.PI).generateNormals(geoInfo);
        this.smoothedNormals = new Vector3f[this.adjustedVerts.length];
        Vector3f[] duplicateNormals = geoInfo.getNormals();
        int[] normalIndex = geoInfo.getNormalIndices();
        c = 0;
        for (int i = 0; i < realSurfaces.size(); ++i) {
            for (int j = 0; j < coordTemp[i].length; ++j) {
                this.smoothedNormals[coordTemp[i][j]] = duplicateNormals[normalIndex[c]];
                ++c;
            }
        }
    }

    public Transform3D getAdjustedTransform() {
        return new Transform3D(this.adjustedTransform);
    }

    public Point3f[] getAdjustedVertecies() {
        if (this.adjustedVerts == null) {
            System.out.println("adjustedVerts is null");
        }
        return this.adjustedVerts;
    }

    public Vector3f[] getSmoothedNormals() {
        if (this.smoothedNormals == null) {
            System.out.println("smoothedNormals is null");
        }
        return this.smoothedNormals;
    }

    public float getTextureOffsetX() {
        return this.object.getTextureOffsetX();
    }

    public float getTextureOffsetY() {
        return this.object.getTextureOffsetY();
    }

    public float getTextureRepeatX() {
        return this.object.getTextureRepeatX();
    }

    public float getTextureRepeatY() {
        return this.object.getTextureRepeatY();
    }

    public String getTexturePath() {
        return this.texturePath;
    }

    public void addShapeTreeToTree(ShapeTree tree) {
        ShapeTree subTree = new ShapeTree();
        this.addSurfacesToTree(subTree, false);
        tree.addTree(subTree);
    }

    public void addSurfacesToTree(ShapeTree tree) {
        this.addSurfacesToTree(tree, true);
    }

    public void addSurfacesToTree(ShapeTree tree, boolean optimise) {
        Iterator objIt = this.kids.iterator();
        Iterator surfIt = this.surfaces.iterator();
        while (objIt.hasNext()) {
            if (optimise) {
                ((AC3DObject)objIt.next()).addSurfacesToTree(tree);
                continue;
            }
            ((AC3DObject)objIt.next()).addShapeTreeToTree(tree);
        }
        while (surfIt.hasNext()) {
            String textureURLasString = null;
            if (this.textureURL != null) {
                textureURLasString = this.textureURL.toString();
            }
            tree.addSurface((AC3DSurface)surfIt.next(), textureURLasString);
        }
    }
}

