/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.bsp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.vecmath.Point2f;
import javax.vecmath.Point3f;
import org.newdawn.j3d.loaders.bsp.BSPHeader;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;

public class BSPTextureLump {
    private TextureInfo[] texs;

    public BSPTextureLump(BSPHeader header, InputStream file) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(file));
        int len = header.getLength(5);
        this.texs = new TextureInfo[len / 76];
        int offset = header.getOffset(5);
        in.skip(offset);
        int i = 0;
        while (i < this.texs.length) {
            this.texs[i] = new TextureInfo(in);
            ++i;
        }
        in.close();
    }

    public String getTextureName(int i) {
        return this.texs[i].textureName;
    }

    public int getFlags(int i) {
        return this.texs[i].flags;
    }

    public Point2f getPoint(int i, Point3f p, float w, float h) {
        Point3f pt = new Point3f(-p.x, p.z, p.y);
        TextureInfo info = this.texs[i];
        float u = pt.x * info.u_axis[0] + pt.y * info.u_axis[1] + pt.z * info.u_axis[2] + info.u_offset;
        float v = pt.x * info.v_axis[0] + pt.y * info.v_axis[1] + pt.z * info.v_axis[2] + info.v_offset;
        return new Point2f(u /= w, v /= -h);
    }

    private class TextureInfo {
        public float[] u_axis = new float[3];
        public float u_offset;
        public float[] v_axis = new float[3];
        public float v_offset;
        public int flags;
        public int value;
        public String textureName;
        public int nextTexinfo;

        public TextureInfo(LittleEndianDataInputStream in) throws IOException {
            int i = 0;
            while (i < 3) {
                this.u_axis[i] = in.readFloat();
                ++i;
            }
            this.u_offset = in.readFloat();
            int i2 = 0;
            while (i2 < 3) {
                this.v_axis[i2] = in.readFloat();
                ++i2;
            }
            this.v_offset = in.readFloat();
            this.flags = in.readInt();
            this.value = in.readInt();
            if (this.value > 0) {
                int i3 = 0;
                while (i3 < 3) {
                    int n = i3;
                    this.v_axis[n] = this.v_axis[n] / (float)this.value;
                    int n2 = i3++;
                    this.u_axis[n2] = this.u_axis[n2] / (float)this.value;
                }
            }
            byte[] name = new byte[32];
            in.read(name, 0, 32);
            int i4 = 0;
            while (i4 < 32) {
                if (name[i4] == 0) break;
                ++i4;
            }
            this.textureName = new String(name, 0, i4);
            this.nextTexinfo = in.readInt();
        }
    }
}

