/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md3;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.media.j3d.Node;
import org.newdawn.j3d.loaders.DefaultNodeFactory;
import org.newdawn.j3d.loaders.ModelLoadingException;
import org.newdawn.j3d.loaders.NodeFactory;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.md3.MD3AnimConfig;
import org.newdawn.j3d.loaders.md3.MD3Frame;
import org.newdawn.j3d.loaders.md3.MD3Header;
import org.newdawn.j3d.loaders.md3.MD3Mesh;
import org.newdawn.j3d.loaders.md3.MD3Model;
import org.newdawn.j3d.loaders.md3.MD3ModelPart;
import org.newdawn.j3d.loaders.md3.MD3Skins;

public class MD3Loader {
    private MD3ModelPart loadMD3(String path, String part, String skinName, NodeFactory factory, MD3AnimConfig anim, ArrayList filter) throws IOException {
        InputStream skin = ClassLoader.getSystemResourceAsStream(path + "/" + part + "_" + skinName + ".skin");
        if (skin == null) {
            throw new IOException("Could not find resource: " + part + "_" + skinName + ".skin");
        }
        MD3Skins skins = new MD3Skins(new DataInputStream(skin), path);
        skin.close();
        InputStream in = ClassLoader.getSystemResourceAsStream(path + "/" + part + ".md3");
        if (in == null) {
            throw new IOException("Could not find resource: " + part + ".md3");
        }
        LittleEndianDataInputStream din = new LittleEndianDataInputStream(new DataInputStream(in));
        MD3Header header = new MD3Header(din);
        din.close();
        in = ClassLoader.getSystemResourceAsStream(path + "/" + part + ".md3");
        din = new LittleEndianDataInputStream(new DataInputStream(in));
        header.skipToMeshs(din);
        MD3Frame[] buffer = null;
        int i = 0;
        while (i < header.getMeshCount()) {
            MD3Mesh m = new MD3Mesh(header, din);
            int frames = m.getFrameCount();
            if (buffer == null) {
                buffer = new MD3Frame[frames];
            }
            int f = 0;
            while (f < frames) {
                if (this.useFrame(f, anim, filter, part)) {
                    if (buffer[f] == null) {
                        buffer[f] = new MD3Frame(header.getTransformMap(f));
                    }
                    buffer[f].addChild((Node)m.renderFrame(f, skins, factory));
                }
                ++f;
            }
            ++i;
        }
        in.close();
        return new MD3ModelPart(part, buffer);
    }

    public boolean useFrame(int f, MD3AnimConfig anim, ArrayList filter, String part) {
        if (filter == null) {
            return true;
        }
        if (f == 0) {
            return true;
        }
        int type = 1;
        if (part.equals("lower")) {
            type = 3;
        }
        if (part.equals("upper")) {
            type = 2;
        }
        String name = anim.getAnimationForFrame(f, type);
        boolean b = filter.contains(name);
        return b;
    }

    public MD3Model loadCharacterModel(String prefix) throws ModelLoadingException {
        return this.loadCharacterModel(prefix, "default");
    }

    public MD3Model loadCharacterModel(String prefix, String skinName) throws ModelLoadingException {
        return this.loadCharacterModel(prefix, skinName, new DefaultNodeFactory());
    }

    public MD3Model loadCharacterModel(String prefix, NodeFactory factory) throws ModelLoadingException {
        return this.loadCharacterModel(prefix, "default", factory);
    }

    public MD3Model loadCharacterModel(String prefix, String skinName, NodeFactory factory) throws ModelLoadingException {
        return this.loadCharacterModel(prefix, skinName, factory, null);
    }

    public MD3Model loadCharacterModel(String prefix, String skinName, NodeFactory factory, ArrayList filter) throws ModelLoadingException {
        try {
            InputStream aio = ClassLoader.getSystemResourceAsStream(prefix + "/animation.cfg");
            if (aio == null) {
                throw new IOException("Could not find resource: animation.cfg");
            }
            MD3AnimConfig anim = new MD3AnimConfig(new DataInputStream(aio));
            MD3ModelPart legs = this.loadMD3(prefix, "lower", skinName, factory, anim, filter);
            MD3ModelPart torso = this.loadMD3(prefix, "upper", skinName, factory, anim, filter);
            MD3ModelPart head = this.loadMD3(prefix, "head", skinName, factory, anim, null);
            MD3Model model = new MD3Model(anim);
            model.addPart(legs);
            model.addPart(torso, 0, "tag_torso");
            model.addPart(head, 1, "tag_head");
            return model;
        }
        catch (IOException e) {
            throw new ModelLoadingException("Failed to load model: " + e.getMessage());
        }
    }
}

