/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md3;

import java.util.HashMap;
import java.util.Iterator;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import org.newdawn.j3d.loaders.md3.MD3PartInstance;

public class MD3ModelInstance
extends BranchGroup {
    private HashMap map = new HashMap();

    public MD3ModelInstance(MD3PartInstance[] parts) {
        Transform3D form = new Transform3D();
        form.setScale(0.04);
        Transform3D rot = new Transform3D();
        rot.rotX(Math.toRadians(-90.0));
        form.mul(rot);
        TransformGroup g = new TransformGroup(form);
        g.addChild((Node)parts[0]);
        int i = 0;
        while (i < parts.length) {
            this.map.put(parts[i].getName(), parts[i]);
            ++i;
        }
        this.addChild((Node)g);
        this.setAnimation("upper", "Stand");
        this.setAnimation("lower", "Idle");
        this.nextFrame("upper");
        this.nextFrame("lower");
        int i2 = 0;
        while (i2 < parts.length) {
            parts[i2].setFrame();
            ++i2;
        }
    }

    public void setUserData(Object data) {
        Iterator i = this.map.values().iterator();
        while (i.hasNext()) {
            MD3PartInstance instance = (MD3PartInstance)i.next();
            instance.setUserData(data);
        }
    }

    public void setAnimation(String part, String anim) {
        MD3PartInstance ins = (MD3PartInstance)this.map.get(part);
        if (ins == null) {
            System.out.println("PART NOT FOUND: " + part);
            return;
        }
        ins.setAnimation(anim);
    }

    public void nextFrame(String part) {
        MD3PartInstance ins = (MD3PartInstance)this.map.get(part);
        if (ins == null) {
            System.out.println("PART NOT FOUND: " + part);
            return;
        }
        ins.nextFrame();
    }
}

