/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.pcx;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.j3d.Texture;
import org.newdawn.j3d.loaders.cio.ByteArrayBuilder;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.pcx.PCXPalette;

public class PCXLoader {
    private PCXHeader header;
    private BufferedImage image;
    private PCXPalette pal;

    public PCXLoader(InputStream file) throws IOException {
        byte[] data = ByteArrayBuilder.fromStream(file);
        file.close();
        this.header = new PCXHeader(data);
        this.pal = new PCXPalette(new ByteArrayInputStream(data));
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        ((InputStream)in).skip(128L);
        int width = this.header.xmax - this.header.xmin;
        int height = this.header.ymax - this.header.ymin;
        this.image = new BufferedImage(width, height, 2);
        int xp = 0;
        int yp = 0;
        block0: while (yp < height) {
            int count;
            int value = ((InputStream)in).read();
            if (value >= 192) {
                count = value - 192;
                value = ((InputStream)in).read();
            } else {
                count = 1;
            }
            int i = 0;
            while (i < count) {
                if (xp < width) {
                    this.image.setRGB(xp, yp, this.pal.getColor(value));
                }
                if (++xp == this.header.bytesPerLine) {
                    xp = 0;
                    ++yp;
                    continue block0;
                }
                ++i;
            }
        }
        ((InputStream)in).close();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Texture getTexture(boolean yup) {
        if (yup) {
            return new TextureLoader(this.getImage(), 4).getTexture();
        }
        return new TextureLoader(this.getImage()).getTexture();
    }

    private class PCXHeader {
        public byte manufacturer;
        public byte version;
        public byte encoding;
        public byte bitsPerPixel;
        public int xmin;
        public int ymin;
        public int xmax;
        public int ymax;
        public int hdpi;
        public int vdpi;
        public byte[] colormap = new byte[48];
        public byte reserved;
        public byte planes;
        public int bytesPerLine;

        public PCXHeader(byte[] data) throws IOException {
            LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(new ByteArrayInputStream(data)));
            this.manufacturer = (byte)in.read();
            this.version = (byte)in.read();
            this.encoding = (byte)in.read();
            this.bitsPerPixel = (byte)in.read();
            this.xmin = in.readUnsignedShort();
            this.ymin = in.readUnsignedShort();
            this.xmax = in.readUnsignedShort();
            this.ymax = in.readUnsignedShort();
            this.hdpi = in.readUnsignedShort();
            this.vdpi = in.readUnsignedShort();
            in.read(this.colormap);
            this.reserved = (byte)in.read();
            this.planes = (byte)in.read();
            this.bytesPerLine = in.readUnsignedShort();
            in.close();
        }
    }
}

